/* 
 *     Copyright (c) 2017, NVIDIA CORPORATION.  All rights reserved.
 *
 * NVIDIA CORPORATION and its licensors retain all intellectual property
 * and proprietary rights in and to this software, related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA CORPORATION is strictly prohibited.
 *
 */

/*
 * Preincluded for openacc and emabled -D_ACC_DEFAULT_NEW:
 * C++ operators new() and delete() for the device must be visable 
 * Templates for placement new and placement delete  are available if needed
 */

#if defined(_ACCEL) && defined(_ACC_DEFAULT_NEW)

#include <stdlib.h> 
#include <new>

using namespace std;

static void* operator new( size_t n ) 
{
    void*  ptr;
    ptr = malloc(  n );
    return ptr;
}

static void* operator new( size_t n ,const std::nothrow_t & tt) 
{
    void*  ptr;
    ptr = malloc(  n );
    return ptr;
}

static void* operator new[]( size_t n ) 
{
    void*  ptr;
    ptr = malloc(  n );
    return ptr;
}

static void* operator new[]( size_t n,const std::nothrow_t & tt ) 
{
    void*  ptr;
    ptr = malloc(  n);
    return ptr;
}

static void operator delete( void* p ) 
{
    free(p);
}

static void operator delete[]( void* p )
{
    free(p);
}

#ifdef _UNUSED_PLACEMENT_EXAMPLE
/* placement new: put an object at a specific place.  
 * Defined by the user, specific to the user code
 * Are there changes required here ? 
 */ 

typedef float (*p_float)();
void* operator new( size_t n, p_float *heap, size_t heap_size ) NEW_NOTHROW
{
    return (n <= heap_size ? heap : 0);
}

void* operator new( size_t n, size_t sz, p_float* p ) NEW_NOTHROW
{
    return p;
}
#endif

#endif /* _ACCEL */
