/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.cellrenderer;

import com.formdev.flatlaf.util.ScaledImageIcon;
import java.awt.Dimension;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.cellrenderer.SelfEvictingSenderIconCache;
import mediathek.tool.cellrenderer.SenderCacheKey;
import mediathek.tool.sender_icon_cache.MVSenderIconCache;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;

public class CellRendererBase
extends DefaultTableCellRenderer {
    private final SelfEvictingSenderIconCache senderCellIconCache = new SelfEvictingSenderIconCache();

    protected void setSenderIcon(@NotNull String sender, @NotNull Dimension targetDim) {
        if (SystemUtils.IS_OS_LINUX) {
            targetDim.width -= 4;
            targetDim.height -= 4;
        }
        SenderCacheKey key = new SenderCacheKey(sender, targetDim);
        AtomicReference<Icon> cachedIcon = new AtomicReference<Icon>();
        cachedIcon.set(this.senderCellIconCache.getOrDefault(key, null));
        if (cachedIcon.get() == null) {
            MVSenderIconCache.get(sender).ifPresentOrElse(icon -> {
                Dimension imageDim = new Dimension(icon.getIconWidth(), icon.getIconHeight());
                Dimension destDim = GuiFunktionen.calculateFittedDimension(imageDim, targetDim);
                cachedIcon.set((Icon)new ScaledImageIcon(icon, destDim.width, destDim.height));
                this.senderCellIconCache.put(key, (Icon)cachedIcon.get());
            }, () -> cachedIcon.set(null));
        }
        if (cachedIcon.get() != null) {
            this.setText("");
            this.setIcon((Icon)cachedIcon.get());
        }
        this.setVerticalAlignment(0);
        this.setHorizontalAlignment(0);
    }

    protected Dimension getSenderCellDimension(@NotNull JTable table, int row, int columnModelIndex) {
        Dimension targetDim = new Dimension();
        targetDim.height = table.getRowHeight(row);
        targetDim.width = table.getColumnModel().getColumn(columnModelIndex).getWidth();
        targetDim.height -= 4;
        targetDim.width -= 4;
        return targetDim;
    }
}

