/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.convert.internal;

import com.fasterxml.classmate.ResolvedType;
import jakarta.persistence.AttributeConverter;
import org.hibernate.boot.model.convert.internal.AutoApplicableConverterDescriptorBypassedImpl;
import org.hibernate.boot.model.convert.internal.AutoApplicableConverterDescriptorStandardImpl;
import org.hibernate.boot.model.convert.spi.AutoApplicableConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.convert.spi.JpaAttributeConverterCreationContext;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.type.descriptor.converter.internal.AttributeConverterBean;
import org.hibernate.type.descriptor.converter.spi.JpaAttributeConverter;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;

class ConverterDescriptorImpl<X, Y>
implements ConverterDescriptor<X, Y> {
    private final Class<? extends AttributeConverter<X, Y>> converterType;
    private final ResolvedType domainTypeToMatch;
    private final ResolvedType relationalType;
    private final AutoApplicableConverterDescriptor autoApplyDescriptor;

    ConverterDescriptorImpl(Class<? extends AttributeConverter<X, Y>> converterType, ResolvedType domainTypeToMatch, ResolvedType relationalType, boolean autoApply) {
        this.converterType = converterType;
        this.domainTypeToMatch = domainTypeToMatch;
        this.relationalType = relationalType;
        this.autoApplyDescriptor = autoApply ? new AutoApplicableConverterDescriptorStandardImpl(this) : AutoApplicableConverterDescriptorBypassedImpl.INSTANCE;
    }

    @Override
    public Class<? extends AttributeConverter<X, Y>> getAttributeConverterClass() {
        return this.converterType;
    }

    @Override
    public ResolvedType getDomainValueResolvedType() {
        return this.domainTypeToMatch;
    }

    @Override
    public ResolvedType getRelationalValueResolvedType() {
        return this.relationalType;
    }

    @Override
    public AutoApplicableConverterDescriptor getAutoApplyDescriptor() {
        return this.autoApplyDescriptor;
    }

    @Override
    public JpaAttributeConverter<X, Y> createJpaAttributeConverter(JpaAttributeConverterCreationContext context) {
        JavaTypeRegistry javaTypeRegistry = context.getTypeConfiguration().getJavaTypeRegistry();
        ManagedBean<AttributeConverter<X, Y>> converterBean = context.getManagedBeanRegistry().getBean(this.converterType);
        return new AttributeConverterBean(converterBean, javaTypeRegistry.getDescriptor(converterBean.getBeanClass()), javaTypeRegistry.resolveDescriptor(this.domainTypeToMatch.getErasedType()), javaTypeRegistry.resolveDescriptor(this.relationalType.getErasedType()));
    }
}

