/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryUtil;
import com.intellij.vcs.log.history.VcsLogFileHistoryUiProvider;
import com.intellij.vcs.log.history.VcsLogFileHistoryUiProviderKt;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.IdeVcsLogManager;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J2\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u001a\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0011H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/vcs/log/history/VcsLogDirectoryHistoryProvider;", "Lcom/intellij/vcs/log/history/VcsLogFileHistoryUiProvider;", "<init>", "()V", "canShowFileHistory", "", "project", "Lcom/intellij/openapi/project/Project;", "paths", "", "Lcom/intellij/openapi/vcs/FilePath;", "revisionNumber", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "showFileHistoryUi", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "selectRow", "createHashFilter", "Lcom/intellij/vcs/log/VcsLogFilter;", "hash", "Lcom/intellij/vcs/log/Hash;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "matches", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "pathsFilter", "hashFilter", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogFileHistoryUiProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogFileHistoryUiProvider.kt\ncom/intellij/vcs/log/history/VcsLogDirectoryHistoryProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1#2:161\n*E\n"})
final class VcsLogDirectoryHistoryProvider
implements VcsLogFileHistoryUiProvider {
    @NotNull
    public static final VcsLogDirectoryHistoryProvider INSTANCE = new VcsLogDirectoryHistoryProvider();

    private VcsLogDirectoryHistoryProvider() {
    }

    @Override
    public boolean canShowFileHistory(@NotNull Project project, @NotNull Collection<? extends FilePath> paths, @Nullable VcsRevisionNumber revisionNumber) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        if (paths.isEmpty()) {
            return false;
        }
        VcsProjectLog projectLog = VcsProjectLog.Companion.getInstance(project);
        if (!(projectLog.getLogManager() instanceof IdeVcsLogManager)) {
            return false;
        }
        VcsLogData vcsLogData = projectLog.getDataManager();
        if (vcsLogData == null) {
            return false;
        }
        VcsLogData dataManager = vcsLogData;
        Map<VirtualFile, VcsLogProvider> map = dataManager.getLogProviders();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getLogProviders(...)");
        return FileHistoryUtil.INSTANCE.createLogPathsFilter(project, map, paths) != null;
    }

    @Override
    @Nullable
    public VcsLogUiEx showFileHistoryUi(@NotNull Project project, @NotNull Collection<? extends FilePath> paths, @Nullable VcsRevisionNumber revisionNumber, boolean selectRow) {
        boolean firstTime;
        Hash hash;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Object object = revisionNumber;
        if (object != null && (object = object.asString()) != null) {
            Object it = object;
            boolean bl = false;
            hash = HashImpl.build((String)it);
        } else {
            hash = null;
        }
        Hash hash2 = hash;
        VirtualFile virtualFile = VcsLogUtil.getActualRoot(project, (FilePath)CollectionsKt.first((Iterable)paths));
        Intrinsics.checkNotNull((Object)virtualFile);
        VirtualFile root = virtualFile;
        VcsLogFileHistoryUiProvider.Companion.triggerFileHistoryUsage(project, paths, hash2);
        VcsLogManager bl = VcsProjectLog.Companion.getInstance(project).getLogManager();
        IdeVcsLogManager ideVcsLogManager = bl instanceof IdeVcsLogManager ? (IdeVcsLogManager)bl : null;
        if (ideVcsLogManager == null) {
            return null;
        }
        IdeVcsLogManager logManager = ideVcsLogManager;
        Map<VirtualFile, VcsLogProvider> map = logManager.getDataManager().getLogProviders();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getLogProviders(...)");
        VcsLogFilter vcsLogFilter = FileHistoryUtil.INSTANCE.createLogPathsFilter(project, map, paths);
        Intrinsics.checkNotNull((Object)vcsLogFilter);
        VcsLogFilter pathsFilter = vcsLogFilter;
        VcsLogFilter hashFilter = this.createHashFilter(hash2, root);
        MainVcsLogUi ui = logManager.findLogUi(MainVcsLogUi.class, true, arg_0 -> VcsLogDirectoryHistoryProvider.showFileHistoryUi$lambda$1(pathsFilter, hashFilter, arg_0));
        boolean bl2 = firstTime = ui == null;
        if (firstTime) {
            VcsLogFilter[] vcsLogFilterArray = new VcsLogFilter[]{pathsFilter, hashFilter};
            VcsLogFilterCollection filters = VcsLogFilterObject.collection(vcsLogFilterArray);
            ui = logManager.openNewLogTab(filters);
            MainVcsLogUiProperties mainVcsLogUiProperties = ui.getProperties();
            VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty = MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES;
            Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty, (String)"SHOW_ONLY_AFFECTED_CHANGES");
            mainVcsLogUiProperties.set(vcsLogUiProperty, true);
        }
        if (selectRow) {
            VcsLogFileHistoryUiProviderKt.access$selectRowWhenOpen(logManager, hash2, root, ui, firstTime);
        }
        return ui;
    }

    private final VcsLogFilter createHashFilter(Hash hash, VirtualFile root) {
        if (hash == null) {
            return (VcsLogFilter)VcsLogFilterObject.fromBranch("HEAD");
        }
        return (VcsLogFilter)VcsLogFilterObject.fromCommit(new CommitId(hash, root));
    }

    private final boolean matches(VcsLogFilterCollection filters, VcsLogFilter pathsFilter, VcsLogFilter hashFilter) {
        VcsLogFilterCollection.FilterKey[] filterKeyArray = new VcsLogFilterCollection.FilterKey[2];
        Intrinsics.checkNotNullExpressionValue((Object)hashFilter.getKey(), (String)"getKey(...)");
        Intrinsics.checkNotNullExpressionValue((Object)pathsFilter.getKey(), (String)"getKey(...)");
        if (!VcsLogFiltersKt.matches(filters, filterKeyArray)) {
            return false;
        }
        return Intrinsics.areEqual((Object)filters.get(pathsFilter.getKey()), (Object)pathsFilter) && Intrinsics.areEqual((Object)filters.get(hashFilter.getKey()), (Object)hashFilter);
    }

    private static final boolean showFileHistoryUi$lambda$1(VcsLogFilter $pathsFilter, VcsLogFilter $hashFilter, MainVcsLogUi logUi) {
        Intrinsics.checkNotNullParameter((Object)logUi, (String)"logUi");
        VcsLogFilterCollection vcsLogFilterCollection = logUi.getFilterUi().getFilters();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogFilterCollection, (String)"getFilters(...)");
        return INSTANCE.matches(vcsLogFilterCollection, $pathsFilter, $hashFilter);
    }
}

