/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UnorderedPair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.GraphModificationUtilKt;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.history.AdditionDeletion;
import com.intellij.vcs.log.history.CommitFileState;
import com.intellij.vcs.log.history.FileHistory;
import com.intellij.vcs.log.history.FileHistoryData;
import com.intellij.vcs.log.history.FileHistoryKt;
import com.intellij.vcs.log.history.FileHistoryRefiner;
import com.intellij.vcs.log.history.ReachableNodesUtilKt;
import com.intellij.vcs.log.history.Rename;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 12\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u00030\u0001:\u00011BW\u0012\u000e\u0010\u0006\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0012\b\u0002\u0010\r\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\"\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00022\u0010\u0010&\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0003H\u0016J\"\u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00022\u0010\u0010&\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0003H\u0002J\u001a\u0010(\u001a\u00020$2\u0010\u0010)\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u000eH\u0002JG\u0010\u0011\u001a\u0012\u0012\b\u0012\u00060\u0004j\u0002`\u0005\u0012\u0004\u0012\u00020\u00170*2\u0006\u0010%\u001a\u00020\u00022\u000e\u0010\u0006\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u00052\u0010\u0010&\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0003H\u0002\u00a2\u0006\u0002\u0010+J:\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00170-2\n\u0010.\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010/\u001a\u0002002\u0010\u0010&\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0003H\u0002R\u0018\u0010\u0006\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0012\u0012\b\u0012\u00060\u0004j\u0002`\u0005\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001c\u001a\u0018\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u001e\u0012\u0004\u0012\u00020\u001f0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u00062"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryBuilder;", "Ljava/util/function/BiConsumer;", "Lcom/intellij/vcs/log/graph/impl/facade/LinearGraphController;", "Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;", "", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "startCommit", "startPath", "Lcom/intellij/openapi/vcs/FilePath;", "fileHistoryData", "Lcom/intellij/vcs/log/history/FileHistoryData;", "oldFileHistory", "Lcom/intellij/vcs/log/history/FileHistory;", "commitsToHide", "", "removeTrivialMerges", "", "refine", "<init>", "(Ljava/lang/Integer;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/vcs/log/history/FileHistoryData;Lcom/intellij/vcs/log/history/FileHistory;Ljava/util/Set;ZZ)V", "Ljava/lang/Integer;", "fileStateMap", "", "Lcom/intellij/vcs/log/history/CommitFileState;", "processedAdditionsDeletions", "", "Lcom/intellij/vcs/log/history/AdditionDeletion;", "unmatchedAdditionsDeletions", "commitToRename", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/util/UnorderedPair;", "Lcom/intellij/vcs/log/history/Rename;", "fileHistory", "getFileHistory", "()Lcom/intellij/vcs/log/history/FileHistory;", "accept", "", "controller", "permanentGraphInfo", "collectAdditionsDeletions", "reportTrivialMerges", "trivialMerges", "", "(Lcom/intellij/vcs/log/graph/impl/facade/LinearGraphController;Ljava/lang/Integer;Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;)Ljava/util/Map;", "findAncestorRowAffectingFile", "Lkotlin/Pair;", "commitId", "visibleLinearGraph", "Lcom/intellij/vcs/log/graph/api/LinearGraph;", "Companion", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nFileHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHistory.kt\ncom/intellij/vcs/log/history/FileHistoryBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,505:1\n1491#2:506\n1516#2,3:507\n1519#2,3:517\n382#3,7:510\n1#4:520\n*S KotlinDebug\n*F\n+ 1 FileHistory.kt\ncom/intellij/vcs/log/history/FileHistoryBuilder\n*L\n81#1:506\n81#1:507,3\n81#1:517,3\n81#1:510,7\n*E\n"})
public final class FileHistoryBuilder
implements BiConsumer<LinearGraphController, PermanentGraphInfo<Integer>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Integer startCommit;
    @NotNull
    private final FilePath startPath;
    @NotNull
    private final FileHistoryData fileHistoryData;
    @NotNull
    private final FileHistory oldFileHistory;
    @NotNull
    private final Set<Integer> commitsToHide;
    private final boolean removeTrivialMerges;
    private final boolean refine;
    @NotNull
    private final Map<Integer, CommitFileState> fileStateMap;
    @NotNull
    private final Set<AdditionDeletion> processedAdditionsDeletions;
    @NotNull
    private final Set<AdditionDeletion> unmatchedAdditionsDeletions;
    @NotNull
    private final MultiMap<UnorderedPair<Integer>, Rename> commitToRename;
    @NotNull
    private static final Logger LOG;
    @JvmField
    @NotNull
    public static final RegistryValue removeTrivialMergesValue;
    @JvmField
    @NotNull
    public static final RegistryValue refineValue;

    public FileHistoryBuilder(@Nullable Integer startCommit, @NotNull FilePath startPath, @NotNull FileHistoryData fileHistoryData, @NotNull FileHistory oldFileHistory, @NotNull Set<Integer> commitsToHide, boolean removeTrivialMerges, boolean refine) {
        Intrinsics.checkNotNullParameter((Object)startPath, (String)"startPath");
        Intrinsics.checkNotNullParameter((Object)fileHistoryData, (String)"fileHistoryData");
        Intrinsics.checkNotNullParameter((Object)oldFileHistory, (String)"oldFileHistory");
        Intrinsics.checkNotNullParameter(commitsToHide, (String)"commitsToHide");
        this.startCommit = startCommit;
        this.startPath = startPath;
        this.fileHistoryData = fileHistoryData;
        this.oldFileHistory = oldFileHistory;
        this.commitsToHide = commitsToHide;
        this.removeTrivialMerges = removeTrivialMerges;
        this.refine = refine;
        this.fileStateMap = new LinkedHashMap();
        this.processedAdditionsDeletions = new LinkedHashSet();
        this.unmatchedAdditionsDeletions = new LinkedHashSet();
        this.commitToRename = new MultiMap();
    }

    public /* synthetic */ FileHistoryBuilder(Integer n, FilePath filePath, FileHistoryData fileHistoryData, FileHistory fileHistory, Set set, boolean bl, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n2 & 0x20) != 0) {
            bl = true;
        }
        if ((n2 & 0x40) != 0) {
            bl2 = true;
        }
        this(n, filePath, fileHistoryData, fileHistory, set, bl, bl2);
    }

    @NotNull
    public final FileHistory getFileHistory() {
        return new FileHistory(this.fileStateMap, this.processedAdditionsDeletions, this.unmatchedAdditionsDeletions, this.commitToRename);
    }

    @Override
    public void accept(@NotNull LinearGraphController controller, @NotNull PermanentGraphInfo<Integer> permanentGraphInfo) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter(permanentGraphInfo, (String)"permanentGraphInfo");
        boolean needToRepeat2 = this.removeTrivialMerges && FileHistoryKt.removeTrivialMerges(controller, permanentGraphInfo, this.fileHistoryData, (Function1<? super Set<Integer>, Unit>)((Function1)new Function1<Set<? extends Integer>, Unit>((Object)this){

            public final void invoke(Set<Integer> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                FileHistoryBuilder.access$reportTrivialMerges((FileHistoryBuilder)this.receiver, p0);
            }
        }));
        this.fileStateMap.putAll(this.refine(controller, this.startCommit, permanentGraphInfo));
        if (needToRepeat2) {
            LOG.info("Some merge commits were not excluded from file history for " + this.startPath.getPath());
            FileHistoryKt.removeTrivialMerges(controller, permanentGraphInfo, this.fileHistoryData, (Function1<? super Set<Integer>, Unit>)((Function1)new Function1<Set<? extends Integer>, Unit>((Object)this){

                public final void invoke(Set<Integer> p0) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    FileHistoryBuilder.access$reportTrivialMerges((FileHistoryBuilder)this.receiver, p0);
                }
            }));
        }
        this.collectAdditionsDeletions(controller, permanentGraphInfo);
        this.commitToRename.putAllValues(this.fileHistoryData.getCommitToRename$intellij_platform_vcs_log_impl());
        if (!((Collection)this.commitsToHide).isEmpty()) {
            GraphModificationUtilKt.hideCommits(controller, permanentGraphInfo, this.commitsToHide);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void collectAdditionsDeletions(LinearGraphController controller, PermanentGraphInfo<Integer> permanentGraphInfo) {
        this.processedAdditionsDeletions.addAll((Collection<AdditionDeletion>)this.oldFileHistory.getProcessedAdditionsDeletions$intellij_platform_vcs_log_impl());
        this.processedAdditionsDeletions.addAll((Collection<AdditionDeletion>)this.oldFileHistory.getUnmatchedAdditionsDeletions$intellij_platform_vcs_log_impl());
        Set additionsDeletions = new LinkedHashSet();
        this.fileHistoryData.iterateUnmatchedAdditionsDeletions$intellij_platform_vcs_log_impl((Function1<? super AdditionDeletion, Unit>)((Function1)arg_0 -> FileHistoryBuilder.collectAdditionsDeletions$lambda$0(this, additionsDeletions, arg_0)));
        if (!((Collection)additionsDeletions).isEmpty()) {
            void $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv = additionsDeletions;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                AdditionDeletion it = (AdditionDeletion)element$iv$iv;
                boolean bl = false;
                Integer key$iv$iv = it.getChild();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map grouped = destination$iv$iv;
            int n = controller.getCompiledGraph().nodesCount();
            for (int row = 0; row < n; ++row) {
                Integer commitId = permanentGraphInfo.getPermanentCommitsInfo().getCommitId(controller.getCompiledGraph().getNodeId(row));
                if ((List)grouped.get(commitId) != null) {
                    List it;
                    boolean bl = false;
                    this.unmatchedAdditionsDeletions.addAll(it);
                }
            }
        }
    }

    private final void reportTrivialMerges(Set<Integer> trivialMerges) {
        LOG.debug("Excluding " + trivialMerges.size() + " trivial merges from history for " + this.startPath.getPath());
    }

    private final Map<Integer, CommitFileState> refine(LinearGraphController controller, Integer startCommit, PermanentGraphInfo<Integer> permanentGraphInfo) {
        block6: {
            Pair<Integer, CommitFileState> pair;
            LinearGraph visibleLinearGraph;
            block8: {
                block7: {
                    visibleLinearGraph = controller.getCompiledGraph();
                    if (visibleLinearGraph.nodesCount() <= 0 || !this.fileHistoryData.getHasRenames() || !this.refine) break block6;
                    pair = startCommit;
                    if (pair == null) break block7;
                    int it = ((Number)pair).intValue();
                    boolean bl = false;
                    Pair<Integer, CommitFileState> pair2 = this.findAncestorRowAffectingFile(startCommit.intValue(), visibleLinearGraph, permanentGraphInfo);
                    pair = pair2;
                    if (pair2 != null) break block8;
                }
                pair = new Pair((Object)0, (Object)new CommitFileState(this.startPath));
            }
            Pair<Integer, CommitFileState> pair3 = pair;
            int row = ((Number)pair3.component1()).intValue();
            CommitFileState fileState = (CommitFileState)pair3.component2();
            if (row >= 0) {
                FileHistoryRefiner refiner = new FileHistoryRefiner(visibleLinearGraph, permanentGraphInfo, this.fileHistoryData);
                Pair<Map<Integer, CommitFileState>, Set<Integer>> pair4 = refiner.refine(row, fileState);
                Map fileStates = (Map)pair4.component1();
                Set excluded = (Set)pair4.component2();
                if (!((Collection)excluded).isEmpty()) {
                    LOG.info("Excluding " + excluded.size() + " commits from history for " + this.startPath.getPath());
                    boolean hidden = GraphModificationUtilKt.hideCommits(controller, permanentGraphInfo, excluded);
                    if (!hidden) {
                        LOG.error("Could not hide excluded commits from history for " + this.startPath.getPath());
                    }
                }
                return fileStates;
            }
        }
        return this.fileHistoryData.buildFileStatesMap();
    }

    private final Pair<Integer, CommitFileState> findAncestorRowAffectingFile(int commitId, LinearGraph visibleLinearGraph, PermanentGraphInfo<Integer> permanentGraphInfo) {
        CommitFileState existing = new CommitFileState(this.startPath);
        CommitFileState deleted2 = new CommitFileState(this.startPath, true);
        Ref ref = Ref.create((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"create(...)");
        Ref isDeleted = ref;
        Integer n = ReachableNodesUtilKt.findVisibleAncestorRow(commitId, visibleLinearGraph, permanentGraphInfo, (Function1<? super Integer, Boolean>)((Function1)arg_0 -> FileHistoryBuilder.findAncestorRowAffectingFile$lambda$4(permanentGraphInfo, this, existing, deleted2, isDeleted, arg_0)));
        int row = n != null ? n : -1;
        return new Pair((Object)row, (Object)((Boolean)isDeleted.get() != false ? deleted2 : existing));
    }

    private static final Unit collectAdditionsDeletions$lambda$0(FileHistoryBuilder this$0, Set $additionsDeletions, AdditionDeletion ad) {
        Intrinsics.checkNotNullParameter((Object)ad, (String)"ad");
        if (!this$0.processedAdditionsDeletions.contains(ad)) {
            $additionsDeletions.add(ad);
        }
        return Unit.INSTANCE;
    }

    private static final boolean findAncestorRowAffectingFile$lambda$4(PermanentGraphInfo $permanentGraphInfo, FileHistoryBuilder this$0, CommitFileState $existing, CommitFileState $deleted, Ref $isDeleted, int nodeId) {
        boolean bl;
        Integer id = (Integer)$permanentGraphInfo.getPermanentCommitsInfo().getCommitId(nodeId);
        FileHistoryData fileHistoryData = this$0.fileHistoryData;
        Intrinsics.checkNotNull((Object)id);
        if (FileHistoryData.affects$default(fileHistoryData, id, $existing, false, 4, null)) {
            bl = true;
        } else if (FileHistoryData.affects$default(this$0.fileHistoryData, id, $deleted, false, 4, null)) {
            $isDeleted.set((Object)true);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ void access$reportTrivialMerges(FileHistoryBuilder $this, Set trivialMerges) {
        $this.reportTrivialMerges(trivialMerges);
    }

    static {
        Logger logger = Logger.getInstance(FileHistoryBuilder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        removeTrivialMergesValue = Registry.Companion.get("vcs.history.remove.trivial.merges");
        refineValue = Registry.Companion.get("vcs.history.refine");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\b8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryBuilder$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "removeTrivialMergesValue", "Lcom/intellij/openapi/util/registry/RegistryValue;", "refineValue", "isRemoveTrivialMerges", "", "isRemoveTrivialMerges$intellij_platform_vcs_log_impl", "()Z", "isRefine", "isRefine$intellij_platform_vcs_log_impl", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isRemoveTrivialMerges$intellij_platform_vcs_log_impl() {
            return removeTrivialMergesValue.asBoolean();
        }

        public final boolean isRefine$intellij_platform_vcs_log_impl() {
            return refineValue.asBoolean();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

