/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.Language;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.CaseConversionHelper;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.RegexRuleFilter;
import org.languagetool.rules.patterns.RegexRuleFilterEvaluator;
import org.languagetool.rules.patterns.RuleMatcher;
import org.languagetool.rules.patterns.StringMatcher;
import org.languagetool.rules.patterns.Substrings;
import org.languagetool.tools.InterruptibleCharSequence;

public class RegexPatternRule
extends AbstractPatternRule
implements RuleMatcher {
    private static final Pattern suggestionPattern = Pattern.compile("<suggestion>(.*?)</suggestion>");
    private static final Pattern matchPattern = Pattern.compile("\\\\\\d");
    private static final int MATCHES_IN_SUGGESTIONS_NUMBERED_FROM = 0;
    public static final int MAX_SENT_LENGTH = 2000;
    private final Pattern pattern;
    private final int markGroup;
    private final String shortMessage;
    private RegexRuleFilter regexFilter;
    @Nullable
    private final Substrings requiredSubstrings;
    private final boolean caseSensitive;

    public RegexPatternRule(String id, String description, String message, String shortMessage, String suggestionsOutMsg, Language language, Pattern regex, int regexpMark) {
        super(id, description, language);
        this.message = message;
        this.pattern = regex;
        this.requiredSubstrings = StringMatcher.getRequiredSubstrings(regex.toString());
        this.caseSensitive = (regex.flags() & 2) == 0;
        this.shortMessage = shortMessage == null ? "" : shortMessage;
        this.suggestionsOutMsg = suggestionsOutMsg.isEmpty() ? "" : suggestionsOutMsg;
        this.markGroup = regexpMark;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    void setRegexFilter(RegexRuleFilter filter) {
        this.regexFilter = filter;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentenceObj) throws IOException {
        int startPos;
        String text = sentenceObj.getText();
        int n = startPos = this.requiredSubstrings == null ? 0 : this.requiredSubstrings.find(text, this.caseSensitive);
        if (startPos < 0) {
            return RuleMatch.EMPTY_ARRAY;
        }
        return this.doMatch(sentenceObj, text, this.requiredSubstrings != null && !this.requiredSubstrings.mustStart ? 0 : startPos);
    }

    private RuleMatch[] doMatch(AnalyzedSentence sentenceObj, String text, int startPos) {
        List<Pair<Integer, Integer>> suggestionsInMessage = this.getClausePositionsInMessage(suggestionPattern, this.message);
        List<Pair<Integer, Integer>> backReferencesInMessage = this.getClausePositionsInMessage(matchPattern, this.message);
        List<Pair<Integer, Integer>> suggestionsInSuggestionsOutMsg = this.getClausePositionsInMessage(suggestionPattern, this.suggestionsOutMsg);
        List<Pair<Integer, Integer>> backReferencesInSuggestionsOutMsg = this.getClausePositionsInMessage(matchPattern, this.suggestionsOutMsg);
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        if (text.length() > 2000) {
            return matches.toArray(new RuleMatch[0]);
        }
        Matcher patternMatcher = this.pattern.matcher(new InterruptibleCharSequence(text));
        while (patternMatcher.find(startPos)) {
            try {
                int markStart = patternMatcher.start(this.markGroup);
                int markEnd = patternMatcher.end(this.markGroup);
                String processedMessage = this.processMessage(patternMatcher, this.message, backReferencesInMessage, suggestionsInMessage, this.getSuggestionMatches());
                String processedSuggestionsOutMsg = this.processMessage(patternMatcher, this.suggestionsOutMsg, backReferencesInSuggestionsOutMsg, suggestionsInSuggestionsOutMsg, this.getSuggestionMatchesOutMsg());
                boolean startsWithUpperCase = patternMatcher.start() == 0 && Character.isUpperCase(text.charAt(patternMatcher.start()));
                RuleMatch ruleMatch = new RuleMatch(this, sentenceObj, markStart, markEnd, patternMatcher.start(), patternMatcher.end(), processedMessage, this.shortMessage, startsWithUpperCase, false, processedSuggestionsOutMsg, true);
                if (this.regexFilter != null) {
                    RegexRuleFilterEvaluator ruleFilterEvaluator = new RegexRuleFilterEvaluator(this.regexFilter);
                    RuleMatch filteredMatch = ruleFilterEvaluator.runFilter(this.getFilterArguments(), ruleMatch, sentenceObj, patternMatcher);
                    if (filteredMatch != null) {
                        matches.add(ruleMatch);
                    }
                } else {
                    matches.add(ruleMatch);
                }
                startPos = patternMatcher.end();
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeException(String.format("Unexpected reference to capturing group in rule with id %s.", this.getFullId()), e);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unexpected exception when processing regexp in rule with id %s.", this.getFullId()), e);
            }
        }
        return matches.toArray(new RuleMatch[0]);
    }

    @NotNull
    private List<Pair<Integer, Integer>> getClausePositionsInMessage(Pattern pattern, String message) {
        Matcher matcher = pattern.matcher(message);
        ArrayList<Pair<Integer, Integer>> clausePositionsInMessage = new ArrayList<Pair<Integer, Integer>>();
        while (matcher.find()) {
            clausePositionsInMessage.add((Pair<Integer, Integer>)Pair.of((Object)matcher.start(), (Object)matcher.end()));
        }
        return clausePositionsInMessage;
    }

    private String processMessage(Matcher matcher, String message, List<Pair<Integer, Integer>> backReferences, List<Pair<Integer, Integer>> suggestions, List<Match> matches) {
        int closestSuggestionPosition = -1;
        boolean allSuggestionsPassed = suggestions.isEmpty();
        if (!suggestions.isEmpty()) {
            closestSuggestionPosition = 0;
        }
        StringBuilder processedMessage = new StringBuilder();
        int startOfProcessingPart = 0;
        for (int i = 0; i < backReferences.size(); ++i) {
            String suggestion;
            Match currentProcessingMatch;
            String regexReplace;
            Pair<Integer, Integer> reference = backReferences.get(i);
            while (!allSuggestionsPassed && (Integer)reference.getLeft() > (Integer)suggestions.get(closestSuggestionPosition).getRight()) {
                if (++closestSuggestionPosition != suggestions.size()) continue;
                allSuggestionsPassed = true;
            }
            boolean insideSuggestion = !allSuggestionsPassed && (Integer)reference.getLeft() >= (Integer)suggestions.get(closestSuggestionPosition).getLeft();
            int inXMLMatchReferenceNo = Integer.parseInt(message.substring((Integer)reference.getLeft(), (Integer)reference.getRight()).split("\\\\")[1]);
            int actualMatchReferenceNo = inXMLMatchReferenceNo - (insideSuggestion ? 0 : 0);
            String matchReferenceStringValue = matcher.group(actualMatchReferenceNo);
            if (matchReferenceStringValue == null) {
                matchReferenceStringValue = "";
            }
            if ((regexReplace = (currentProcessingMatch = matches.get(i)).getRegexReplace()) != null) {
                suggestion = currentProcessingMatch.getRegexMatch().matcher(matchReferenceStringValue).replaceFirst(regexReplace);
                suggestion = CaseConversionHelper.convertCase(currentProcessingMatch.getCaseConversionType(), suggestion, matchReferenceStringValue, this.getLanguage());
            } else {
                suggestion = matchReferenceStringValue;
            }
            processedMessage.append(message, startOfProcessingPart, (int)((Integer)reference.getLeft())).append(suggestion);
            startOfProcessingPart = (Integer)reference.getRight();
        }
        processedMessage.append(message.substring(startOfProcessingPart));
        return processedMessage.toString();
    }

    @Override
    public int estimateContextForSureMatch() {
        return -1;
    }

    @Override
    public String toString() {
        return this.pattern + "/flags:" + this.pattern.flags();
    }

    @Override
    String getShortMessage() {
        return this.shortMessage;
    }
}

