/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.moduleConfigurators;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.tools.projectWizard.KotlinNewProjectWizardBundle;
import org.jetbrains.kotlin.tools.projectWizard.core.Context;
import org.jetbrains.kotlin.tools.projectWizard.ir.buildsystem.BuildSystemIR;
import org.jetbrains.kotlin.tools.projectWizard.ir.buildsystem.gradle.GradleIRBuilderKt;
import org.jetbrains.kotlin.tools.projectWizard.ir.buildsystem.gradle.GradleIRListBuilder;
import org.jetbrains.kotlin.tools.projectWizard.ir.buildsystem.gradle.multiplatform.NonDefaultTargetConfigurationIR;
import org.jetbrains.kotlin.tools.projectWizard.moduleConfigurators.NativeTargetConfigurator;
import org.jetbrains.kotlin.tools.projectWizard.moduleConfigurators.SingleCoexistenceTargetConfigurator;
import org.jetbrains.kotlin.tools.projectWizard.plugins.kotlin.ModuleType;
import org.jetbrains.kotlin.tools.projectWizard.plugins.printer.BuildFilePrinter;
import org.jetbrains.kotlin.tools.projectWizard.plugins.printer.GradlePrinter;
import org.jetbrains.kotlin.tools.projectWizard.settings.buildsystem.Module;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014*\n0\u0016R\u00020\u0017j\u0002`\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR\u0014\u0010\f\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0016\u0010\r\u001a\u00020\u000e8\u0016X\u0097D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/moduleConfigurators/NativeForCurrentSystemTarget;", "Lorg/jetbrains/kotlin/tools/projectWizard/moduleConfigurators/NativeTargetConfigurator;", "Lorg/jetbrains/kotlin/tools/projectWizard/moduleConfigurators/SingleCoexistenceTargetConfigurator;", "<init>", "()V", "moduleType", "Lorg/jetbrains/kotlin/tools/projectWizard/plugins/kotlin/ModuleType;", "getModuleType", "()Lorg/jetbrains/kotlin/tools/projectWizard/plugins/kotlin/ModuleType;", "isDesktopTarget", "", "()Z", "isIosTarget", "id", "", "getId", "()Ljava/lang/String;", "text", "getText", "createTargetIrs", "", "Lorg/jetbrains/kotlin/tools/projectWizard/ir/buildsystem/BuildSystemIR;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Context$Reader;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Context;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Reader;", "module", "Lorg/jetbrains/kotlin/tools/projectWizard/settings/buildsystem/Module;", "kotlin.project-wizard.core"})
public final class NativeForCurrentSystemTarget
implements NativeTargetConfigurator,
SingleCoexistenceTargetConfigurator {
    @NotNull
    public static final NativeForCurrentSystemTarget INSTANCE = new NativeForCurrentSystemTarget();
    @NotNull
    private static final ModuleType moduleType = ModuleType.native;
    private static final boolean isDesktopTarget = true;
    private static final boolean isIosTarget;
    @NonNls
    @NotNull
    private static final String id;
    @NotNull
    private static final String text;

    private NativeForCurrentSystemTarget() {
    }

    @Override
    @NotNull
    public ModuleType getModuleType() {
        return moduleType;
    }

    @Override
    public boolean isDesktopTarget() {
        return isDesktopTarget;
    }

    @Override
    public boolean isIosTarget() {
        return isIosTarget;
    }

    @Override
    @NotNull
    public String getId() {
        return id;
    }

    @Override
    @NotNull
    public String getText() {
        return text;
    }

    @Override
    @NotNull
    public List<BuildSystemIR> createTargetIrs(@NotNull Context.Reader $this$createTargetIrs, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)$this$createTargetIrs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        String moduleName = module.getName();
        String variableName = moduleName + "Target";
        return GradleIRBuilderKt.irsList((Function1<? super GradleIRListBuilder, Unit>)((Function1)arg_0 -> NativeForCurrentSystemTarget.createTargetIrs$lambda$2(variableName, moduleName, $this$createTargetIrs, module, arg_0)));
    }

    private static final Unit createTargetIrs$lambda$2$lambda$1$lambda$0(GradlePrinter $this_addRaw, String $moduleName) {
        $this_addRaw.indent();
        $this_addRaw.unaryPlus("hostOs == \"Mac OS X\" && isArm64 -> macosArm64(\"" + $moduleName + "\")");
        BuildFilePrinter.nlIndented$default($this_addRaw, 0, 1, null);
        $this_addRaw.unaryPlus("hostOs == \"Mac OS X\" && !isArm64 -> macosX64(\"" + $moduleName + "\")");
        BuildFilePrinter.nlIndented$default($this_addRaw, 0, 1, null);
        $this_addRaw.unaryPlus("hostOs == \"Linux\" && isArm64 -> linuxArm64(\"" + $moduleName + "\")");
        BuildFilePrinter.nlIndented$default($this_addRaw, 0, 1, null);
        $this_addRaw.unaryPlus("hostOs == \"Linux\" && !isArm64 -> linuxX64(\"" + $moduleName + "\")");
        BuildFilePrinter.nlIndented$default($this_addRaw, 0, 1, null);
        $this_addRaw.unaryPlus("isMingwX64 -> mingwX64(\"" + $moduleName + "\")");
        BuildFilePrinter.nlIndented$default($this_addRaw, 0, 1, null);
        $this_addRaw.unaryPlus("else -> throw GradleException(\"Host OS is not supported in Kotlin/Native.\")");
        return Unit.INSTANCE;
    }

    private static final Unit createTargetIrs$lambda$2$lambda$1(String $variableName, String $moduleName, GradlePrinter $this$addRaw) {
        Intrinsics.checkNotNullParameter((Object)$this$addRaw, (String)"$this$addRaw");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$addRaw.getDsl().ordinal()]) {
            case 1: {
                $this$addRaw.unaryPlus("val " + $variableName + " = when ");
                $this$addRaw.inBrackets((Function0<Unit>)((Function0)() -> NativeForCurrentSystemTarget.createTargetIrs$lambda$2$lambda$1$lambda$0($this$addRaw, $moduleName)));
                break;
            }
            case 2: {
                $this$addRaw.unaryPlus("def " + $variableName);
                BuildFilePrinter.nlIndented$default($this$addRaw, 0, 1, null);
                $this$addRaw.unaryPlus("if (hostOs == \"Mac OS X\" && isArm64) " + $variableName + " = macosArm64('" + $moduleName + "')");
                BuildFilePrinter.nlIndented$default($this$addRaw, 0, 1, null);
                $this$addRaw.unaryPlus("else if (hostOs == \"Mac OS X\" && !isArm64) " + $variableName + " = macosX64('" + $moduleName + "')");
                BuildFilePrinter.nlIndented$default($this$addRaw, 0, 1, null);
                $this$addRaw.unaryPlus("else if (hostOs == \"Linux\" && isArm64) " + $variableName + " = linuxArm64(\"" + $moduleName + "\")");
                BuildFilePrinter.nlIndented$default($this$addRaw, 0, 1, null);
                $this$addRaw.unaryPlus("else if (hostOs == \"Linux\" && !isArm64) " + $variableName + " = linuxX64(\"" + $moduleName + "\")");
                BuildFilePrinter.nlIndented$default($this$addRaw, 0, 1, null);
                $this$addRaw.unaryPlus("else if (isMingwX64) " + $variableName + " = mingwX64(\"" + $moduleName + "\")");
                BuildFilePrinter.nlIndented$default($this$addRaw, 0, 1, null);
                $this$addRaw.unaryPlus("else throw new GradleException(\"Host OS is not supported in Kotlin/Native.\")");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        BuildFilePrinter.nl$default($this$addRaw, 0, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createTargetIrs$lambda$2(String $variableName, String $moduleName, Context.Reader $this_createTargetIrs, Module $module, GradleIRListBuilder $this$irsList) {
        Intrinsics.checkNotNullParameter((Object)$this$irsList, (String)"$this$irsList");
        $this$irsList.createValue("hostOs", $this$irsList.raw("System.getProperty(\"os.name\")"));
        $this$irsList.createValue("isArm64", $this$irsList.raw("System.getProperty(\"os.arch\") == \"aarch64\""));
        $this$irsList.createValue("isMingwX64", $this$irsList.raw("hostOs.startsWith(\"Windows\")"));
        $this$irsList.addRaw((Function1<? super GradlePrinter, Unit>)((Function1)arg_0 -> NativeForCurrentSystemTarget.createTargetIrs$lambda$2$lambda$1($variableName, $moduleName, arg_0)));
        $this$irsList.unaryPlus(new NonDefaultTargetConfigurationIR($variableName, $moduleName, (PersistentList<? extends BuildSystemIR>)ExtensionsKt.toPersistentList((Iterable)INSTANCE.createInnerTargetIrs($this_createTargetIrs, $module))));
        return Unit.INSTANCE;
    }

    static {
        id = "nativeForCurrentSystem";
        text = KotlinNewProjectWizardBundle.message("module.configurator.native.for.current.system", new Object[0]);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GradlePrinter.GradleDsl.values().length];
            try {
                nArray[GradlePrinter.GradleDsl.KOTLIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GradlePrinter.GradleDsl.GROOVY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

