/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.stubindex.resolve;

import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.analysis.KotlinBaseAnalysisBundle;
import org.jetbrains.kotlin.idea.stubindex.resolve.KotlinCorruptedIndexListener;
import org.jetbrains.kotlin.idea.stubindex.resolve.KotlinRepairIdeAction;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/stubindex/resolve/KotlinRepairIdeAfterCorruptionNotification;", "Lorg/jetbrains/kotlin/idea/stubindex/resolve/KotlinCorruptedIndexListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "pendingNotificationFlag", "Ljava/util/concurrent/atomic/AtomicBoolean;", "corruptionDetected", "", "kotlin.base.analysis"})
public final class KotlinRepairIdeAfterCorruptionNotification
implements KotlinCorruptedIndexListener {
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicBoolean pendingNotificationFlag;

    public KotlinRepairIdeAfterCorruptionNotification(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.pendingNotificationFlag = new AtomicBoolean(false);
    }

    @Override
    public void corruptionDetected() {
        if (this.pendingNotificationFlag.get()) {
            return;
        }
        Notification notification = NotificationGroupManager.getInstance().getNotificationGroup("Recover Kotlin Indices").createNotification(KotlinBaseAnalysisBundle.message("kotlin.indices.corrupted", new Object[0]), NotificationType.ERROR).setSuggestionType(true).setImportantSuggestion(true).addAction((AnAction)NotificationAction.createSimpleExpiring((String)ActionsBundle.message((String)"action.CallSaul.text", (Object[])new Object[0]), (Runnable)new KotlinRepairIdeAction(this.project))).whenExpired(() -> KotlinRepairIdeAfterCorruptionNotification.corruptionDetected$lambda$0(this));
        if (this.pendingNotificationFlag.compareAndSet(false, true)) {
            notification.notify(this.project);
        }
    }

    private static final void corruptionDetected$lambda$0(KotlinRepairIdeAfterCorruptionNotification this$0) {
        this$0.pendingNotificationFlag.set(false);
    }
}

