/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KotlinProjectStructureProvider;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.services.LLFirElementByPsiElementChooser;
import org.jetbrains.kotlin.analysis.low.level.api.fir.element.builder.FirElementBuilderKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.projectStructure.LLFirModuleDataKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.services.LLMismatchedPsiFirElementByPsiElementChooser;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.symbolProviders.LLModuleWithDependenciesSymbolProvider;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.ExceptionUtilsKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.FirDeclarationForCompiledElementSearcherKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.utils.exceptions.FirExceptionUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassLikeDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachementBuilderUtilsKt;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u001a\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001c2\u0006\u0010\"\u001a\u00020#H\u0002J\"\u0010$\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030%0\u001c2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010+\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u0002002\u0006\u0010&\u001a\u000201H\u0002J\u0010\u00102\u001a\u0002032\u0006\u0010&\u001a\u000204H\u0002J\u0014\u00105\u001a\u0002062\n\u0010&\u001a\u0006\u0012\u0002\b\u000307H\u0002J\u0010\u00108\u001a\u0002092\u0006\u0010&\u001a\u00020\u001fH\u0002J\u0010\u0010:\u001a\u00020;2\u0006\u0010&\u001a\u00020#H\u0002J\u0010\u0010<\u001a\u00020=2\u0006\u0010&\u001a\u00020>H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/FirDeclarationForCompiledElementSearcher;", "", "session", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "<init>", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;)V", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectStructureProvider", "Lorg/jetbrains/kotlin/analysis/api/platform/projectStructure/KotlinProjectStructureProvider;", "getProjectStructureProvider", "()Lorg/jetbrains/kotlin/analysis/api/platform/projectStructure/KotlinProjectStructureProvider;", "projectStructureProvider$delegate", "Lkotlin/Lazy;", "firElementByPsiElementChooser", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/services/LLFirElementByPsiElementChooser;", "getFirElementByPsiElementChooser", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/services/LLFirElementByPsiElementChooser;", "firElementByPsiElementChooser$delegate", "mismatchedPsiFirElementChooser", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/services/LLMismatchedPsiFirElementByPsiElementChooser;", "findNonLocalDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "ktDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "findFunctionCandidates", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "findPropertyCandidates", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "findCallableCandidates", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "declaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "isTopLevel", "", "findNonLocalTypeParameter", "param", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "findParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "findNonLocalEnumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "findNonLocalClassLikeDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "Lorg/jetbrains/kotlin/psi/KtClassLikeDeclaration;", "findConstructorOfNonLocalClass", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "Lorg/jetbrains/kotlin/psi/KtConstructor;", "findNonLocalFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "findNonLocalProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "findNonLocalPropertyAccessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nFirDeclarationForCompiledElementSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDeclarationForCompiledElementSearcher.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/util/FirDeclarationForCompiledElementSearcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,299:1\n808#2,11:300\n808#2,11:311\n295#2,2:323\n295#2,2:325\n295#2,2:327\n295#2,2:329\n669#2,11:331\n669#2,11:342\n295#2,2:353\n295#2,2:355\n295#2,2:357\n295#2,2:359\n1563#2:361\n1634#2,3:362\n808#2,11:365\n1563#2:376\n1634#2,3:377\n1#3:322\n*S KotlinDebug\n*F\n+ 1 FirDeclarationForCompiledElementSearcher.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/util/FirDeclarationForCompiledElementSearcher\n*L\n81#1:300,11\n84#1:311,11\n130#1:323,2\n131#1:325,2\n171#1:327,2\n172#1:329,2\n229#1:331,11\n230#1:342,11\n241#1:353,2\n242#1:355,2\n255#1:357,2\n256#1:359,2\n133#1:361\n133#1:362,3\n174#1:365,11\n174#1:376\n174#1:377,3\n*E\n"})
public final class FirDeclarationForCompiledElementSearcher {
    @NotNull
    private final LLFirSession session;
    @NotNull
    private final Lazy projectStructureProvider$delegate;
    @NotNull
    private final Lazy firElementByPsiElementChooser$delegate;
    @NotNull
    private final LLMismatchedPsiFirElementByPsiElementChooser mismatchedPsiFirElementChooser;

    public FirDeclarationForCompiledElementSearcher(@NotNull LLFirSession session) {
        Intrinsics.checkNotNullParameter((Object)((Object)session), (String)"session");
        this.session = session;
        this.projectStructureProvider$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> FirDeclarationForCompiledElementSearcher.projectStructureProvider_delegate$lambda$0(this));
        this.firElementByPsiElementChooser$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> FirDeclarationForCompiledElementSearcher.firElementByPsiElementChooser_delegate$lambda$1(this));
        this.mismatchedPsiFirElementChooser = new LLMismatchedPsiFirElementByPsiElementChooser();
    }

    private final Project getProject() {
        return this.session.getProject();
    }

    private final KotlinProjectStructureProvider getProjectStructureProvider() {
        Lazy lazy = this.projectStructureProvider$delegate;
        return (KotlinProjectStructureProvider)lazy.getValue();
    }

    private final LLFirElementByPsiElementChooser getFirElementByPsiElementChooser() {
        Lazy lazy = this.firElementByPsiElementChooser$delegate;
        return (LLFirElementByPsiElementChooser)lazy.getValue();
    }

    @NotNull
    public final FirDeclaration findNonLocalDeclaration(@NotNull KtDeclaration ktDeclaration) {
        FirDeclaration firDeclaration;
        Intrinsics.checkNotNullParameter((Object)ktDeclaration, (String)"ktDeclaration");
        KtDeclaration ktDeclaration2 = ktDeclaration;
        if (ktDeclaration2 instanceof KtEnumEntry) {
            firDeclaration = this.findNonLocalEnumEntry((KtEnumEntry)ktDeclaration);
        } else if (ktDeclaration2 instanceof KtClassLikeDeclaration) {
            firDeclaration = this.findNonLocalClassLikeDeclaration((KtClassLikeDeclaration)ktDeclaration);
        } else if (ktDeclaration2 instanceof KtConstructor) {
            firDeclaration = this.findConstructorOfNonLocalClass((KtConstructor)ktDeclaration);
        } else if (ktDeclaration2 instanceof KtNamedFunction) {
            firDeclaration = this.findNonLocalFunction((KtNamedFunction)ktDeclaration);
        } else if (ktDeclaration2 instanceof KtProperty) {
            firDeclaration = this.findNonLocalProperty((KtProperty)ktDeclaration);
        } else if (ktDeclaration2 instanceof KtParameter) {
            firDeclaration = this.findParameter((KtParameter)ktDeclaration);
        } else if (ktDeclaration2 instanceof KtPropertyAccessor) {
            firDeclaration = this.findNonLocalPropertyAccessor((KtPropertyAccessor)ktDeclaration);
        } else if (ktDeclaration2 instanceof KtTypeParameter) {
            firDeclaration = this.findNonLocalTypeParameter((KtTypeParameter)ktDeclaration);
        } else {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("Unsupported compiled declaration of type", null, null, null, (PsiElement)ktDeclaration, null, 46, null);
            throw new KotlinNothingValueException();
        }
        return firDeclaration;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirFunctionSymbol<?>> findFunctionCandidates(KtNamedFunction function) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.findCallableCandidates((KtCallableDeclaration)function, function.isTopLevel());
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirFunctionSymbol)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirPropertySymbol> findPropertyCandidates(KtProperty property) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.findCallableCandidates((KtCallableDeclaration)property, property.isTopLevel());
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirPropertySymbol)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<FirCallableSymbol<?>> findCallableCandidates(KtCallableDeclaration declaration, boolean isTopLevel) {
        List<FirCallableSymbol<?>> list2;
        Object object;
        Name shortName;
        block13: {
            block12: {
                Name name2 = declaration.getNameAsSafeName();
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getNameAsSafeName(...)");
                shortName = name2;
                if (isTopLevel) {
                    List list3;
                    FqName packageFqName = declaration.getContainingKtFile().getPackageFqName();
                    FirSymbolProvider symbolProvider = FirSymbolProviderKt.getSymbolProvider(this.session);
                    if (symbolProvider instanceof LLModuleWithDependenciesSymbolProvider) {
                        List list4;
                        List $this$findCallableCandidates_u24lambda_u242 = list4 = CollectionsKt.createListBuilder();
                        boolean bl = false;
                        ((LLModuleWithDependenciesSymbolProvider)symbolProvider).getTopLevelDeserializedCallableSymbolsToWithoutDependencies($this$findCallableCandidates_u24lambda_u242, packageFqName, shortName, declaration);
                        FirSymbolProvider firSymbolProvider = FirDeclarationForCompiledElementSearcherKt.access$getFriendBuiltinsProvider((LLModuleWithDependenciesSymbolProvider)symbolProvider);
                        if (firSymbolProvider != null) {
                            firSymbolProvider.getTopLevelCallableSymbolsTo($this$findCallableCandidates_u24lambda_u242, packageFqName, shortName);
                        }
                        list3 = CollectionsKt.build((List)list4);
                    } else {
                        list3 = symbolProvider.getTopLevelCallableSymbols(packageFqName, shortName);
                    }
                    return list3;
                }
                object = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration));
                if (object == null) break block12;
                KtClassLikeDeclaration p0 = (KtClassLikeDeclaration)object;
                boolean bl = false;
                FirClassLikeDeclaration firClassLikeDeclaration = this.findNonLocalClassLikeDeclaration(p0);
                object = firClassLikeDeclaration;
                if (firClassLikeDeclaration != null) break block13;
            }
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("No containing non-local declaration found for", null, null, null, (PsiElement)declaration, null, 46, null);
            throw new KotlinNothingValueException();
        }
        Object containingClass = object;
        FirContainingNamesAwareScope scope = FirDeclaredMemberScopeProviderKt.declaredMemberScope((FirSession)this.session, (FirClass)containingClass, null);
        KtCallableDeclaration ktCallableDeclaration = declaration;
        if (ktCallableDeclaration instanceof KtProperty) {
            list2 = FirScopeKt.getProperties(scope, shortName);
        } else if (ktCallableDeclaration instanceof KtNamedFunction) {
            list2 = FirScopeKt.getFunctions(scope, shortName);
        } else {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("Unexpected callable " + Reflection.getOrCreateKotlinClass(declaration.getClass()).getSimpleName(), null, null, null, null, arg_0 -> FirDeclarationForCompiledElementSearcher.findCallableCandidates$lambda$3(isTopLevel, declaration, arg_0), 30, null);
            throw new KotlinNothingValueException();
        }
        return list2;
    }

    private final FirDeclaration findNonLocalTypeParameter(KtTypeParameter param) {
        FirTypeParameterRef firTypeParameterRef;
        Object v2;
        List<FirTypeParameterRef> typeParameters2;
        block6: {
            KtDeclaration ktDeclaration = FirElementBuilderKt.getContainingDeclaration(param);
            if (ktDeclaration == null) {
                ExceptionUtilsKt.errorWithFirSpecificEntries$default("Unsupported compiled type parameter", null, null, null, (PsiElement)param, null, 46, null);
                throw new KotlinNothingValueException();
            }
            KtDeclaration owner = ktDeclaration;
            FirDeclaration firDeclaration = this.findNonLocalDeclaration(owner);
            FirTypeParameterRefsOwner firTypeParameterRefsOwner = firDeclaration instanceof FirTypeParameterRefsOwner ? (FirTypeParameterRefsOwner)((Object)firDeclaration) : null;
            if (firTypeParameterRefsOwner == null) {
                ExceptionUtilsKt.errorWithFirSpecificEntries$default("No fir found by " + owner, null, firDeclaration, null, (PsiElement)owner, null, 42, null);
                throw new KotlinNothingValueException();
            }
            FirTypeParameterRefsOwner firTypeParameterRefOwner = firTypeParameterRefsOwner;
            typeParameters2 = firTypeParameterRefOwner.getTypeParameters();
            Iterable $this$firstOrNull$iv = typeParameters2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirTypeParameterRef it = (FirTypeParameterRef)element$iv;
                boolean bl = false;
                if (!this.getFirElementByPsiElementChooser().isMatchingTypeParameter(param, (FirTypeParameter)it.getSymbol().getFir())) continue;
                v2 = element$iv;
                break block6;
            }
            v2 = null;
        }
        if ((firTypeParameterRef = (FirTypeParameterRef)v2) == null) {
            Object v4;
            block7: {
                Iterable $this$firstOrNull$iv = typeParameters2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FirTypeParameterRef it = (FirTypeParameterRef)element$iv;
                    boolean bl = false;
                    if (!this.mismatchedPsiFirElementChooser.isMatchingTypeParameter(param, (FirTypeParameter)it.getSymbol().getFir())) continue;
                    v4 = element$iv;
                    break block7;
                }
                v4 = null;
            }
            if ((firTypeParameterRef = (FirTypeParameterRef)v4) == null) {
                ExceptionUtilsKt.errorWithFirSpecificEntries$default("No fir type parameter found", null, null, null, (PsiElement)param, arg_0 -> FirDeclarationForCompiledElementSearcher.findNonLocalTypeParameter$lambda$7(typeParameters2, arg_0), 14, null);
                throw new KotlinNothingValueException();
            }
        }
        FirTypeParameterRef typeParameter = firTypeParameterRef;
        return (FirDeclaration)((Object)typeParameter);
    }

    private final FirDeclaration findParameter(KtParameter param) {
        FirDeclaration firDeclaration;
        KtDeclaration ktDeclaration = param.getOwnerDeclaration();
        if (ktDeclaration == null) {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("Unsupported compiled parameter", null, null, null, (PsiElement)param, null, 46, null);
            throw new KotlinNothingValueException();
        }
        KtDeclaration ownerDeclaration = ktDeclaration;
        FirDeclaration firDeclaration2 = this.findNonLocalDeclaration(ownerDeclaration);
        if (param.isContextParameter()) {
            FirValueParameter firValueParameter;
            Object object;
            FirValueParameter it;
            FirCallableDeclaration firCallable;
            block13: {
                FirCallableDeclaration firCallableDeclaration = firDeclaration2 instanceof FirCallableDeclaration ? (FirCallableDeclaration)firDeclaration2 : null;
                if (firCallableDeclaration == null) {
                    ExceptionUtilsKt.errorWithFirSpecificEntries$default(Reflection.getOrCreateKotlinClass(FirCallableDeclaration.class).getSimpleName() + " expected but " + Reflection.getOrCreateKotlinClass(firDeclaration2.getClass()).getSimpleName() + " found", null, firDeclaration2, null, (PsiElement)ownerDeclaration, null, 42, null);
                    throw new KotlinNothingValueException();
                }
                firCallable = firCallableDeclaration;
                Iterable iterable = firCallable.getContextParameters();
                for (Object object2 : iterable) {
                    it = (FirValueParameter)object2;
                    boolean bl = false;
                    if (!this.getFirElementByPsiElementChooser().isMatchingValueParameter(param, it)) continue;
                    object = object2;
                    break block13;
                }
                object = null;
            }
            if ((firValueParameter = (FirValueParameter)object) == null) {
                FirValueParameter firValueParameter2;
                block14: {
                    Object object2;
                    Iterable iterable = firCallable.getContextParameters();
                    object2 = iterable.iterator();
                    while (object2.hasNext()) {
                        FirValueParameter it2 = it = object2.next();
                        boolean bl = false;
                        if (!this.mismatchedPsiFirElementChooser.isMatchingValueParameter(param, it2)) continue;
                        firValueParameter2 = it;
                        break block14;
                    }
                    firValueParameter2 = null;
                }
                if ((firValueParameter = (FirValueParameter)firValueParameter2) == null) {
                    ExceptionUtilsKt.errorWithFirSpecificEntries$default("No fir value parameter found", null, firCallable, null, (PsiElement)param, null, 42, null);
                    throw new KotlinNothingValueException();
                }
            }
            firDeclaration = firValueParameter;
        } else {
            FirValueParameter firValueParameter;
            Object object;
            FirFunction firFunction;
            block15: {
                FirFunction firFunction2 = firDeclaration2 instanceof FirFunction ? (FirFunction)firDeclaration2 : null;
                if (firFunction2 == null) {
                    ExceptionUtilsKt.errorWithFirSpecificEntries$default(Reflection.getOrCreateKotlinClass(FirFunction.class).getSimpleName() + " expected but " + Reflection.getOrCreateKotlinClass(firDeclaration2.getClass()).getSimpleName() + " found", null, firDeclaration2, null, (PsiElement)ownerDeclaration, null, 42, null);
                    throw new KotlinNothingValueException();
                }
                firFunction = firFunction2;
                Iterable iterable = firFunction.getValueParameters();
                for (Object object3 : iterable) {
                    FirValueParameter it = (FirValueParameter)object3;
                    boolean bl = false;
                    if (!this.getFirElementByPsiElementChooser().isMatchingValueParameter(param, it)) continue;
                    object = object3;
                    break block15;
                }
                object = null;
            }
            if ((firValueParameter = (FirValueParameter)object) == null) {
                Object v9;
                block16: {
                    Object object3;
                    Iterable iterable = firFunction.getValueParameters();
                    object3 = iterable.iterator();
                    while (object3.hasNext()) {
                        Object e = object3.next();
                        FirValueParameter it = (FirValueParameter)e;
                        boolean bl = false;
                        if (!this.mismatchedPsiFirElementChooser.isMatchingValueParameter(param, it)) continue;
                        v9 = e;
                        break block16;
                    }
                    v9 = null;
                }
                if ((firValueParameter = (FirValueParameter)v9) == null) {
                    ExceptionUtilsKt.errorWithFirSpecificEntries$default("No fir value parameter found", null, firFunction, null, (PsiElement)param, null, 42, null);
                    throw new KotlinNothingValueException();
                }
            }
            firDeclaration = firValueParameter;
        }
        return firDeclaration;
    }

    private final FirEnumEntry findNonLocalEnumEntry(KtEnumEntry declaration) {
        FirDeclaration firDeclaration;
        Object v2;
        List<FirDeclaration> declarations2;
        block8: {
            Object object;
            block11: {
                block10: {
                    object = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration));
                    if (object == null) break block10;
                    KtClassLikeDeclaration p0 = (KtClassLikeDeclaration)object;
                    boolean bl = false;
                    FirClassLikeDeclaration firClassLikeDeclaration = this.findNonLocalClassLikeDeclaration(p0);
                    object = firClassLikeDeclaration;
                    if (firClassLikeDeclaration != null) break block11;
                }
                ExceptionUtilsKt.errorWithFirSpecificEntries$default("Enum entry must have containing class", null, null, null, (PsiElement)declaration, null, 46, null);
                throw new KotlinNothingValueException();
            }
            Object classCandidate = object;
            declarations2 = ((FirRegularClass)classCandidate).getDeclarations();
            Iterable $this$firstOrNull$iv = declarations2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirDeclaration it = (FirDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof FirEnumEntry && this.getFirElementByPsiElementChooser().isMatchingEnumEntry(declaration, (FirEnumEntry)it))) continue;
                v2 = element$iv;
                break block8;
            }
            v2 = null;
        }
        if ((firDeclaration = (FirDeclaration)v2) == null) {
            Object v4;
            block9: {
                Iterable $this$firstOrNull$iv = declarations2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FirDeclaration it = (FirDeclaration)element$iv;
                    boolean bl = false;
                    if (!(it instanceof FirEnumEntry && this.mismatchedPsiFirElementChooser.isMatchingEnumEntry(declaration, (FirEnumEntry)it))) continue;
                    v4 = element$iv;
                    break block9;
                }
                v4 = null;
            }
            if ((firDeclaration = (FirDeclaration)v4) == null) {
                ExceptionUtilsKt.errorWithFirSpecificEntries$default("We should be able to find an enum entry", null, null, null, (PsiElement)declaration, arg_0 -> FirDeclarationForCompiledElementSearcher.findNonLocalEnumEntry$lambda$16(declarations2, arg_0), 14, null);
                throw new KotlinNothingValueException();
            }
        }
        FirDeclaration enumEntry = firDeclaration;
        return (FirEnumEntry)enumEntry;
    }

    private final FirClassLikeDeclaration findNonLocalClassLikeDeclaration(KtClassLikeDeclaration declaration) {
        FirClassLikeSymbol<?> classCandidate;
        FirClassLikeSymbol<Object> firClassLikeSymbol;
        ClassId classId = declaration.getClassId();
        if (classId == null) {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("Non-local class should have classId", null, null, null, (PsiElement)declaration, null, 46, null);
            throw new KotlinNothingValueException();
        }
        ClassId classId2 = classId;
        FirSymbolProvider symbolProvider = FirSymbolProviderKt.getSymbolProvider(this.session);
        if (symbolProvider instanceof LLModuleWithDependenciesSymbolProvider) {
            firClassLikeSymbol = ((LLModuleWithDependenciesSymbolProvider)symbolProvider).getDeserializedClassLikeSymbolByClassIdWithoutDependencies(classId2, declaration);
            if (firClassLikeSymbol == null) {
                FirSymbolProvider firSymbolProvider = FirDeclarationForCompiledElementSearcherKt.access$getFriendBuiltinsProvider((LLModuleWithDependenciesSymbolProvider)symbolProvider);
                firClassLikeSymbol = firSymbolProvider != null ? firSymbolProvider.getClassLikeSymbolByClassId(classId2) : null;
            }
        } else {
            firClassLikeSymbol = symbolProvider.getClassLikeSymbolByClassId(classId2);
        }
        if ((classCandidate = firClassLikeSymbol) != null && this.getFirElementByPsiElementChooser().isMatchingClassLikeDeclaration(classId2, declaration, (FirClassLikeDeclaration)classCandidate.getFir())) {
            return (FirClassLikeDeclaration)classCandidate.getFir();
        }
        if (classCandidate != null) {
            return (FirClassLikeDeclaration)classCandidate.getFir();
        }
        ExceptionUtilsKt.errorWithFirSpecificEntries$default("We should be able to find a symbol for " + classId2 + " (has candidate: " + false + ')', null, null, null, (PsiElement)declaration, arg_0 -> FirDeclarationForCompiledElementSearcher.findNonLocalClassLikeDeclaration$lambda$19(classId2, classCandidate, this, declaration, arg_0), 14, null);
        throw new KotlinNothingValueException();
    }

    private final FirConstructor findConstructorOfNonLocalClass(KtConstructor<?> declaration) {
        FirConstructorSymbol firConstructorSymbol;
        Object v2;
        List<FirConstructorSymbol> constructors2;
        FirClass containingFirClass;
        block7: {
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration));
            if (ktClassOrObject == null) {
                ExceptionUtilsKt.errorWithFirSpecificEntries$default("Constructor must have outer class", null, null, null, (PsiElement)declaration, null, 46, null);
                throw new KotlinNothingValueException();
            }
            KtClassOrObject containingClass = ktClassOrObject;
            FirClassLikeDeclaration firClassLikeDeclaration = this.findNonLocalClassLikeDeclaration((KtClassLikeDeclaration)containingClass);
            Intrinsics.checkNotNull((Object)firClassLikeDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirClass");
            containingFirClass = (FirClass)firClassLikeDeclaration;
            constructors2 = DeclarationUtilsKt.constructors(containingFirClass, (FirSession)this.session);
            Iterable $this$singleOrNull$iv = constructors2;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                FirConstructorSymbol it = (FirConstructorSymbol)element$iv;
                boolean bl = false;
                if (!this.getFirElementByPsiElementChooser().isMatchingCallableDeclaration((KtCallableDeclaration)declaration, (FirCallableDeclaration)it.getFir())) continue;
                if (found$iv) {
                    v2 = null;
                    break block7;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v2 = !found$iv ? null : single$iv;
        }
        if ((firConstructorSymbol = (FirConstructorSymbol)v2) == null) {
            Object v4;
            block8: {
                Iterable $this$singleOrNull$iv = constructors2;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    FirConstructorSymbol it = (FirConstructorSymbol)element$iv;
                    boolean bl = false;
                    if (!this.mismatchedPsiFirElementChooser.isMatchingCallableDeclaration((KtCallableDeclaration)declaration, (FirCallableDeclaration)it.getFir())) continue;
                    if (found$iv) {
                        v4 = null;
                        break block8;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v4 = !found$iv ? null : single$iv;
            }
            if ((firConstructorSymbol = (FirConstructorSymbol)v4) == null) {
                ExceptionUtilsKt.errorWithFirSpecificEntries$default("We should be able to find a constructor", null, containingFirClass, null, (PsiElement)declaration, null, 42, null);
                throw new KotlinNothingValueException();
            }
        }
        FirConstructorSymbol constructorCandidate = firConstructorSymbol;
        return (FirConstructor)constructorCandidate.getFir();
    }

    private final FirFunction findNonLocalFunction(KtNamedFunction declaration) {
        FirFunctionSymbol firFunctionSymbol;
        Object v0;
        List<FirFunctionSymbol<?>> candidates2;
        block5: {
            if (!(!declaration.isLocal())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            candidates2 = this.findFunctionCandidates(declaration);
            Iterable $this$firstOrNull$iv = candidates2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirFunctionSymbol it = (FirFunctionSymbol)element$iv;
                boolean bl = false;
                if (!this.getFirElementByPsiElementChooser().isMatchingCallableDeclaration((KtCallableDeclaration)declaration, (FirCallableDeclaration)it.getFir())) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        if ((firFunctionSymbol = (FirFunctionSymbol)v0) == null) {
            Object v2;
            block6: {
                Iterable $this$firstOrNull$iv = candidates2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FirFunctionSymbol it = (FirFunctionSymbol)element$iv;
                    boolean bl = false;
                    if (!this.mismatchedPsiFirElementChooser.isMatchingCallableDeclaration((KtCallableDeclaration)declaration, (FirCallableDeclaration)it.getFir())) continue;
                    v2 = element$iv;
                    break block6;
                }
                v2 = null;
            }
            if ((firFunctionSymbol = (FirFunctionSymbol)v2) == null) {
                ExceptionUtilsKt.errorWithFirSpecificEntries$default("We should be able to find a symbol for function", null, null, null, (PsiElement)declaration, arg_0 -> FirDeclarationForCompiledElementSearcher.findNonLocalFunction$lambda$24(candidates2, arg_0), 14, null);
                throw new KotlinNothingValueException();
            }
        }
        FirFunctionSymbol functionCandidate = firFunctionSymbol;
        return (FirFunction)functionCandidate.getFir();
    }

    private final FirProperty findNonLocalProperty(KtProperty declaration) {
        FirPropertySymbol firPropertySymbol;
        Object v0;
        List<FirPropertySymbol> candidates2;
        block5: {
            if (!(!declaration.isLocal())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            candidates2 = this.findPropertyCandidates(declaration);
            Iterable $this$firstOrNull$iv = candidates2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirPropertySymbol it = (FirPropertySymbol)element$iv;
                boolean bl = false;
                if (!this.getFirElementByPsiElementChooser().isMatchingCallableDeclaration((KtCallableDeclaration)declaration, (FirCallableDeclaration)it.getFir())) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        if ((firPropertySymbol = (FirPropertySymbol)v0) == null) {
            Object v2;
            block6: {
                Iterable $this$firstOrNull$iv = candidates2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FirPropertySymbol it = (FirPropertySymbol)element$iv;
                    boolean bl = false;
                    if (!this.mismatchedPsiFirElementChooser.isMatchingCallableDeclaration((KtCallableDeclaration)declaration, (FirCallableDeclaration)it.getFir())) continue;
                    v2 = element$iv;
                    break block6;
                }
                v2 = null;
            }
            if ((firPropertySymbol = (FirPropertySymbol)v2) == null) {
                ExceptionUtilsKt.errorWithFirSpecificEntries$default("We should be able to find a symbol for property", null, null, null, (PsiElement)declaration, arg_0 -> FirDeclarationForCompiledElementSearcher.findNonLocalProperty$lambda$27(candidates2, arg_0), 14, null);
                throw new KotlinNothingValueException();
            }
        }
        FirPropertySymbol propertyCandidate = firPropertySymbol;
        return (FirProperty)propertyCandidate.getFir();
    }

    private final FirPropertyAccessor findNonLocalPropertyAccessor(KtPropertyAccessor declaration) {
        KtProperty ktProperty = declaration.getProperty();
        Intrinsics.checkNotNullExpressionValue((Object)ktProperty, (String)"getProperty(...)");
        FirProperty firProperty = this.findNonLocalProperty(ktProperty);
        FirPropertyAccessor firPropertyAccessor = declaration.isGetter() ? firProperty.getGetter() : firProperty.getSetter();
        if (firPropertyAccessor == null) {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("We should be able to find a symbol for property accessor", null, null, null, (PsiElement)declaration, null, 46, null);
            throw new KotlinNothingValueException();
        }
        return firPropertyAccessor;
    }

    private static final KotlinProjectStructureProvider projectStructureProvider_delegate$lambda$0(FirDeclarationForCompiledElementSearcher this$0) {
        return KotlinProjectStructureProvider.Companion.getInstance(this$0.getProject());
    }

    private static final LLFirElementByPsiElementChooser firElementByPsiElementChooser_delegate$lambda$1(FirDeclarationForCompiledElementSearcher this$0) {
        return LLFirElementByPsiElementChooser.Companion.getInstance(this$0.getProject());
    }

    private static final Unit findCallableCandidates$lambda$3(boolean $isTopLevel, KtCallableDeclaration $declaration, ExceptionAttachmentBuilder $this$errorWithFirSpecificEntries) {
        Intrinsics.checkNotNullParameter((Object)$this$errorWithFirSpecificEntries, (String)"$this$errorWithFirSpecificEntries");
        $this$errorWithFirSpecificEntries.withEntry("isTopLevel", String.valueOf($isTopLevel));
        ExceptionAttachementBuilderUtilsKt.withPsiEntry((ExceptionAttachmentBuilder)$this$errorWithFirSpecificEntries, (String)"declaration", (PsiElement)((PsiElement)$declaration));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit findNonLocalTypeParameter$lambda$7(List $typeParameters, ExceptionAttachmentBuilder $this$errorWithFirSpecificEntries) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$errorWithFirSpecificEntries, (String)"$this$errorWithFirSpecificEntries");
        Iterable iterable = $typeParameters;
        ExceptionAttachmentBuilder exceptionAttachmentBuilder = $this$errorWithFirSpecificEntries;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        FirDeclarationForCompiledElementSearcherKt.access$withCandidates(exceptionAttachmentBuilder, (List)destination$iv$iv);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit findNonLocalEnumEntry$lambda$16(List $declarations, ExceptionAttachmentBuilder $this$errorWithFirSpecificEntries) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)$this$errorWithFirSpecificEntries, (String)"$this$errorWithFirSpecificEntries");
        Iterable iterable = $declarations;
        ExceptionAttachmentBuilder exceptionAttachmentBuilder = $this$errorWithFirSpecificEntries;
        boolean $i$f$filterIsInstance = false;
        void var4_5 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirEnumEntry)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirEnumEntry firEnumEntry = (FirEnumEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        FirDeclarationForCompiledElementSearcherKt.access$withCandidates(exceptionAttachmentBuilder, (List)destination$iv$iv);
        return Unit.INSTANCE;
    }

    private static final String findNonLocalClassLikeDeclaration$lambda$19$lambda$17(ClassId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.asString();
    }

    private static final String findNonLocalClassLikeDeclaration$lambda$19$lambda$18(KaModule it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getModuleDescription();
    }

    private static final Unit findNonLocalClassLikeDeclaration$lambda$19(ClassId $classId, FirClassLikeSymbol $classCandidate, FirDeclarationForCompiledElementSearcher this$0, KtClassLikeDeclaration $declaration, ExceptionAttachmentBuilder $this$errorWithFirSpecificEntries) {
        Intrinsics.checkNotNullParameter((Object)$this$errorWithFirSpecificEntries, (String)"$this$errorWithFirSpecificEntries");
        $this$errorWithFirSpecificEntries.withEntry("classId", (Object)$classId, FirDeclarationForCompiledElementSearcher::findNonLocalClassLikeDeclaration$lambda$19$lambda$17);
        Object object = $classCandidate;
        ExceptionAttachementBuilderUtilsKt.withPsiEntry((ExceptionAttachmentBuilder)$this$errorWithFirSpecificEntries, (String)"candidatePsi", object != null && (object = (FirClassLikeDeclaration)((FirBasedSymbol)object).getFir()) != null ? UtilsKt.getPsi((FirElement)object) : null);
        FirClassLikeSymbol firClassLikeSymbol = $classCandidate;
        FirExceptionUtilsKt.withFirEntry($this$errorWithFirSpecificEntries, "candidateFir", firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null);
        KaModule contextualModule = LLFirModuleDataKt.getLlFirModuleData(this$0.session).getKtModule();
        KaModule moduleForFile = this$0.getProjectStructureProvider().getModule((PsiElement)$declaration, contextualModule);
        $this$errorWithFirSpecificEntries.withEntry("ktModule", (Object)moduleForFile, FirDeclarationForCompiledElementSearcher::findNonLocalClassLikeDeclaration$lambda$19$lambda$18);
        return Unit.INSTANCE;
    }

    private static final Unit findNonLocalFunction$lambda$24(List $candidates, ExceptionAttachmentBuilder $this$errorWithFirSpecificEntries) {
        Intrinsics.checkNotNullParameter((Object)$this$errorWithFirSpecificEntries, (String)"$this$errorWithFirSpecificEntries");
        FirDeclarationForCompiledElementSearcherKt.access$withCandidates($this$errorWithFirSpecificEntries, $candidates);
        return Unit.INSTANCE;
    }

    private static final Unit findNonLocalProperty$lambda$27(List $candidates, ExceptionAttachmentBuilder $this$errorWithFirSpecificEntries) {
        Intrinsics.checkNotNullParameter((Object)$this$errorWithFirSpecificEntries, (String)"$this$errorWithFirSpecificEntries");
        FirDeclarationForCompiledElementSearcherKt.access$withCandidates($this$errorWithFirSpecificEntries, $candidates);
        return Unit.INSTANCE;
    }
}

