/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.symbols.pointers;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaImplementationDetail;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.fir.utils.KtSymbolUtilsKt;
import org.jetbrains.kotlin.analysis.api.impl.base.symbols.pointers.KaBaseCachedSymbolPointer;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KaDeclarationContainerSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.pointers.KaSymbolPointer;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSession;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B)\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0005\u00a2\u0006\u0002\u0010\u000fJ#\u0010\u0010\u001a\u0004\u0018\u00018\u0000*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H$\u00a2\u0006\u0002\u0010\u0016J\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\u00112\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0014J\u0016\u0010\u001a\u001a\u00020\b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H&J\u0014\u0010\u001c\u001a\u00020\b2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0004R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/symbols/pointers/KaFirMemberSymbolPointer;", "S", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/KaBaseCachedSymbolPointer;", "ownerPointer", "Lorg/jetbrains/kotlin/analysis/api/symbols/pointers/KaSymbolPointer;", "Lorg/jetbrains/kotlin/analysis/api/symbols/markers/KaDeclarationContainerSymbol;", "isStatic", "", "originalSymbol", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/symbols/pointers/KaSymbolPointer;ZLorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;)V", "restoreIfNotCached", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;)Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "chooseCandidateAndCreateSymbol", "Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "candidates", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "firSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;Lorg/jetbrains/kotlin/fir/scopes/FirScope;Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "getSearchScope", "owner", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "pointsToTheSameSymbolAs", "other", "hasTheSameOwner", "analysis-api-fir"})
public abstract class KaFirMemberSymbolPointer<S extends KaSymbol>
extends KaBaseCachedSymbolPointer<S> {
    @NotNull
    private final KaSymbolPointer<KaDeclarationContainerSymbol> ownerPointer;
    private final boolean isStatic;

    public KaFirMemberSymbolPointer(@NotNull KaSymbolPointer<? extends KaDeclarationContainerSymbol> ownerPointer, boolean isStatic, @Nullable S originalSymbol) {
        Intrinsics.checkNotNullParameter(ownerPointer, (String)"ownerPointer");
        super(originalSymbol);
        this.ownerPointer = ownerPointer;
        this.isStatic = isStatic;
    }

    public /* synthetic */ KaFirMemberSymbolPointer(KaSymbolPointer kaSymbolPointer, boolean bl, KaSymbol kaSymbol, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(kaSymbolPointer, bl, kaSymbol);
    }

    @Override
    @KaImplementationDetail
    @Nullable
    protected final S restoreIfNotCached(@NotNull KaSession analysisSession) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        if (!(analysisSession instanceof KaFirSession)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        KaFirSession $this$restoreIfNotCached_u24lambda_u240 = (KaFirSession)analysisSession;
        boolean bl = false;
        KaDeclarationContainerSymbol kaDeclarationContainerSymbol = $this$restoreIfNotCached_u24lambda_u240.restoreSymbol(this.ownerPointer);
        if (kaDeclarationContainerSymbol == null) {
            return null;
        }
        KaDeclarationContainerSymbol ownerSymbol = kaDeclarationContainerSymbol;
        FirBasedSymbol<?> firBasedSymbol = KtSymbolUtilsKt.getFirSymbol(ownerSymbol);
        FirClassSymbol firClassSymbol = firBasedSymbol instanceof FirClassSymbol ? (FirClassSymbol)firBasedSymbol : null;
        if (firClassSymbol == null) {
            return null;
        }
        FirClassSymbol owner = firClassSymbol;
        FirScope firScope = this.getSearchScope((KaFirSession)analysisSession, owner);
        if (firScope == null) {
            return null;
        }
        FirScope scope = firScope;
        return this.chooseCandidateAndCreateSymbol((KaFirSession)analysisSession, scope, ((KaFirSession)analysisSession).getFirSession$analysis_api_fir());
    }

    @Nullable
    protected abstract S chooseCandidateAndCreateSymbol(@NotNull KaFirSession var1, @NotNull FirScope var2, @NotNull FirSession var3);

    @Nullable
    protected FirScope getSearchScope(@NotNull KaFirSession analysisSession, @NotNull FirClassSymbol<?> owner) {
        FirScope firScope;
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter(owner, (String)"owner");
        LLFirSession firSession = analysisSession.getFirSession$analysis_api_fir();
        ScopeSession scopeSession = analysisSession.getScopeSessionFor(firSession);
        if (this.isStatic) {
            FirClass firClass = (FirClass)owner.getFir();
            firScope = firClass.getScopeProvider().getStaticCallableMemberScope(firClass, firSession, scopeSession);
        } else {
            firScope = FirKotlinScopeProviderKt.unsubstitutedScope(owner, (FirSession)firSession, scopeSession, false, FirResolvePhase.STATUS);
        }
        return firScope;
    }

    @Override
    public abstract boolean pointsToTheSameSymbolAs(@NotNull KaSymbolPointer<? extends KaSymbol> var1);

    protected final boolean hasTheSameOwner(@NotNull KaFirMemberSymbolPointer<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return other.isStatic == this.isStatic && other.ownerPointer.pointsToTheSameSymbolAs(this.ownerPointer);
    }
}

