/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.patch.RelativePathCalculator;
import com.intellij.openapi.vcs.impl.VcsPathPresenter;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class PlatformVcsPathPresenter
extends VcsPathPresenter {
    @NotNull
    public String getPresentableRelativePathFor(VirtualFile file) {
        String string = FileUtil.toSystemDependentName((String)file.getPath());
        if (string == null) {
            PlatformVcsPathPresenter.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getPresentableRelativePath(ContentRevision fromRevision, ContentRevision toRevision) {
        FilePath path = toRevision.getFile();
        FilePath originalPath = fromRevision.getFile();
        return PlatformVcsPathPresenter.getPresentableRelativePath(path, originalPath);
    }

    @NlsSafe
    @NotNull
    public static String getPresentableRelativePath(@NotNull FilePath path, @NotNull FilePath originalPath) {
        if (path == null) {
            PlatformVcsPathPresenter.$$$reportNull$$$0(1);
        }
        if (originalPath == null) {
            PlatformVcsPathPresenter.$$$reportNull$$$0(2);
        }
        String relativePath = RelativePathCalculator.computeRelativePath(path.getPath(), originalPath.getPath(), false);
        String string = FileUtilRt.toSystemDependentName((String)relativePath);
        if (string == null) {
            PlatformVcsPathPresenter.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/PlatformVcsPathPresenter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableRelativePathFor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/PlatformVcsPathPresenter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableRelativePath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableRelativePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

