/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch.tool;

import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.tools.simple.AlignableChange;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.util.DiffRangeUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchLine;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.tool.PatchChangeBuilderKt;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\b\u0007\u0018\u0000 )2\u00020\u0001:\u0006$%&'()B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u0014\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0011J&\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00112\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J&\u0010\u001e\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00112\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\rH\u0002J\u0016\u0010\"\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0011H\u0002J\b\u0010#\u001a\u00020\u0018H\u0002R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder;", "", "<init>", "()V", "textBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "convertor1", "Lcom/intellij/diff/tools/fragmented/LineNumberConvertor$Builder;", "convertor2", "separatorLines", "Lit/unimi/dsi/fastutil/ints/IntList;", "totalLines", "", "buildFromApplied", "Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$AppliedPatchState;", "splitHunks", "", "Lcom/intellij/openapi/vcs/changes/patch/AppliedTextPatch$AppliedSplitPatchHunk;", "build", "Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$PatchState;", "patchHunks", "Lcom/intellij/openapi/diff/impl/patch/PatchHunk;", "addChangedLines", "", "lines", "", "lineNumber", "isAddition", "", "addContext", "context", "beforeLineNumber", "afterLineNumber", "appendLines", "appendSeparator", "PatchState", "AppliedPatchState", "Hunk", "AppliedHunk", "PatchSideChange", "Companion", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPatchChangeBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatchChangeBuilder.kt\ncom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,332:1\n1563#2:333\n1634#2,3:334\n1563#2:337\n1634#2,3:338\n1563#2:341\n1634#2,3:342\n*S KotlinDebug\n*F\n+ 1 PatchChangeBuilder.kt\ncom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder\n*L\n89#1:333\n89#1:334,3\n94#1:337\n94#1:338,3\n98#1:341\n98#1:342,3\n*E\n"})
public final class PatchChangeBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StringBuilder textBuilder = new StringBuilder();
    @NotNull
    private final LineNumberConvertor.Builder convertor1 = new LineNumberConvertor.Builder();
    @NotNull
    private final LineNumberConvertor.Builder convertor2 = new LineNumberConvertor.Builder();
    @NotNull
    private final IntList separatorLines = (IntList)new IntArrayList();
    private int totalLines;

    @NotNull
    public final AppliedPatchState buildFromApplied(@NotNull List<? extends AppliedTextPatch.AppliedSplitPatchHunk> splitHunks) {
        Intrinsics.checkNotNullParameter(splitHunks, (String)"splitHunks");
        List hunks = new ArrayList();
        int lastBeforeLine = -1;
        for (AppliedTextPatch.AppliedSplitPatchHunk appliedSplitPatchHunk : splitHunks) {
            List<String> contextAfter;
            LineRange afterRange;
            List<String> contextBefore;
            LineRange beforeRange;
            Intrinsics.checkNotNullExpressionValue(appliedSplitPatchHunk.getContextBefore(), (String)"getContextBefore(...)");
            Intrinsics.checkNotNullExpressionValue(appliedSplitPatchHunk.getContextAfter(), (String)"getContextAfter(...)");
            Intrinsics.checkNotNullExpressionValue((Object)appliedSplitPatchHunk.getLineRangeBefore(), (String)"getLineRangeBefore(...)");
            Intrinsics.checkNotNullExpressionValue((Object)appliedSplitPatchHunk.getLineRangeAfter(), (String)"getLineRangeAfter(...)");
            int overlappedContext = 0;
            if (lastBeforeLine != -1) {
                if (lastBeforeLine >= beforeRange.start) {
                    overlappedContext = lastBeforeLine - beforeRange.start + 1;
                } else if (lastBeforeLine < beforeRange.start - 1) {
                    this.appendSeparator();
                }
            }
            List<String> trimContext = contextBefore.subList(overlappedContext, contextBefore.size());
            this.addContext(trimContext, beforeRange.start + overlappedContext, afterRange.start + overlappedContext);
            int deletion = this.totalLines;
            List<String> list = appliedSplitPatchHunk.getDeletedLines();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDeletedLines(...)");
            this.addChangedLines(list, beforeRange.start + contextBefore.size(), false);
            int insertion = this.totalLines;
            List<String> list2 = appliedSplitPatchHunk.getInsertedLines();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getInsertedLines(...)");
            this.addChangedLines(list2, afterRange.start + contextBefore.size(), true);
            int hunkEnd = this.totalLines;
            this.addContext(contextAfter, beforeRange.end - contextAfter.size(), afterRange.end - contextAfter.size());
            lastBeforeLine = beforeRange.end - 1;
            LineRange deletionRange = new LineRange(deletion, insertion);
            LineRange insertionRange = new LineRange(insertion, hunkEnd);
            LineRange lineRange = appliedSplitPatchHunk.getAppliedTo();
            AppliedTextPatch.HunkStatus hunkStatus = appliedSplitPatchHunk.getStatus();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)hunkStatus), (String)"getStatus(...)");
            hunks.add(new AppliedHunk(deletionRange, insertionRange, lineRange, hunkStatus));
        }
        CharSequence charSequence = this.textBuilder;
        LineNumberConvertor lineNumberConvertor = this.convertor1.build();
        Intrinsics.checkNotNullExpressionValue((Object)lineNumberConvertor, (String)"build(...)");
        LineNumberConvertor lineNumberConvertor2 = this.convertor2.build();
        Intrinsics.checkNotNullExpressionValue((Object)lineNumberConvertor2, (String)"build(...)");
        return new AppliedPatchState(charSequence, hunks, lineNumberConvertor, lineNumberConvertor2, this.separatorLines);
    }

    @NotNull
    public final PatchState build(@NotNull List<? extends PatchHunk> patchHunks) {
        Intrinsics.checkNotNullParameter(patchHunks, (String)"patchHunks");
        List hunks = new ArrayList();
        for (PatchHunk patchHunk : patchHunks) {
            if (this.totalLines > 0) {
                this.appendSeparator();
            }
            LineRange beforeRange = new LineRange(patchHunk.getStartLineBefore(), patchHunk.getEndLineBefore());
            LineRange afterRange = new LineRange(patchHunk.getStartLineAfter(), patchHunk.getEndLineAfter());
            Ref.IntRef beforeBlockLines = new Ref.IntRef();
            Ref.IntRef afterBlockLines = new Ref.IntRef();
            List list = patchHunk.getLines();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getLines(...)");
            PatchChangeBuilderKt.access$cutIntoBlocks(list, (arg_0, arg_1, arg_2) -> PatchChangeBuilder.build$lambda$3(this, beforeRange, beforeBlockLines, afterRange, afterBlockLines, hunks, arg_0, arg_1, arg_2));
        }
        CharSequence charSequence = this.textBuilder;
        LineNumberConvertor lineNumberConvertor = this.convertor1.build();
        Intrinsics.checkNotNullExpressionValue((Object)lineNumberConvertor, (String)"build(...)");
        LineNumberConvertor lineNumberConvertor2 = this.convertor2.build();
        Intrinsics.checkNotNullExpressionValue((Object)lineNumberConvertor2, (String)"build(...)");
        return new PatchState(charSequence, hunks, lineNumberConvertor, lineNumberConvertor2, this.separatorLines);
    }

    private final void addChangedLines(List<String> lines, int lineNumber, boolean isAddition) {
        if (isAddition) {
            this.convertor2.put(this.totalLines, lineNumber, lines.size());
        } else {
            this.convertor1.put(this.totalLines, lineNumber, lines.size());
        }
        this.appendLines(lines);
    }

    private final void addContext(List<String> context, int beforeLineNumber, int afterLineNumber) {
        this.convertor1.put(this.totalLines, beforeLineNumber, context.size());
        this.convertor2.put(this.totalLines, afterLineNumber, context.size());
        this.appendLines(context);
    }

    private final void appendLines(List<String> lines) {
        Iterator<String> iterator = lines.iterator();
        while (iterator.hasNext()) {
            String line;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            this.textBuilder.append(line).append("\n");
        }
        this.totalLines += lines.size();
    }

    private final void appendSeparator() {
        this.separatorLines.add(this.totalLines);
        this.textBuilder.append("\n");
        int n = this.totalLines;
        this.totalLines = n + 1;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit build$lambda$3(PatchChangeBuilder this$0, LineRange $beforeRange, Ref.IntRef $beforeBlockLines, LineRange $afterRange, Ref.IntRef $afterBlockLines, List $hunks, List preContextLines, List deletedLines, List insertedLines) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Collection collection;
        void $this$mapTo$iv$iv3;
        void $this$map$iv3;
        Intrinsics.checkNotNullParameter((Object)preContextLines, (String)"preContextLines");
        Intrinsics.checkNotNullParameter((Object)deletedLines, (String)"deletedLines");
        Intrinsics.checkNotNullParameter((Object)insertedLines, (String)"insertedLines");
        Iterable iterable = preContextLines;
        PatchChangeBuilder patchChangeBuilder = this$0;
        boolean $i$f$map22 = false;
        void var11_15 = $this$map$iv3;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void line;
            PatchLine patchLine = (PatchLine)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = line.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            collection.add(string);
        }
        patchChangeBuilder.addContext((List)destination$iv$iv, $beforeRange.start + $beforeBlockLines.element, $afterRange.start + $afterBlockLines.element);
        $beforeBlockLines.element += preContextLines.size();
        $afterBlockLines.element += preContextLines.size();
        int deletion = this$0.totalLines;
        Iterable $i$f$map22 = deletedLines;
        patchChangeBuilder = this$0;
        boolean $i$f$map32 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void line;
            PatchLine bl = (PatchLine)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            String string = line.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            collection.add(string);
        }
        patchChangeBuilder.addChangedLines((List)destination$iv$iv2, $beforeRange.start + $beforeBlockLines.element, false);
        $beforeBlockLines.element += deletedLines.size();
        int insertion = this$0.totalLines;
        Iterable $i$f$map32 = insertedLines;
        patchChangeBuilder = this$0;
        boolean $i$f$map = false;
        destination$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void line;
            PatchLine bl2 = (PatchLine)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            String string = line.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            collection.add(string);
        }
        patchChangeBuilder.addChangedLines((List)destination$iv$iv3, $afterRange.start + $afterBlockLines.element, true);
        $afterBlockLines.element += insertedLines.size();
        int hunkEnd = this$0.totalLines;
        LineRange deletionRange = new LineRange(deletion, insertion);
        LineRange insertionRange = new LineRange(insertion, hunkEnd);
        if (!deletionRange.isEmpty() || !insertionRange.isEmpty()) {
            $hunks.add(new Hunk(deletionRange, insertionRange));
        }
        return Unit.INSTANCE;
    }

    @JvmStatic
    @Nullable
    public static final List<DiffFragment> computeInnerDifferences(@NotNull Document patchContent, @NotNull Hunk hunk) {
        return Companion.computeInnerDifferences(patchContent, hunk);
    }

    @JvmStatic
    @Nullable
    public static final List<DiffFragment> computeInnerDifferences(@NotNull CharSequence patchContent, @NotNull LineOffsets lineOffsets, @NotNull Hunk hunk) {
        return Companion.computeInnerDifferences(patchContent, lineOffsets, hunk);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$AppliedHunk;", "Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$Hunk;", "patchDeletionRange", "Lcom/intellij/diff/util/LineRange;", "patchInsertionRange", "appliedToLines", "status", "Lcom/intellij/openapi/vcs/changes/patch/AppliedTextPatch$HunkStatus;", "<init>", "(Lcom/intellij/diff/util/LineRange;Lcom/intellij/diff/util/LineRange;Lcom/intellij/diff/util/LineRange;Lcom/intellij/openapi/vcs/changes/patch/AppliedTextPatch$HunkStatus;)V", "getAppliedToLines", "()Lcom/intellij/diff/util/LineRange;", "getStatus", "()Lcom/intellij/openapi/vcs/changes/patch/AppliedTextPatch$HunkStatus;", "intellij.platform.vcs.impl"})
    public static final class AppliedHunk
    extends Hunk {
        @Nullable
        private final LineRange appliedToLines;
        @NotNull
        private final AppliedTextPatch.HunkStatus status;

        public AppliedHunk(@NotNull LineRange patchDeletionRange, @NotNull LineRange patchInsertionRange, @Nullable LineRange appliedToLines, @NotNull AppliedTextPatch.HunkStatus status) {
            Intrinsics.checkNotNullParameter((Object)patchDeletionRange, (String)"patchDeletionRange");
            Intrinsics.checkNotNullParameter((Object)patchInsertionRange, (String)"patchInsertionRange");
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            super(patchDeletionRange, patchInsertionRange);
            this.appliedToLines = appliedToLines;
            this.status = status;
        }

        @Nullable
        public final LineRange getAppliedToLines() {
            return this.appliedToLines;
        }

        @NotNull
        public final AppliedTextPatch.HunkStatus getStatus() {
            return this.status;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$AppliedPatchState;", "", "patchContent", "", "hunks", "", "Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$AppliedHunk;", "lineConvertor1", "Lcom/intellij/diff/tools/fragmented/LineNumberConvertor;", "lineConvertor2", "separatorLines", "Lit/unimi/dsi/fastutil/ints/IntList;", "<init>", "(Ljava/lang/CharSequence;Ljava/util/List;Lcom/intellij/diff/tools/fragmented/LineNumberConvertor;Lcom/intellij/diff/tools/fragmented/LineNumberConvertor;Lit/unimi/dsi/fastutil/ints/IntList;)V", "getPatchContent", "()Ljava/lang/CharSequence;", "getHunks", "()Ljava/util/List;", "getLineConvertor1", "()Lcom/intellij/diff/tools/fragmented/LineNumberConvertor;", "getLineConvertor2", "getSeparatorLines", "()Lit/unimi/dsi/fastutil/ints/IntList;", "intellij.platform.vcs.impl"})
    public static final class AppliedPatchState {
        @NotNull
        private final CharSequence patchContent;
        @NotNull
        private final List<AppliedHunk> hunks;
        @NotNull
        private final LineNumberConvertor lineConvertor1;
        @NotNull
        private final LineNumberConvertor lineConvertor2;
        @NotNull
        private final IntList separatorLines;

        public AppliedPatchState(@NotNull CharSequence patchContent, @NotNull List<AppliedHunk> hunks, @NotNull LineNumberConvertor lineConvertor1, @NotNull LineNumberConvertor lineConvertor2, @NotNull IntList separatorLines) {
            Intrinsics.checkNotNullParameter((Object)patchContent, (String)"patchContent");
            Intrinsics.checkNotNullParameter(hunks, (String)"hunks");
            Intrinsics.checkNotNullParameter((Object)lineConvertor1, (String)"lineConvertor1");
            Intrinsics.checkNotNullParameter((Object)lineConvertor2, (String)"lineConvertor2");
            Intrinsics.checkNotNullParameter((Object)separatorLines, (String)"separatorLines");
            this.patchContent = patchContent;
            this.hunks = hunks;
            this.lineConvertor1 = lineConvertor1;
            this.lineConvertor2 = lineConvertor2;
            this.separatorLines = separatorLines;
        }

        @NotNull
        public final CharSequence getPatchContent() {
            return this.patchContent;
        }

        @NotNull
        public final List<AppliedHunk> getHunks() {
            return this.hunks;
        }

        @NotNull
        public final LineNumberConvertor getLineConvertor1() {
            return this.lineConvertor1;
        }

        @NotNull
        public final LineNumberConvertor getLineConvertor2() {
            return this.lineConvertor2;
        }

        @NotNull
        public final IntList getSeparatorLines() {
            return this.separatorLines;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J(\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$Companion;", "", "<init>", "()V", "computeInnerDifferences", "", "Lcom/intellij/diff/fragments/DiffFragment;", "patchContent", "Lcom/intellij/openapi/editor/Document;", "hunk", "Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$Hunk;", "", "lineOffsets", "Lcom/intellij/diff/tools/util/text/LineOffsets;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final List<DiffFragment> computeInnerDifferences(@NotNull Document patchContent, @NotNull Hunk hunk) {
            Intrinsics.checkNotNullParameter((Object)patchContent, (String)"patchContent");
            Intrinsics.checkNotNullParameter((Object)hunk, (String)"hunk");
            CharSequence charSequence = patchContent.getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
            LineOffsets lineOffsets = LineOffsetsUtil.create((Document)patchContent);
            Intrinsics.checkNotNullExpressionValue((Object)lineOffsets, (String)"create(...)");
            return this.computeInnerDifferences(charSequence, lineOffsets, hunk);
        }

        @JvmStatic
        @Nullable
        public final List<DiffFragment> computeInnerDifferences(@NotNull CharSequence patchContent, @NotNull LineOffsets lineOffsets, @NotNull Hunk hunk) {
            Intrinsics.checkNotNullParameter((Object)patchContent, (String)"patchContent");
            Intrinsics.checkNotNullParameter((Object)lineOffsets, (String)"lineOffsets");
            Intrinsics.checkNotNullParameter((Object)hunk, (String)"hunk");
            LineRange deletionRange = hunk.getPatchDeletionRange();
            LineRange insertionRange = hunk.getPatchInsertionRange();
            if (deletionRange.isEmpty() || insertionRange.isEmpty()) {
                return null;
            }
            try {
                CharSequence deleted = DiffRangeUtil.getLinesContent((CharSequence)patchContent, (LineOffsets)lineOffsets, (int)deletionRange.start, (int)deletionRange.end);
                CharSequence inserted = DiffRangeUtil.getLinesContent((CharSequence)patchContent, (LineOffsets)lineOffsets, (int)insertionRange.start, (int)insertionRange.end);
                return ByWord.compare((CharSequence)deleted, (CharSequence)inserted, (ComparisonPolicy)ComparisonPolicy.DEFAULT, (ProgressIndicator)((ProgressIndicator)DumbProgressIndicator.INSTANCE));
            }
            catch (DiffTooBigException e) {
                return null;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$Hunk;", "", "patchDeletionRange", "Lcom/intellij/diff/util/LineRange;", "patchInsertionRange", "<init>", "(Lcom/intellij/diff/util/LineRange;Lcom/intellij/diff/util/LineRange;)V", "getPatchDeletionRange", "()Lcom/intellij/diff/util/LineRange;", "getPatchInsertionRange", "intellij.platform.vcs.impl"})
    public static class Hunk {
        @NotNull
        private final LineRange patchDeletionRange;
        @NotNull
        private final LineRange patchInsertionRange;

        public Hunk(@NotNull LineRange patchDeletionRange, @NotNull LineRange patchInsertionRange) {
            Intrinsics.checkNotNullParameter((Object)patchDeletionRange, (String)"patchDeletionRange");
            Intrinsics.checkNotNullParameter((Object)patchInsertionRange, (String)"patchInsertionRange");
            this.patchDeletionRange = patchDeletionRange;
            this.patchInsertionRange = patchInsertionRange;
        }

        @NotNull
        public final LineRange getPatchDeletionRange() {
            return this.patchDeletionRange;
        }

        @NotNull
        public final LineRange getPatchInsertionRange() {
            return this.patchInsertionRange;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$PatchSideChange;", "Lcom/intellij/diff/tools/simple/AlignableChange;", "range", "Lcom/intellij/diff/util/Range;", "<init>", "(Lcom/intellij/diff/util/Range;)V", "getRange", "()Lcom/intellij/diff/util/Range;", "diffType", "Lcom/intellij/diff/util/TextDiffType;", "getDiffType", "()Lcom/intellij/diff/util/TextDiffType;", "getStartLine", "", "side", "Lcom/intellij/diff/util/Side;", "getEndLine", "intellij.platform.vcs.impl"})
    public static final class PatchSideChange
    implements AlignableChange {
        @NotNull
        private final Range range;

        public PatchSideChange(@NotNull Range range) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            this.range = range;
        }

        @NotNull
        public final Range getRange() {
            return this.range;
        }

        @NotNull
        public TextDiffType getDiffType() {
            TextDiffType textDiffType = DiffUtil.getDiffType((Range)this.range);
            Intrinsics.checkNotNullExpressionValue((Object)textDiffType, (String)"getDiffType(...)");
            return textDiffType;
        }

        public int getStartLine(@NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            return side.select(this.range.start1, this.range.start2);
        }

        public int getEndLine(@NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            return side.select(this.range.end1, this.range.end2);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$PatchState;", "", "patchContent", "", "hunks", "", "Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$Hunk;", "lineConvertor1", "Lcom/intellij/diff/tools/fragmented/LineNumberConvertor;", "lineConvertor2", "separatorLines", "Lit/unimi/dsi/fastutil/ints/IntList;", "<init>", "(Ljava/lang/CharSequence;Ljava/util/List;Lcom/intellij/diff/tools/fragmented/LineNumberConvertor;Lcom/intellij/diff/tools/fragmented/LineNumberConvertor;Lit/unimi/dsi/fastutil/ints/IntList;)V", "getPatchContent", "()Ljava/lang/CharSequence;", "getHunks", "()Ljava/util/List;", "getLineConvertor1", "()Lcom/intellij/diff/tools/fragmented/LineNumberConvertor;", "getLineConvertor2", "getSeparatorLines", "()Lit/unimi/dsi/fastutil/ints/IntList;", "intellij.platform.vcs.impl"})
    public static final class PatchState {
        @NotNull
        private final CharSequence patchContent;
        @NotNull
        private final List<Hunk> hunks;
        @NotNull
        private final LineNumberConvertor lineConvertor1;
        @NotNull
        private final LineNumberConvertor lineConvertor2;
        @NotNull
        private final IntList separatorLines;

        public PatchState(@NotNull CharSequence patchContent, @NotNull List<? extends Hunk> hunks, @NotNull LineNumberConvertor lineConvertor1, @NotNull LineNumberConvertor lineConvertor2, @NotNull IntList separatorLines) {
            Intrinsics.checkNotNullParameter((Object)patchContent, (String)"patchContent");
            Intrinsics.checkNotNullParameter(hunks, (String)"hunks");
            Intrinsics.checkNotNullParameter((Object)lineConvertor1, (String)"lineConvertor1");
            Intrinsics.checkNotNullParameter((Object)lineConvertor2, (String)"lineConvertor2");
            Intrinsics.checkNotNullParameter((Object)separatorLines, (String)"separatorLines");
            this.patchContent = patchContent;
            this.hunks = hunks;
            this.lineConvertor1 = lineConvertor1;
            this.lineConvertor2 = lineConvertor2;
            this.separatorLines = separatorLines;
        }

        @NotNull
        public final CharSequence getPatchContent() {
            return this.patchContent;
        }

        @NotNull
        public final List<Hunk> getHunks() {
            return this.hunks;
        }

        @NotNull
        public final LineNumberConvertor getLineConvertor1() {
            return this.lineConvertor1;
        }

        @NotNull
        public final LineNumberConvertor getLineConvertor2() {
            return this.lineConvertor2;
        }

        @NotNull
        public final IntList getSeparatorLines() {
            return this.separatorLines;
        }
    }
}

