/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.indexer;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.server.MavenEmbedderSettings;
import org.jetbrains.idea.maven.server.MavenPullDownloadListener;
import org.jetbrains.idea.maven.server.MavenPullServerLogger;
import org.jetbrains.idea.maven.server.MavenServer;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenServerStatus;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.server.MavenWatchdogAware;
import org.jetbrains.idea.maven.server.indexer.MavenIdeaAsyncIndexerImpl;
import org.jetbrains.idea.maven.server.indexer.MavenIdeaIndexerImpl;
import org.jetbrains.idea.maven.server.security.MavenToken;

public class MavenServerForIndexer
extends MavenWatchdogAware
implements MavenServer {
    private volatile MavenIdeaIndexerImpl myIndexerRef;
    private volatile PlexusContainer myPlexusContainer;

    public MavenServerForIndexer() {
        String logLevel = System.getProperty("maven.indexer.log.level", "error");
        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", logLevel);
        Level utilLevel = MavenServerForIndexer.getLogLevel(logLevel);
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        Handler[] handlers = rootLogger.getHandlers();
        rootLogger.setLevel(utilLevel);
        for (Handler h : handlers) {
            h.setLevel(utilLevel);
        }
    }

    private static Level getLogLevel(String level) {
        switch (level) {
            case "error": {
                return Level.SEVERE;
            }
            case "debug": {
                return Level.ALL;
            }
        }
        return Level.INFO;
    }

    public MavenServerEmbedder createEmbedder(MavenEmbedderSettings settings, MavenToken token) throws RemoteException {
        throw new UnsupportedOperationException("indexing server");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenServerIndexer createIndexer(MavenToken token) throws RemoteException {
        MavenServerUtil.checkToken((MavenToken)token);
        if (this.myIndexerRef != null) {
            return this.myIndexerRef;
        }
        MavenServerForIndexer mavenServerForIndexer = this;
        synchronized (mavenServerForIndexer) {
            if (this.myIndexerRef != null) {
                return this.myIndexerRef;
            }
            MavenIdeaAsyncIndexerImpl result = null;
            try {
                result = new MavenIdeaAsyncIndexerImpl(this.getPlexusContainer());
                UnicastRemoteObject.exportObject((Remote)((Object)result), 0);
                this.myIndexerRef = result;
            }
            catch (Exception e) {
                try {
                    if (result != null) {
                        UnicastRemoteObject.unexportObject((Remote)((Object)result), true);
                    }
                }
                catch (Exception unexportException) {
                    RuntimeException re = this.wrapToSerializableRuntimeException(e);
                    throw re;
                }
                throw this.wrapToSerializableRuntimeException(e);
            }
        }
        return this.myIndexerRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlexusContainer getPlexusContainer() throws PlexusContainerException {
        if (this.myPlexusContainer != null) {
            return this.myPlexusContainer;
        }
        MavenServerForIndexer mavenServerForIndexer = this;
        synchronized (mavenServerForIndexer) {
            if (this.myPlexusContainer != null) {
                return this.myPlexusContainer;
            }
            DefaultContainerConfiguration config = new DefaultContainerConfiguration();
            config.setClassPathScanning("index");
            this.myPlexusContainer = new DefaultPlexusContainer((ContainerConfiguration)config);
        }
        return this.myPlexusContainer;
    }

    @Nullable
    public MavenPullServerLogger createPullLogger(MavenToken token) throws RemoteException {
        throw new UnsupportedOperationException("indexing server");
    }

    @Nullable
    public MavenPullDownloadListener createPullDownloadListener(MavenToken token) throws RemoteException {
        throw new UnsupportedOperationException("indexing server");
    }

    public MavenServerStatus getDebugStatus(boolean clean) {
        MavenServerStatus result = new MavenServerStatus();
        result.statusCollected = false;
        return result;
    }
}

