/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrNamer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.util.IrExceptionBuilder;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH&J\u0016\u0010\u000e\u001a\u00020\u0005*\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0004J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamerBase;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamer;", "<init>", "()V", "getNameForMemberFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getNameForMemberField", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getNameForStaticDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "toJsName", "", "temporary", "", "getNameForStaticFunction", "getNameForField", "getNameForConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getNameForClass", "klass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getRefForExternalClass", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "getNameForProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nIrNamer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrNamer.kt\norg/jetbrains/kotlin/ir/backend/js/utils/IrNamerBase\n+ 2 IrExceptionUtils.kt\norg/jetbrains/kotlin/ir/util/IrExceptionUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n28#2:81\n29#2:83\n1#3:82\n*S KotlinDebug\n*F\n+ 1 IrNamer.kt\norg/jetbrains/kotlin/ir/backend/js/utils/IrNamerBase\n*L\n65#1:81\n65#1:83\n65#1:82\n*E\n"})
public abstract class IrNamerBase
implements IrNamer {
    @Override
    @NotNull
    public abstract JsName getNameForMemberFunction(@NotNull IrSimpleFunction var1);

    @Override
    @NotNull
    public abstract JsName getNameForMemberField(@NotNull IrField var1);

    @Override
    @NotNull
    public abstract JsName getNameForStaticDeclaration(@NotNull IrDeclarationWithName var1);

    @NotNull
    protected final JsName toJsName(@NotNull String $this$toJsName, boolean temporary) {
        Intrinsics.checkNotNullParameter($this$toJsName, "<this>");
        return new JsName($this$toJsName, temporary);
    }

    public static /* synthetic */ JsName toJsName$default(IrNamerBase irNamerBase, String string, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toJsName");
        }
        if ((n2 & 1) != 0) {
            bl = true;
        }
        return irNamerBase.toJsName(string, bl);
    }

    @Override
    @NotNull
    public JsName getNameForStaticFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        return this.getNameForStaticDeclaration(function2);
    }

    @Override
    @NotNull
    public JsName getNameForField(@NotNull IrField field) {
        Intrinsics.checkNotNullParameter(field, "field");
        return field.isStatic() || field.getParent() instanceof IrScript ? this.getNameForStaticDeclaration(field) : this.getNameForMemberField(field);
    }

    @Override
    @NotNull
    public JsName getNameForConstructor(@NotNull IrConstructor constructor) {
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        return this.getNameForStaticDeclaration(IrUtilsKt.getParentAsClass(constructor));
    }

    @Override
    @NotNull
    public JsName getNameForClass(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        return this.getNameForStaticDeclaration(klass);
    }

    @Override
    @NotNull
    public JsNameRef getRefForExternalClass(@NotNull IrClass klass) {
        JsNameRef jsNameRef;
        Intrinsics.checkNotNullParameter(klass, "klass");
        IrDeclarationParent parent2 = klass.getParent();
        if (klass.isCompanion()) {
            Intrinsics.checkNotNull(parent2, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            return this.getRefForExternalClass((IrClass)parent2);
        }
        String string = AnnotationUtilsKt.getJsNameOrKotlinName(klass).getIdentifier();
        Intrinsics.checkNotNullExpressionValue(string, "getIdentifier(...)");
        String currentClassName = string;
        IrDeclarationParent irDeclarationParent = parent2;
        if (irDeclarationParent instanceof IrClass) {
            jsNameRef = new JsNameRef(currentClassName, (JsExpression)this.getRefForExternalClass((IrClass)parent2));
        } else if (irDeclarationParent instanceof IrPackageFragment) {
            JsNameRef jsNameRef2 = this.getNameForStaticDeclaration(klass).makeRef();
            Intrinsics.checkNotNull(jsNameRef2);
            jsNameRef = jsNameRef2;
        } else {
            IrExceptionBuilder irExceptionBuilder;
            String message$iv = "Unsupported external class parent";
            boolean $i$f$irError = false;
            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
            boolean bl = false;
            IrExceptionBuilder $this$getRefForExternalClass_u24lambda_u240 = $this$irError_u24lambda_u240$iv;
            boolean bl2 = false;
            $this$getRefForExternalClass_u24lambda_u240.withIrEntry("parent", parent2);
            $this$getRefForExternalClass_u24lambda_u240.withIrEntry("klass", klass);
            IrExceptionBuilder builder$iv = irExceptionBuilder;
            throw new IllegalStateException(builder$iv.buildString().toString());
        }
        return jsNameRef;
    }

    @Override
    @NotNull
    public JsName getNameForProperty(@NotNull IrProperty property2) {
        JsName jsName;
        Intrinsics.checkNotNullParameter(property2, "property");
        if (property2.getParent() instanceof IrClass) {
            String string = AnnotationUtilsKt.getJsNameOrKotlinName(property2).asString();
            Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
            jsName = IrNamerBase.toJsName$default(this, string, false, 1, null);
        } else {
            jsName = this.getNameForStaticDeclaration(property2);
        }
        return jsName;
    }
}

