/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.description;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.description.CallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ConditionalEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ContractDescriptionElement;
import org.jetbrains.kotlin.contracts.description.ContractDescriptionVisitor;
import org.jetbrains.kotlin.contracts.description.ReturnsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.expressions.ConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.IsInstancePredicate;
import org.jetbrains.kotlin.contracts.description.expressions.IsNullPredicate;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalAnd;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalNot;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalOr;
import org.jetbrains.kotlin.contracts.description.expressions.VariableReference;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\fJ\u001d\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0010J\u001d\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0018J\u001d\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u001d\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010 J\u001d\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010$J\u001d\u0010%\u001a\u00020\u00022\u0006\u0010&\u001a\u00020'2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010(J\u001d\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010,J\u001d\u0010-\u001a\u00020\u00022\u0006\u0010.\u001a\u00020/2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u00100J\f\u00101\u001a\u000202*\u000203H\u0002J\u0018\u00104\u001a\u0002022\u0006\u00105\u001a\u0002032\u0006\u00106\u001a\u000203H\u0002J&\u00107\u001a\u00020\u00022\u0006\u00105\u001a\u0002032\u0006\u00106\u001a\u0002032\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u000209H\u0002R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/contracts/description/ContractDescriptionRenderer;", "Lorg/jetbrains/kotlin/contracts/description/ContractDescriptionVisitor;", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "<init>", "(Ljava/lang/StringBuilder;)V", "visitConditionalEffectDeclaration", "conditionalEffect", "Lorg/jetbrains/kotlin/contracts/description/ConditionalEffectDeclaration;", "data", "(Lorg/jetbrains/kotlin/contracts/description/ConditionalEffectDeclaration;Lkotlin/Unit;)V", "visitReturnsEffectDeclaration", "returnsEffect", "Lorg/jetbrains/kotlin/contracts/description/ReturnsEffectDeclaration;", "(Lorg/jetbrains/kotlin/contracts/description/ReturnsEffectDeclaration;Lkotlin/Unit;)V", "visitCallsEffectDeclaration", "callsEffect", "Lorg/jetbrains/kotlin/contracts/description/CallsEffectDeclaration;", "(Lorg/jetbrains/kotlin/contracts/description/CallsEffectDeclaration;Lkotlin/Unit;)V", "visitLogicalOr", "logicalOr", "Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalOr;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalOr;Lkotlin/Unit;)V", "visitLogicalAnd", "logicalAnd", "Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalAnd;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalAnd;Lkotlin/Unit;)V", "visitLogicalNot", "logicalNot", "Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalNot;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalNot;Lkotlin/Unit;)V", "visitIsInstancePredicate", "isInstancePredicate", "Lorg/jetbrains/kotlin/contracts/description/expressions/IsInstancePredicate;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/IsInstancePredicate;Lkotlin/Unit;)V", "visitIsNullPredicate", "isNullPredicate", "Lorg/jetbrains/kotlin/contracts/description/expressions/IsNullPredicate;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/IsNullPredicate;Lkotlin/Unit;)V", "visitConstantDescriptor", "constantReference", "Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;Lkotlin/Unit;)V", "visitVariableReference", "variableReference", "Lorg/jetbrains/kotlin/contracts/description/expressions/VariableReference;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/VariableReference;Lkotlin/Unit;)V", "isAtom", "", "Lorg/jetbrains/kotlin/contracts/description/ContractDescriptionElement;", "needsBrackets", "parent", "child", "inBracketsIfNecessary", "block", "Lkotlin/Function0;", "resolution"})
public final class ContractDescriptionRenderer
implements ContractDescriptionVisitor<Unit, Unit> {
    @NotNull
    private final StringBuilder builder;

    public ContractDescriptionRenderer(@NotNull StringBuilder builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        this.builder = builder;
    }

    @Override
    public void visitConditionalEffectDeclaration(@NotNull ConditionalEffectDeclaration conditionalEffect, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter(conditionalEffect, "conditionalEffect");
        Intrinsics.checkNotNullParameter(data, "data");
        conditionalEffect.getEffect().accept(this, data);
        this.builder.append(" -> ");
        conditionalEffect.getCondition().accept(this, data);
    }

    @Override
    public void visitReturnsEffectDeclaration(@NotNull ReturnsEffectDeclaration returnsEffect, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter(returnsEffect, "returnsEffect");
        Intrinsics.checkNotNullParameter(data, "data");
        this.builder.append("Returns(");
        returnsEffect.getValue().accept(this, data);
        this.builder.append(")");
    }

    @Override
    public void visitCallsEffectDeclaration(@NotNull CallsEffectDeclaration callsEffect, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter(callsEffect, "callsEffect");
        Intrinsics.checkNotNullParameter(data, "data");
        this.builder.append("CallsInPlace(");
        callsEffect.getVariableReference().accept(this, data);
        this.builder.append(", " + (Object)((Object)callsEffect.getKind()) + ')');
    }

    @Override
    public void visitLogicalOr(@NotNull LogicalOr logicalOr, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter(logicalOr, "logicalOr");
        Intrinsics.checkNotNullParameter(data, "data");
        this.inBracketsIfNecessary(logicalOr, logicalOr.getLeft(), () -> ContractDescriptionRenderer.visitLogicalOr$lambda$0(logicalOr, this, data));
        this.builder.append(" || ");
        this.inBracketsIfNecessary(logicalOr, logicalOr.getRight(), () -> ContractDescriptionRenderer.visitLogicalOr$lambda$1(logicalOr, this, data));
    }

    @Override
    public void visitLogicalAnd(@NotNull LogicalAnd logicalAnd, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter(logicalAnd, "logicalAnd");
        Intrinsics.checkNotNullParameter(data, "data");
        this.inBracketsIfNecessary(logicalAnd, logicalAnd.getLeft(), () -> ContractDescriptionRenderer.visitLogicalAnd$lambda$2(logicalAnd, this, data));
        this.builder.append(" && ");
        this.inBracketsIfNecessary(logicalAnd, logicalAnd.getRight(), () -> ContractDescriptionRenderer.visitLogicalAnd$lambda$3(logicalAnd, this, data));
    }

    @Override
    public void visitLogicalNot(@NotNull LogicalNot logicalNot, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter(logicalNot, "logicalNot");
        Intrinsics.checkNotNullParameter(data, "data");
        this.inBracketsIfNecessary(logicalNot, logicalNot.getArg(), () -> ContractDescriptionRenderer.visitLogicalNot$lambda$4(this));
        logicalNot.getArg().accept(this, data);
    }

    @Override
    public void visitIsInstancePredicate(@NotNull IsInstancePredicate isInstancePredicate, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter(isInstancePredicate, "isInstancePredicate");
        Intrinsics.checkNotNullParameter(data, "data");
        isInstancePredicate.getArg().accept(this, data);
        this.builder.append(' ' + (isInstancePredicate.isNegated() ? "!" : "") + "is " + isInstancePredicate.getType());
    }

    @Override
    public void visitIsNullPredicate(@NotNull IsNullPredicate isNullPredicate, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter(isNullPredicate, "isNullPredicate");
        Intrinsics.checkNotNullParameter(data, "data");
        isNullPredicate.getArg().accept(this, data);
        this.builder.append(' ' + (isNullPredicate.isNegated() ? "!=" : "==") + " null");
    }

    @Override
    public void visitConstantDescriptor(@NotNull ConstantReference constantReference, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter(constantReference, "constantReference");
        Intrinsics.checkNotNullParameter(data, "data");
        this.builder.append(constantReference.getName());
    }

    @Override
    public void visitVariableReference(@NotNull VariableReference variableReference, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter(variableReference, "variableReference");
        Intrinsics.checkNotNullParameter(data, "data");
        this.builder.append(variableReference.getDescriptor().getName());
    }

    private final boolean isAtom(ContractDescriptionElement $this$isAtom) {
        return $this$isAtom instanceof VariableReference || $this$isAtom instanceof ConstantReference || $this$isAtom instanceof IsNullPredicate || $this$isAtom instanceof IsInstancePredicate;
    }

    private final boolean needsBrackets(ContractDescriptionElement parent2, ContractDescriptionElement child) {
        if (this.isAtom(child)) {
            return false;
        }
        if (parent2 instanceof LogicalNot) {
            return true;
        }
        return parent2.getClass() != child.getClass();
    }

    private final void inBracketsIfNecessary(ContractDescriptionElement parent2, ContractDescriptionElement child, Function0<Unit> block) {
        if (this.needsBrackets(parent2, child)) {
            this.builder.append("(");
            block.invoke();
            this.builder.append(")");
        } else {
            block.invoke();
        }
    }

    private static final Unit visitLogicalOr$lambda$0(LogicalOr $logicalOr, ContractDescriptionRenderer this$0, Unit $data) {
        $logicalOr.getLeft().accept(this$0, $data);
        return Unit.INSTANCE;
    }

    private static final Unit visitLogicalOr$lambda$1(LogicalOr $logicalOr, ContractDescriptionRenderer this$0, Unit $data) {
        $logicalOr.getRight().accept(this$0, $data);
        return Unit.INSTANCE;
    }

    private static final Unit visitLogicalAnd$lambda$2(LogicalAnd $logicalAnd, ContractDescriptionRenderer this$0, Unit $data) {
        $logicalAnd.getLeft().accept(this$0, $data);
        return Unit.INSTANCE;
    }

    private static final Unit visitLogicalAnd$lambda$3(LogicalAnd $logicalAnd, ContractDescriptionRenderer this$0, Unit $data) {
        $logicalAnd.getRight().accept(this$0, $data);
        return Unit.INSTANCE;
    }

    private static final Unit visitLogicalNot$lambda$4(ContractDescriptionRenderer this$0) {
        this$0.builder.append("!");
        return Unit.INSTANCE;
    }
}

