/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.annotate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.AnnotationSource;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.AnnotationTooltipBuilder;
import com.intellij.openapi.vcs.annotate.DefaultLineModificationDetailsProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspectAdapter;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.xml.util.XmlStringUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.jetbrains.idea.svn.history.SvnFileRevision;

public abstract class BaseSvnFileAnnotation
extends FileAnnotation {
    private final String myContents;
    protected final VcsRevisionNumber myBaseRevision;
    private final MyPartiallyCreatedInfos myInfos;
    protected final SvnVcs myVcs;
    private final Long2ObjectMap<SvnFileRevision> myRevisionMap;
    private final LineAnnotationAspect DATE_ASPECT;
    private final LineAnnotationAspect REVISION_ASPECT;
    private final LineAnnotationAspect ORIGINAL_REVISION_ASPECT;
    private final LineAnnotationAspect AUTHOR_ASPECT;
    private final SvnConfiguration myConfiguration;
    private final boolean myShowMergeSources;
    private SvnRevisionNumber myFirstRevisionNumber;

    public void setRevision(long revision, SvnFileRevision svnRevision) {
        this.myRevisionMap.put(revision, (Object)svnRevision);
    }

    public SvnFileRevision getRevision(long revision) {
        return (SvnFileRevision)this.myRevisionMap.get(revision);
    }

    public void setFirstRevision(Revision revision) {
        this.myFirstRevisionNumber = new SvnRevisionNumber(revision);
    }

    public SvnRevisionNumber getFirstRevisionNumber() {
        return this.myFirstRevisionNumber;
    }

    public BaseSvnFileAnnotation(@NotNull SvnVcs vcs, String contents, VcsRevisionNumber baseRevision) {
        if (vcs == null) {
            BaseSvnFileAnnotation.$$$reportNull$$$0(0);
        }
        super(vcs.getProject());
        this.myRevisionMap = new Long2ObjectOpenHashMap();
        this.DATE_ASPECT = new SvnAnnotationAspect("Date", VcsBundle.message((String)"line.annotation.aspect.date", (Object[])new Object[0]), true){

            @Override
            public String getValue(@NotNull CommitInfo info) {
                if (info == null) {
                    1.$$$reportNull$$$0(0);
                }
                return FileAnnotation.formatDate((Date)info.getDate());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation$1", "getValue"));
            }
        };
        this.REVISION_ASPECT = new SvnAnnotationAspect("Revision", VcsBundle.message((String)"line.annotation.aspect.revision", (Object[])new Object[0]), false){

            @Override
            public String getValue(@NotNull CommitInfo info) {
                if (info == null) {
                    2.$$$reportNull$$$0(0);
                }
                return String.valueOf(info.getRevisionNumber());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation$2", "getValue"));
            }
        };
        this.ORIGINAL_REVISION_ASPECT = new SvnAnnotationAspect("Original revision", SvnBundle.message("annotation.original.revision", new Object[0]), false){

            @Override
            public String getValue(int lineNumber) {
                long value = BaseSvnFileAnnotation.this.myInfos.originalRevision(lineNumber);
                return value == -1L ? "" : String.valueOf(value);
            }

            @Override
            protected long getRevision(int lineNum) {
                return BaseSvnFileAnnotation.this.myInfos.originalRevision(lineNum);
            }

            public String getTooltipText(int lineNumber) {
                if (!BaseSvnFileAnnotation.this.myInfos.isValid(lineNumber)) {
                    return "";
                }
                CommitInfo info = BaseSvnFileAnnotation.this.myInfos.get(lineNumber);
                if (info == null) {
                    return null;
                }
                SvnFileRevision revision = (SvnFileRevision)BaseSvnFileAnnotation.this.myRevisionMap.get(info.getRevisionNumber());
                if (revision == null) {
                    return "";
                }
                return XmlStringUtil.escapeString((String)SvnBundle.message("tooltip.revision.number.message", info.getRevisionNumber(), revision.getCommitMessage()));
            }
        };
        this.AUTHOR_ASPECT = new SvnAnnotationAspect("Author", VcsBundle.message((String)"line.annotation.aspect.author", (Object[])new Object[0]), true){

            @Override
            public String getValue(@NotNull CommitInfo info) {
                if (info == null) {
                    4.$$$reportNull$$$0(0);
                }
                return info.getAuthor();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation$4", "getValue"));
            }
        };
        this.myVcs = vcs;
        this.myContents = contents;
        this.myBaseRevision = baseRevision;
        this.myConfiguration = vcs.getSvnConfiguration();
        this.myShowMergeSources = this.myConfiguration.isShowMergeSourcesInAnnotate();
        this.myInfos = new MyPartiallyCreatedInfos();
    }

    public LineAnnotationAspect @NotNull [] getAspects() {
        LineAnnotationAspect[] lineAnnotationAspectArray = new LineAnnotationAspect[]{this.REVISION_ASPECT, this.DATE_ASPECT, this.AUTHOR_ASPECT};
        if (lineAnnotationAspectArray == null) {
            BaseSvnFileAnnotation.$$$reportNull$$$0(1);
        }
        return lineAnnotationAspectArray;
    }

    @Nullable
    public String getToolTip(int lineNumber) {
        return this.getToolTip(lineNumber, false);
    }

    @Nullable
    public String getHtmlToolTip(int lineNumber) {
        return this.getToolTip(lineNumber, true);
    }

    @NlsContexts.Tooltip
    @Nullable
    private String getToolTip(int lineNumber, boolean asHtml) {
        CommitInfo info = this.myInfos.getOrNull(lineNumber);
        if (info == null) {
            return null;
        }
        SvnFileRevision revision = (SvnFileRevision)this.myRevisionMap.get(info.getRevisionNumber());
        if (revision == null) {
            return null;
        }
        String prefix = this.myInfos.getAnnotationSource(lineNumber).showMerged() ? SvnBundle.message("label.merge.source.revision", new Object[0]) : SvnBundle.message("label.revision", new Object[0]);
        return AnnotationTooltipBuilder.buildSimpleTooltip((Project)this.getProject(), (boolean)asHtml, (String)prefix, (String)String.valueOf(info.getRevisionNumber()), (String)revision.getCommitMessage());
    }

    public String getAnnotatedContent() {
        return this.myContents;
    }

    public void setLineInfo(int lineNumber, @NotNull CommitInfo info, @Nullable CommitInfo mergeInfo) {
        if (info == null) {
            BaseSvnFileAnnotation.$$$reportNull$$$0(2);
        }
        this.myInfos.appendNumberedLineInfo(lineNumber, info, mergeInfo);
    }

    @Nullable
    public VcsRevisionNumber originalRevision(int lineNumber) {
        SvnFileRevision revision = this.myInfos.isValid(lineNumber) ? (SvnFileRevision)this.myRevisionMap.get(this.myInfos.originalRevision(lineNumber)) : null;
        return revision != null ? revision.getRevisionNumber() : null;
    }

    public VcsRevisionNumber getLineRevisionNumber(int lineNumber) {
        CommitInfo info = this.myInfos.getOrNull(lineNumber);
        return info != null && info.getRevisionNumber() >= 0L ? new SvnRevisionNumber(Revision.of(info.getRevisionNumber())) : null;
    }

    public Date getLineDate(int lineNumber) {
        CommitInfo info = this.myInfos.getOrNull(lineNumber);
        return info != null ? info.getDate() : null;
    }

    public List<VcsFileRevision> getRevisions() {
        ArrayList<VcsFileRevision> result = new ArrayList<VcsFileRevision>((Collection<VcsFileRevision>)this.myRevisionMap.values());
        result.sort((o1, o2) -> o2.getRevisionNumber().compareTo((Object)o1.getRevisionNumber()));
        return result;
    }

    @Nullable
    public AnnotationSourceSwitcher getAnnotationSourceSwitcher() {
        if (!this.myShowMergeSources) {
            return null;
        }
        return new AnnotationSourceSwitcher(){

            @NotNull
            public AnnotationSource getAnnotationSource(int lineNumber) {
                AnnotationSource annotationSource = BaseSvnFileAnnotation.this.myInfos.getAnnotationSource(lineNumber);
                if (annotationSource == null) {
                    5.$$$reportNull$$$0(0);
                }
                return annotationSource;
            }

            public boolean mergeSourceAvailable(int lineNumber) {
                return BaseSvnFileAnnotation.this.myInfos.mergeSourceAvailable(lineNumber);
            }

            @NotNull
            public LineAnnotationAspect getRevisionAspect() {
                LineAnnotationAspect lineAnnotationAspect = BaseSvnFileAnnotation.this.ORIGINAL_REVISION_ASPECT;
                if (lineAnnotationAspect == null) {
                    5.$$$reportNull$$$0(1);
                }
                return lineAnnotationAspect;
            }

            @NotNull
            public AnnotationSource getDefaultSource() {
                AnnotationSource annotationSource = AnnotationSource.getInstance((boolean)BaseSvnFileAnnotation.this.myShowMergeSources);
                if (annotationSource == null) {
                    5.$$$reportNull$$$0(2);
                }
                return annotationSource;
            }

            public void switchTo(AnnotationSource source) {
                BaseSvnFileAnnotation.this.myInfos.setShowMergeSource(source.showMerged());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAnnotationSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRevisionAspect";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDefaultSource";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    public int getLineCount() {
        return this.myInfos.size();
    }

    public VcsKey getVcsKey() {
        return SvnVcs.getKey();
    }

    protected abstract void showAllAffectedPaths(SvnRevisionNumber var1);

    @Nullable
    public VcsRevisionNumber getCurrentRevision() {
        return this.myBaseRevision;
    }

    @Nullable
    public FileAnnotation.LineModificationDetailsProvider getLineModificationDetailsProvider() {
        return DefaultLineModificationDetailsProvider.create((FileAnnotation)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAspects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setLineInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class MyPartiallyCreatedInfos {
        private boolean myShowMergeSource;
        private final Int2ObjectMap<CommitInfo> myMappedLineInfo;
        private final Int2ObjectMap<CommitInfo> myMergeSourceInfos = new Int2ObjectOpenHashMap();
        private int myMaxIdx = 0;

        private MyPartiallyCreatedInfos() {
            this.myMappedLineInfo = new Int2ObjectOpenHashMap();
        }

        void setShowMergeSource(boolean showMergeSource) {
            this.myShowMergeSource = showMergeSource;
        }

        int size() {
            return this.myMaxIdx + 1;
        }

        void appendNumberedLineInfo(int lineNumber, @NotNull CommitInfo info, @Nullable CommitInfo mergeInfo) {
            if (info == null) {
                MyPartiallyCreatedInfos.$$$reportNull$$$0(0);
            }
            if (this.myMappedLineInfo.get(lineNumber) != null) {
                return;
            }
            this.myMaxIdx = Math.max(this.myMaxIdx, lineNumber);
            this.myMappedLineInfo.put(lineNumber, (Object)info);
            if (mergeInfo != null) {
                this.myMergeSourceInfos.put(lineNumber, (Object)mergeInfo);
            }
        }

        CommitInfo get(int idx) {
            CommitInfo lineInfo;
            if (this.myShowMergeSource && (lineInfo = (CommitInfo)this.myMergeSourceInfos.get(idx)) != null) {
                return lineInfo;
            }
            return (CommitInfo)this.myMappedLineInfo.get(idx);
        }

        @Nullable
        CommitInfo getOrNull(int lineNumber) {
            return this.isValid(lineNumber) ? this.get(lineNumber) : null;
        }

        private boolean isValid(int lineNumber) {
            return lineNumber >= 0 && lineNumber < this.size();
        }

        AnnotationSource getAnnotationSource(int line) {
            return this.myShowMergeSource ? AnnotationSource.getInstance((boolean)this.myMergeSourceInfos.containsKey(line)) : AnnotationSource.LOCAL;
        }

        public long originalRevision(int line) {
            CommitInfo info = line < this.size() ? (CommitInfo)this.myMappedLineInfo.get(line) : null;
            return info == null ? -1L : info.getRevisionNumber();
        }

        public boolean mergeSourceAvailable(int lineNumber) {
            return this.myMergeSourceInfos.containsKey(lineNumber);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation$MyPartiallyCreatedInfos", "appendNumberedLineInfo"));
        }
    }

    private abstract class SvnAnnotationAspect
    extends LineAnnotationAspectAdapter {
        SvnAnnotationAspect(@NlsContexts.ListItem String id, String displayName, boolean showByDefault) {
            super(id, displayName, showByDefault);
        }

        protected long getRevision(int lineNum) {
            CommitInfo lineInfo = BaseSvnFileAnnotation.this.myInfos.get(lineNum);
            return lineInfo == null ? -1L : lineInfo.getRevisionNumber();
        }

        protected void showAffectedPaths(int lineNum) {
            long revision;
            if (BaseSvnFileAnnotation.this.myInfos.isValid(lineNum) && (revision = this.getRevision(lineNum)) >= 0L) {
                BaseSvnFileAnnotation.this.showAllAffectedPaths(new SvnRevisionNumber(Revision.of(revision)));
            }
        }

        public String getValue(int lineNumber) {
            CommitInfo info = BaseSvnFileAnnotation.this.myInfos.getOrNull(lineNumber);
            return info == null ? "" : this.getValue(info);
        }

        public String getValue(@NotNull CommitInfo info) {
            if (info == null) {
                SvnAnnotationAspect.$$$reportNull$$$0(0);
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation$SvnAnnotationAspect", "getValue"));
        }
    }
}

