/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.inspections.BaseSplitter;
import com.intellij.spellchecker.inspections.WordSplitter;
import com.intellij.util.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextSplitter
extends BaseSplitter {
    private static final TextSplitter INSTANCE = new TextSplitter();
    private static final String letter = "(\\p{L}\\p{Mn}*)";
    private static final String xmlEntity = "(&.+?;)";
    private static final String rightSingleQuotationMark = "\\u2019";
    private static final Pattern EXTENDED_WORD_AND_SPECIAL = Pattern.compile("(&.+?;)|(#|0x\\d*)?(\\p{L}\\p{Mn}*)++(['\\u2019](\\p{L}\\p{Mn}*))?(_|(\\p{L}\\p{Mn}*))*+");

    public static TextSplitter getInstance() {
        return INSTANCE;
    }

    @Override
    public void split(@Nullable String text, @NotNull TextRange range, @NotNull Consumer<TextRange> consumer) {
        if (range == null) {
            TextSplitter.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            TextSplitter.$$$reportNull$$$0(1);
        }
        if (text == null || StringUtil.isEmpty((String)text)) {
            return;
        }
        this.doSplit(text, range, consumer);
    }

    protected void doSplit(@NotNull String text, @NotNull TextRange range, Consumer<TextRange> consumer) {
        if (text == null) {
            TextSplitter.$$$reportNull$$$0(2);
        }
        if (range == null) {
            TextSplitter.$$$reportNull$$$0(3);
        }
        WordSplitter ws = WordSplitter.getInstance();
        try {
            Matcher matcher = this.getExtendedWordAndSpecial().matcher(TextSplitter.newBombedCharSequence(text));
            matcher.region(range.getStartOffset(), range.getEndOffset());
            while (matcher.find()) {
                TextRange found = new TextRange(matcher.start(), matcher.end());
                ws.split(text, found, consumer);
            }
        }
        catch (BaseSplitter.TooLongBombedMatchingException tooLongBombedMatchingException) {
            // empty catch block
        }
    }

    @Contract(pure=true)
    @NotNull
    protected Pattern getExtendedWordAndSpecial() {
        Pattern pattern = EXTENDED_WORD_AND_SPECIAL;
        if (pattern == null) {
            TextSplitter.$$$reportNull$$$0(4);
        }
        return pattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/inspections/TextSplitter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/inspections/TextSplitter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendedWordAndSpecial";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doSplit";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

