/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.DifferentiateContext;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.ReferenceID;
import org.jetbrains.jps.dependency.Usage;
import org.jetbrains.jps.dependency.diff.Difference;
import org.jetbrains.jps.dependency.java.AnnotationGroup;
import org.jetbrains.jps.dependency.java.AnnotationInstance;
import org.jetbrains.jps.dependency.java.ClassUsage;
import org.jetbrains.jps.dependency.java.ElementAnnotation;
import org.jetbrains.jps.dependency.java.ImportStaticMemberUsage;
import org.jetbrains.jps.dependency.java.ImportStaticOnDemandUsage;
import org.jetbrains.jps.dependency.java.JvmClass;
import org.jetbrains.jps.dependency.java.JvmDifferentiateStrategy;
import org.jetbrains.jps.dependency.java.JvmField;
import org.jetbrains.jps.dependency.java.JvmMethod;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.ParamAnnotation;
import org.jetbrains.jps.dependency.java.Proto;
import org.jetbrains.jps.dependency.java.ProtoMember;
import org.jetbrains.jps.dependency.java.TypeRepr;
import org.jetbrains.jps.dependency.java.Utils;
import org.jetbrains.jps.util.Iterators;
import org.jetbrains.jps.util.Pair;

public abstract class JvmDifferentiateStrategyImpl
implements JvmDifferentiateStrategy {
    private static final Logger LOG = Logger.getLogger("#org.jetbrains.jps.dependency.java.JvmDifferentiateStrategyImpl");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final <T extends AnnotationInstance, D extends AnnotationInstance.Diff<T>> boolean isAffectedByAnnotations(Proto element, Difference.Specifier<T, D> annotationsDiff, Set<AnnotationGroup.AffectionKind> affectionKinds, Predicate<? super TypeRepr.ClassType> annotationSelector) {
        if (element.isPrivate()) return false;
        if (Iterators.find(this.getAffectedAnnotations(annotationsDiff, affectionKinds), annotationSelector::test) == null) return false;
        return true;
    }

    protected final <T extends AnnotationInstance, D extends AnnotationInstance.Diff<T>> Iterable<TypeRepr.ClassType> getAffectedAnnotations(Difference.Specifier<T, D> annotationsDiff, Set<AnnotationGroup.AffectionKind> affectionKinds) {
        Iterable<Object> added = affectionKinds.contains((Object)AnnotationGroup.AffectionKind.added) ? annotationsDiff.added() : List.of();
        Iterable<Object> removed = affectionKinds.contains((Object)AnnotationGroup.AffectionKind.removed) ? annotationsDiff.removed() : List.of();
        List changed = affectionKinds.contains((Object)AnnotationGroup.AffectionKind.changed) ? Iterators.map(annotationsDiff.changed(), Difference.Change::getPast) : List.of();
        return Iterators.map((Iterable)Iterators.flat(List.of(added, removed, changed)), AnnotationInstance::getAnnotationClass);
    }

    protected Iterable<AnnotationGroup> getTrackedAnnotations() {
        return Collections.emptyList();
    }

    @Override
    public boolean isAnnotationTracked( @NotNull TypeRepr.ClassType annotationType) {
        if (annotationType == null) {
            JvmDifferentiateStrategyImpl.$$$reportNull$$$0(0);
        }
        return Iterators.find(this.getTrackedAnnotations(), gr -> gr.types.contains(annotationType)) != null;
    }

    private Set<AnnotationGroup.AffectionScope> getMaxPossibleScope() {
        EnumSet<AnnotationGroup.AffectionScope> result = EnumSet.noneOf(AnnotationGroup.AffectionScope.class);
        for (AnnotationGroup group : this.getTrackedAnnotations()) {
            result.addAll(group.affectionScope);
        }
        return result;
    }

    @Override
    public boolean processClassAnnotations(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, Difference.Specifier<ElementAnnotation, ElementAnnotation.Diff> annotationDiff, Utils future, Utils present) {
        Set<AnnotationGroup.AffectionScope> maxScope = this.getMaxPossibleScope();
        if (maxScope.isEmpty()) {
            return true;
        }
        JvmClass changedClass = change.getPast();
        EnumSet<AnnotationGroup.AffectionScope> affectionScope = EnumSet.noneOf(AnnotationGroup.AffectionScope.class);
        for (AnnotationGroup group : Iterators.filter(this.getTrackedAnnotations(), gr -> gr.targets.contains((Object)AnnotationGroup.AnnTarget.type))) {
            if (!this.isAffectedByAnnotations(changedClass, annotationDiff, group.affectionKind, group.types::contains)) continue;
            this.debug(group.name, " changed for ", changedClass.getName(), " --- affecting class usages");
            affectionScope.addAll(group.affectionScope);
            if (!affectionScope.equals(maxScope)) continue;
            break;
        }
        if (!affectionScope.isEmpty()) {
            this.affectClassAnnotationUsages(context, affectionScope, change, future, present);
        }
        return true;
    }

    @Override
    public boolean processFieldAnnotations(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> clsChange, Difference.Change<JvmField, JvmField.Diff> fieldChange, Difference.Specifier<ElementAnnotation, ElementAnnotation.Diff> annotationDiff, Utils future, Utils present) {
        Set<AnnotationGroup.AffectionScope> maxScope = this.getMaxPossibleScope();
        if (maxScope.isEmpty()) {
            return true;
        }
        JvmField changedField = fieldChange.getPast();
        EnumSet<AnnotationGroup.AffectionScope> affectionScope = EnumSet.noneOf(AnnotationGroup.AffectionScope.class);
        for (AnnotationGroup group : Iterators.filter(this.getTrackedAnnotations(), gr -> gr.targets.contains((Object)AnnotationGroup.AnnTarget.field))) {
            if (!this.isAffectedByAnnotations(changedField, annotationDiff, group.affectionKind, group.types::contains)) continue;
            this.debug(group.name, " changed for field ", changedField, " --- affecting field usages");
            affectionScope.addAll(group.affectionScope);
            if (!affectionScope.equals(maxScope)) continue;
            break;
        }
        if (!affectionScope.isEmpty()) {
            this.affectFieldAnnotationUsages(context, affectionScope, clsChange, changedField, future, present);
        }
        return true;
    }

    @Override
    public boolean processMethodAnnotations(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> clsChange, Difference.Change<JvmMethod, JvmMethod.Diff> methodChange, Difference.Specifier<ElementAnnotation, ElementAnnotation.Diff> annotationsDiff, Difference.Specifier<ParamAnnotation, ParamAnnotation.Diff> paramAnnotationsDiff, Utils future, Utils present) {
        Set<AnnotationGroup.AffectionScope> maxScope = this.getMaxPossibleScope();
        JvmMethod changedMethod = methodChange.getPast();
        if (!changedMethod.isFinal()) {
            maxScope.add(AnnotationGroup.AffectionScope.subclasses);
        }
        EnumSet<AnnotationGroup.AffectionScope> affectionScope = EnumSet.noneOf(AnnotationGroup.AffectionScope.class);
        for (AnnotationGroup group : Iterators.filter(this.getTrackedAnnotations(), gr -> gr.targets.contains((Object)AnnotationGroup.AnnTarget.method))) {
            if (!this.isAffectedByAnnotations(changedMethod, annotationsDiff, group.affectionKind, group.types::contains)) continue;
            affectionScope.addAll(group.affectionScope);
            if (!changedMethod.isFinal()) {
                affectionScope.add(AnnotationGroup.AffectionScope.subclasses);
                this.debug(group.name, " changed for non-final method ", changedMethod, " --- affecting method usages and subclasses");
            } else {
                this.debug(group.name, " changed for method ", changedMethod, " --- affecting method usages");
            }
            if (!affectionScope.equals(maxScope)) continue;
            break;
        }
        if (!affectionScope.equals(maxScope)) {
            for (AnnotationGroup group : Iterators.filter(this.getTrackedAnnotations(), gr -> gr.targets.contains((Object)AnnotationGroup.AnnTarget.method_parameter))) {
                if (!this.isAffectedByAnnotations(changedMethod, paramAnnotationsDiff, group.affectionKind, group.types::contains)) continue;
                affectionScope.addAll(group.affectionScope);
                if (!changedMethod.isFinal()) {
                    affectionScope.add(AnnotationGroup.AffectionScope.subclasses);
                    this.debug(group.name, " changed for non-final method parameters ", changedMethod, " --- affecting method usages and subclasses");
                } else {
                    this.debug(group.name, " changed for method parameters ", changedMethod, " --- affecting method usages");
                }
                if (!affectionScope.equals(maxScope)) continue;
                break;
            }
        }
        if (!affectionScope.isEmpty()) {
            this.affectMethodAnnotationUsages(context, affectionScope, clsChange, changedMethod, future, present);
        }
        return true;
    }

    protected void affectClassAnnotationUsages(DifferentiateContext context, Set<AnnotationGroup.AffectionScope> toRecompile, Difference.Change<JvmClass, JvmClass.Diff> change, Utils future, Utils present) {
        JvmClass changedClass = change.getPast();
        boolean affectUsages = toRecompile.contains((Object)AnnotationGroup.AffectionScope.usages);
        if (affectUsages) {
            context.affectUsage(new ClassUsage(changedClass.getReferenceID()));
        }
        if (toRecompile.contains((Object)AnnotationGroup.AffectionScope.subclasses)) {
            this.affectSubclasses(context, future, changedClass.getReferenceID(), affectUsages);
        }
    }

    protected void affectFieldAnnotationUsages(DifferentiateContext context, Set<AnnotationGroup.AffectionScope> toRecompile, Difference.Change<JvmClass, JvmClass.Diff> clsChange, JvmField changedField, Utils future, Utils present) {
        JvmClass changedClass = clsChange.getPast();
        if (toRecompile.contains((Object)AnnotationGroup.AffectionScope.usages)) {
            this.affectMemberUsages(context, changedClass.getReferenceID(), changedField, future.collectSubclassesWithoutField(changedClass.getReferenceID(), changedField));
        }
        if (toRecompile.contains((Object)AnnotationGroup.AffectionScope.subclasses)) {
            this.affectSubclasses(context, future, changedClass.getReferenceID(), false);
        }
    }

    protected void affectMethodAnnotationUsages(DifferentiateContext context, Set<AnnotationGroup.AffectionScope> toRecompile, Difference.Change<JvmClass, JvmClass.Diff> clsChange, JvmMethod changedMethod, Utils future, Utils present) {
        JvmClass changedClass = clsChange.getPast();
        if (toRecompile.contains((Object)AnnotationGroup.AffectionScope.usages)) {
            this.affectMemberUsages(context, changedClass.getReferenceID(), changedMethod, future.collectSubclassesWithoutMethod(changedClass.getReferenceID(), changedMethod));
            if (changedMethod.isAbstract() || toRecompile.contains((Object)AnnotationGroup.AffectionScope.subclasses)) {
                for (Pair pair : Iterators.recurse((Object)Pair.create((Object)changedClass, (Object)changedMethod), p -> ((JvmMethod)p.second).isOverridable() ? future.getOverridingMethods((JvmClass)p.first, (JvmMethod)p.second, ((JvmMethod)p.second)::isSameByJavaRules) : Collections.emptyList(), (boolean)false)) {
                    JvmNodeReferenceID clsId = ((JvmClass)pair.first).getReferenceID();
                    JvmMethod meth = (JvmMethod)pair.second;
                    this.affectMemberUsages(context, clsId, meth, future.collectSubclassesWithoutMethod(clsId, meth));
                }
            }
        }
        if (toRecompile.contains((Object)AnnotationGroup.AffectionScope.subclasses)) {
            this.affectSubclasses(context, future, changedClass.getReferenceID(), false);
        }
    }

    protected void affectMemberUsages(DifferentiateContext context, JvmNodeReferenceID clsId, ProtoMember member, Iterable<JvmNodeReferenceID> propagated) {
        this.affectMemberUsages(context, clsId, member, propagated, null);
    }

    protected void affectMemberUsages(DifferentiateContext context, JvmNodeReferenceID clsId, ProtoMember member, Iterable<JvmNodeReferenceID> propagated, @Nullable Predicate<Node<?, ?>> constraint) {
        this.affectUsages(context, (member instanceof JvmMethod ? "method " : (member instanceof JvmField ? "field " : "member ")) + String.valueOf(member), Iterators.flat((Iterable)Iterators.asIterable((Object)clsId), propagated), id -> member.createUsage((JvmNodeReferenceID)id), constraint);
    }

    protected void affectStaticMemberOnDemandUsages(DifferentiateContext context, JvmNodeReferenceID clsId, Iterable<JvmNodeReferenceID> propagated) {
        this.affectUsages(context, "static member on-demand import usage", Iterators.flat((Iterable)Iterators.asIterable((Object)clsId), propagated), id -> new ImportStaticOnDemandUsage((JvmNodeReferenceID)id), null);
    }

    protected void affectStaticMemberImportUsages(DifferentiateContext context, JvmNodeReferenceID clsId, String memberName, Iterable<JvmNodeReferenceID> propagated) {
        this.affectUsages(context, "static member import", Iterators.flat((Iterable)Iterators.asIterable((Object)clsId), propagated), id -> new ImportStaticMemberUsage(id.getNodeName(), memberName), null);
    }

    protected void affectUsages(DifferentiateContext context, String usageKind, Iterable<JvmNodeReferenceID> usageOwners, Function<? super JvmNodeReferenceID, ? extends Usage> usageFactory, @Nullable Predicate<Node<?, ?>> constraint) {
        for (JvmNodeReferenceID id : usageOwners) {
            if (constraint != null) {
                context.affectUsage(usageFactory.apply(id), constraint);
            } else {
                context.affectUsage(usageFactory.apply(id));
            }
            this.debug("Affect ", usageKind, " usage owned by node '", id.getNodeName(), "'");
        }
    }

    protected boolean isDebugEnabled() {
        return LOG.isLoggable(Level.FINE);
    }

    protected void debug(String message, Object ... details) {
        if (this.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder(message);
            for (Object detail : details) {
                msg.append(detail);
            }
            this.debug(msg.toString());
        }
    }

    protected void debug(String message) {
        LOG.log(Level.FINE, message);
    }

    protected void affectSubclasses(DifferentiateContext context, Utils utils, ReferenceID fromClass, boolean affectUsages) {
        this.debug("Affecting subclasses of class: ", fromClass, "; with usages affection: ", affectUsages);
        for (ReferenceID cl : utils.withAllSubclasses(fromClass)) {
            String nodeName;
            this.affectNodeSources(context, cl, "Affecting source file: ", utils);
            if (!affectUsages || (nodeName = utils.getNodeName(cl)) == null) continue;
            context.affectUsage(new ClassUsage(nodeName));
            this.debug("Affect usage of class ", nodeName);
        }
    }

    protected void affectNodeSources(DifferentiateContext context, ReferenceID clsId, String affectReason, Utils utils) {
        this.affectSources(context, utils.getNodeSources(clsId), affectReason, false);
    }

    protected void affectSources(DifferentiateContext context, Iterable<NodeSource> sources, String affectReason, boolean forceAffect) {
        Set<NodeSource> deletedSources = context.getDelta().getDeletedSources();
        Predicate<? super NodeSource> affectionFilter = context.getParams().affectionFilter();
        for (NodeSource source : Iterators.filter(sources, affectionFilter::test)) {
            if (!forceAffect && context.isCompiled(source) || deletedSources.contains(source)) continue;
            context.affectNodeSource(source);
            this.debug(affectReason, source);
        }
    }

    protected boolean affectNodeSourcesIfNotCompiled(DifferentiateContext context, Iterable<ReferenceID> nodeIds, Utils utils, String affectReason) {
        Set<NodeSource> deletedSources = context.getDelta().getDeletedSources();
        Predicate<? super NodeSource> belongsToChunk = context.getParams().belongsToCurrentCompilationChunk();
        Set candidates = (Set)Iterators.collect((Iterable)Iterators.filter((Iterable)Iterators.flat((Iterable)Iterators.map(nodeIds, utils::getNodeSources)), s -> !deletedSources.contains(s) && belongsToChunk.test((NodeSource)s)), new HashSet());
        if (Iterators.find((Iterable)candidates, src -> !context.isCompiled((NodeSource)src)) != null) {
            StringBuilder msg = new StringBuilder(affectReason);
            for (NodeSource candidate : candidates) {
                context.affectNodeSource(candidate);
                msg.append(candidate).append("; ");
            }
            this.debug(msg.toString());
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationType", "org/jetbrains/jps/dependency/java/JvmDifferentiateStrategyImpl", "isAnnotationTracked"));
    }
}

