/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptStackElement;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class NativeCallSite
extends IdScriptableObject {
    private static final long serialVersionUID = 2688372752566593594L;
    private static final String CALLSITE_TAG = "CallSite";
    private ScriptStackElement element;
    private static final int Id_constructor = 1;
    private static final int Id_getThis = 2;
    private static final int Id_getTypeName = 3;
    private static final int Id_getFunction = 4;
    private static final int Id_getFunctionName = 5;
    private static final int Id_getMethodName = 6;
    private static final int Id_getFileName = 7;
    private static final int Id_getLineNumber = 8;
    private static final int Id_getColumnNumber = 9;
    private static final int Id_getEvalOrigin = 10;
    private static final int Id_isToplevel = 11;
    private static final int Id_isEval = 12;
    private static final int Id_isNative = 13;
    private static final int Id_isConstructor = 14;
    private static final int Id_toString = 15;
    private static final int MAX_PROTOTYPE_ID = 15;

    static void init(Scriptable scriptable, boolean bl) {
        NativeCallSite nativeCallSite = new NativeCallSite();
        nativeCallSite.exportAsJSClass(15, scriptable, bl);
    }

    static NativeCallSite make(Scriptable scriptable, Scriptable scriptable2) {
        NativeCallSite nativeCallSite = new NativeCallSite();
        Scriptable scriptable3 = (Scriptable)scriptable2.get("prototype", scriptable2);
        nativeCallSite.setParentScope(scriptable);
        nativeCallSite.setPrototype(scriptable3);
        return nativeCallSite;
    }

    private NativeCallSite() {
    }

    void setElement(ScriptStackElement scriptStackElement) {
        this.element = scriptStackElement;
    }

    @Override
    public String getClassName() {
        return CALLSITE_TAG;
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 0;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string = "getThis";
                break;
            }
            case 3: {
                n2 = 0;
                string = "getTypeName";
                break;
            }
            case 4: {
                n2 = 0;
                string = "getFunction";
                break;
            }
            case 5: {
                n2 = 0;
                string = "getFunctionName";
                break;
            }
            case 6: {
                n2 = 0;
                string = "getMethodName";
                break;
            }
            case 7: {
                n2 = 0;
                string = "getFileName";
                break;
            }
            case 8: {
                n2 = 0;
                string = "getLineNumber";
                break;
            }
            case 9: {
                n2 = 0;
                string = "getColumnNumber";
                break;
            }
            case 10: {
                n2 = 0;
                string = "getEvalOrigin";
                break;
            }
            case 11: {
                n2 = 0;
                string = "isToplevel";
                break;
            }
            case 12: {
                n2 = 0;
                string = "isEval";
                break;
            }
            case 13: {
                n2 = 0;
                string = "isNative";
                break;
            }
            case 14: {
                n2 = 0;
                string = "isConstructor";
                break;
            }
            case 15: {
                n2 = 0;
                string = "toString";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(CALLSITE_TAG, n, string, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(CALLSITE_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                return NativeCallSite.make(scriptable, idFunctionObject);
            }
            case 5: {
                return NativeCallSite.getFunctionName(scriptable2);
            }
            case 7: {
                return NativeCallSite.getFileName(scriptable2);
            }
            case 8: {
                return NativeCallSite.getLineNumber(scriptable2);
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: {
                return Undefined.instance;
            }
            case 6: {
                return null;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return Boolean.FALSE;
            }
            case 15: {
                return NativeCallSite.js_toString(scriptable2);
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    public String toString() {
        if (this.element == null) {
            return "";
        }
        return this.element.toString();
    }

    private static Object js_toString(Scriptable scriptable) {
        while (scriptable != null && !(scriptable instanceof NativeCallSite)) {
            scriptable = scriptable.getPrototype();
        }
        if (scriptable == null) {
            return NOT_FOUND;
        }
        NativeCallSite nativeCallSite = (NativeCallSite)scriptable;
        StringBuilder stringBuilder = new StringBuilder();
        nativeCallSite.element.renderJavaStyle(stringBuilder);
        return stringBuilder.toString();
    }

    private static Object getFunctionName(Scriptable scriptable) {
        while (scriptable != null && !(scriptable instanceof NativeCallSite)) {
            scriptable = scriptable.getPrototype();
        }
        if (scriptable == null) {
            return NOT_FOUND;
        }
        NativeCallSite nativeCallSite = (NativeCallSite)scriptable;
        return nativeCallSite.element == null ? null : nativeCallSite.element.functionName;
    }

    private static Object getFileName(Scriptable scriptable) {
        while (scriptable != null && !(scriptable instanceof NativeCallSite)) {
            scriptable = scriptable.getPrototype();
        }
        if (scriptable == null) {
            return NOT_FOUND;
        }
        NativeCallSite nativeCallSite = (NativeCallSite)scriptable;
        return nativeCallSite.element == null ? null : nativeCallSite.element.fileName;
    }

    private static Object getLineNumber(Scriptable scriptable) {
        while (scriptable != null && !(scriptable instanceof NativeCallSite)) {
            scriptable = scriptable.getPrototype();
        }
        if (scriptable == null) {
            return NOT_FOUND;
        }
        NativeCallSite nativeCallSite = (NativeCallSite)scriptable;
        if (nativeCallSite.element == null || nativeCallSite.element.lineNumber < 0) {
            return Undefined.instance;
        }
        return nativeCallSite.element.lineNumber;
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        switch (string) {
            case "constructor": {
                n = 1;
                break;
            }
            case "getThis": {
                n = 2;
                break;
            }
            case "getTypeName": {
                n = 3;
                break;
            }
            case "getFunction": {
                n = 4;
                break;
            }
            case "getFunctionName": {
                n = 5;
                break;
            }
            case "getMethodName": {
                n = 6;
                break;
            }
            case "getFileName": {
                n = 7;
                break;
            }
            case "getLineNumber": {
                n = 8;
                break;
            }
            case "getColumnNumber": {
                n = 9;
                break;
            }
            case "getEvalOrigin": {
                n = 10;
                break;
            }
            case "isToplevel": {
                n = 11;
                break;
            }
            case "isEval": {
                n = 12;
                break;
            }
            case "isNative": {
                n = 13;
                break;
            }
            case "isConstructor": {
                n = 14;
                break;
            }
            case "toString": {
                n = 15;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }
}

