﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/rum/CloudWatchRUM_EXPORTS.h>
#include <aws/rum/model/MetricDefinitionRequest.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CloudWatchRUM {
namespace Model {

/**
 * <p>A structure that defines one error caused by a <a
 * href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_BatchCreateRumMetricsDefinitions.html">BatchCreateRumMetricsDefinitions</a>
 * operation.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/rum-2018-05-10/BatchCreateRumMetricDefinitionsError">AWS
 * API Reference</a></p>
 */
class BatchCreateRumMetricDefinitionsError {
 public:
  AWS_CLOUDWATCHRUM_API BatchCreateRumMetricDefinitionsError() = default;
  AWS_CLOUDWATCHRUM_API BatchCreateRumMetricDefinitionsError(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLOUDWATCHRUM_API BatchCreateRumMetricDefinitionsError& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLOUDWATCHRUM_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The error code.</p>
   */
  inline const Aws::String& GetErrorCode() const { return m_errorCode; }
  inline bool ErrorCodeHasBeenSet() const { return m_errorCodeHasBeenSet; }
  template <typename ErrorCodeT = Aws::String>
  void SetErrorCode(ErrorCodeT&& value) {
    m_errorCodeHasBeenSet = true;
    m_errorCode = std::forward<ErrorCodeT>(value);
  }
  template <typename ErrorCodeT = Aws::String>
  BatchCreateRumMetricDefinitionsError& WithErrorCode(ErrorCodeT&& value) {
    SetErrorCode(std::forward<ErrorCodeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The error message for this metric definition.</p>
   */
  inline const Aws::String& GetErrorMessage() const { return m_errorMessage; }
  inline bool ErrorMessageHasBeenSet() const { return m_errorMessageHasBeenSet; }
  template <typename ErrorMessageT = Aws::String>
  void SetErrorMessage(ErrorMessageT&& value) {
    m_errorMessageHasBeenSet = true;
    m_errorMessage = std::forward<ErrorMessageT>(value);
  }
  template <typename ErrorMessageT = Aws::String>
  BatchCreateRumMetricDefinitionsError& WithErrorMessage(ErrorMessageT&& value) {
    SetErrorMessage(std::forward<ErrorMessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metric definition that caused this error.</p>
   */
  inline const MetricDefinitionRequest& GetMetricDefinition() const { return m_metricDefinition; }
  inline bool MetricDefinitionHasBeenSet() const { return m_metricDefinitionHasBeenSet; }
  template <typename MetricDefinitionT = MetricDefinitionRequest>
  void SetMetricDefinition(MetricDefinitionT&& value) {
    m_metricDefinitionHasBeenSet = true;
    m_metricDefinition = std::forward<MetricDefinitionT>(value);
  }
  template <typename MetricDefinitionT = MetricDefinitionRequest>
  BatchCreateRumMetricDefinitionsError& WithMetricDefinition(MetricDefinitionT&& value) {
    SetMetricDefinition(std::forward<MetricDefinitionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_errorCode;
  bool m_errorCodeHasBeenSet = false;

  Aws::String m_errorMessage;
  bool m_errorMessageHasBeenSet = false;

  MetricDefinitionRequest m_metricDefinition;
  bool m_metricDefinitionHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudWatchRUM
}  // namespace Aws
