/*
 * ExprPropsHandler.java
 *
 * Brazil project web application toolkit,
 * export version: 2.1 
 * Copyright (c) 2001-2004 Sun Microsystems, Inc.
 *
 * Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License Version 
 * 1.0 (the "License"). You may not use this file except in compliance with 
 * the License. A copy of the License is included as the file "license.terms",
 * and also available at http://www.sun.com/
 * 
 * The Original Code is from:
 *    Brazil project web application toolkit release 2.1.
 * The Initial Developer of the Original Code is: drach.
 * Portions created by drach are Copyright (C) Sun Microsystems, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s): drach, suhler.
 *
 * Version:  2.4
 * Created by drach on 01/07/11
 * Last modified by suhler on 04/12/30 12:37:45
 */

package sunlabs.brazil.properties;

import sunlabs.brazil.server.Handler;
import sunlabs.brazil.server.Request;
import sunlabs.brazil.server.Server;
import sunlabs.brazil.handler.MatchString;

import java.io.IOException;

/**
 *
 * The <code>ExprPropsHandler</code> installs an expression evaluator as a
 * "smart properties" into the current request object, enabling arithmetic and
 * logical expression evaluation in property name lookups.
 * <p>
 * The following configuration parameters are used:
 * <dl class=props>
 * <dt>prefix, suffix, glob, match
 * <dd>Only URL's that match are allowed.
 * (See {@link sunlabs.brazil.handler.MatchString}).
 * </dl>
 * <p>
 * Using the expression evaluator can be a bit tricky, as the evaluator
 * works by interpreting a property name as an expression, and using its
 * the expression result as its value.  For example, the construct:
 * <pre>
 * "${x + 4 == 3}"
 * </pre>
 * will evaluate to either "1" or "0", depending upon the value of "x".
 * For use with the <code>&lt;if&gt;</code> constuct of the
 * {@link sunlabs.brazil.template.BSLTemplate}, the following construct:
 * <pre>
 * &lt;if name="${x + 4 == 3}"&gt; ... [if expression] ... &lt;/if&gt;
 * </pre>
 * Will take (or not take) the "if expression" if there is a property
 * named "1" that is set (to anything but 0 or false), but a property
 * named "0" is not set.  An entry in a server configuration file:
 * <pre>
 * 1=true
 * </pre>
 * will do the trick.
 * <p>
 * alternately, the construct:
 * <pre>
 * &lt;if name=true value="${x + 4 == 3}"&gt; ... [if expression] ... &lt;/if&gt;
 * </pre>
 * Will work as expected only if there is a configuration property:
 * <pre>
 * true=1
 * </pre>
 * The choice of the name "true" is arbitrary, it could be any
 * valiable whose value is "1".
 * 
 * @author	Steve Drach &lt;drach@sun.com&gt;
 * @version     2.4, 04/12/30
 *
 * @see ExprProps
 * @see sunlabs.brazil.server.Request
 */
public class ExprPropsHandler implements Handler {

    private MatchString isMine;            // check for matching url

    public boolean
    init(Server server, String prefix) {
	isMine = new MatchString(prefix, server.props);
	return true;
    }

    /**
     *
     * Creates an instance of <code>ExprProps</code> that uses
     * <code>request.props</code> for the wrapped
     * <code>Calculator</code>'s symbol table.
     *
     * @see sunlabs.brazil.util.Calculator
     *
     * @return false
     */
    public boolean
    respond(Request request) throws IOException {
	if (isMine.match(request.url)) {
	    PropertiesList pl = new PropertiesList(new ExprProps(request), true);
	    pl.addBefore(request.serverProps);
	}
	return false;
    }
}
