/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;

public final class ObjectUtils {
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];

    private ObjectUtils() {
    }

    public static <T> T defaultIfNull(T object, T defaultValue) {
        return object == null ? defaultValue : object;
    }

    public static boolean isEmptyArray(Object array) {
        return array == null || array.getClass().isArray() && Array.getLength(array) == 0;
    }

    public static boolean arrayContains(Object[] array, Object objectToFind) {
        if (array == null) {
            return false;
        }
        return Stream.of(array).anyMatch(Predicate.isEqual(objectToFind));
    }

    public static int indexOf(Object[] array, Object objectToFind) {
        for (int i = 0; i < array.length; ++i) {
            if (!Objects.equals(array[i], objectToFind)) continue;
            return i;
        }
        return -1;
    }

    public static <T> T[] arrayAdd(T[] array, T objectToAdd) {
        if (array == null && objectToAdd == null) {
            throw new IllegalArgumentException("Arguments cannot both be null");
        }
        int arrayLength = Array.getLength(array);
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), arrayLength + 1);
        System.arraycopy(array, 0, newArray, 0, arrayLength);
        newArray[newArray.length - 1] = objectToAdd;
        return newArray;
    }

    public static int hashCode(Object o) {
        if (o instanceof Object[]) {
            return Arrays.hashCode((Object[])o);
        }
        if (o instanceof byte[]) {
            return Arrays.hashCode((byte[])o);
        }
        if (o instanceof short[]) {
            return Arrays.hashCode((short[])o);
        }
        if (o instanceof int[]) {
            return Arrays.hashCode((int[])o);
        }
        if (o instanceof char[]) {
            return Arrays.hashCode((char[])o);
        }
        if (o instanceof long[]) {
            return Arrays.hashCode((long[])o);
        }
        if (o instanceof float[]) {
            return Arrays.hashCode((float[])o);
        }
        if (o instanceof double[]) {
            return Arrays.hashCode((double[])o);
        }
        if (o instanceof boolean[]) {
            return Arrays.hashCode((boolean[])o);
        }
        return Objects.hashCode(o);
    }
}

