/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo;

import com.google.common.base.Strings;
import java.math.BigInteger;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHPublicKeySpec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.DecodingException;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.xml.security.utils.XMLUtils;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.crypto.dh.DHSupport;
import org.opensaml.security.crypto.ec.ECSupport;
import org.opensaml.security.x509.X509Support;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.encryption.DHKeyValue;
import org.opensaml.xmlsec.encryption.Generator;
import org.opensaml.xmlsec.encryption.P;
import org.opensaml.xmlsec.encryption.Public;
import org.opensaml.xmlsec.encryption.Q;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;
import org.opensaml.xmlsec.signature.DEREncodedKeyValue;
import org.opensaml.xmlsec.signature.DSAKeyValue;
import org.opensaml.xmlsec.signature.ECKeyValue;
import org.opensaml.xmlsec.signature.Exponent;
import org.opensaml.xmlsec.signature.G;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.KeyName;
import org.opensaml.xmlsec.signature.KeyValue;
import org.opensaml.xmlsec.signature.Modulus;
import org.opensaml.xmlsec.signature.NamedCurve;
import org.opensaml.xmlsec.signature.RSAKeyValue;
import org.opensaml.xmlsec.signature.X509CRL;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import org.opensaml.xmlsec.signature.X509Digest;
import org.opensaml.xmlsec.signature.X509IssuerName;
import org.opensaml.xmlsec.signature.X509IssuerSerial;
import org.opensaml.xmlsec.signature.X509SKI;
import org.opensaml.xmlsec.signature.X509SerialNumber;
import org.opensaml.xmlsec.signature.X509SubjectName;
import org.opensaml.xmlsec.signature.Y;
import org.slf4j.Logger;

public final class KeyInfoSupport {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(KeyInfoSupport.class);
    @Nullable
    private static CertificateFactory x509CertFactory;

    private KeyInfoSupport() {
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static List<String> getKeyNames(@Nullable KeyInfo keyInfo) {
        LinkedList<String> keynameList = new LinkedList<String>();
        if (keyInfo == null) {
            return keynameList;
        }
        List<KeyName> keyNames = keyInfo.getKeyNames();
        for (KeyName keyName : keyNames) {
            if (keyName.getValue() == null) continue;
            keynameList.add(keyName.getValue());
        }
        return keynameList;
    }

    public static void addKeyName(@Nonnull KeyInfo keyInfo, @Nullable String keyNameValue) {
        Constraint.isNotNull((Object)keyInfo, (String)"KeyInfo cannot be null");
        XMLObjectBuilder keyNameBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(KeyName.DEFAULT_ELEMENT_NAME);
        KeyName keyName = (KeyName)keyNameBuilder.buildObject(KeyName.DEFAULT_ELEMENT_NAME);
        keyName.setValue(keyNameValue);
        keyInfo.getKeyNames().add(keyName);
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static List<java.security.cert.X509Certificate> getCertificates(@Nullable KeyInfo keyInfo) throws CertificateException {
        LinkedList<java.security.cert.X509Certificate> certList = new LinkedList<java.security.cert.X509Certificate>();
        if (keyInfo == null) {
            return certList;
        }
        List<X509Data> x509Datas = keyInfo.getX509Datas();
        for (X509Data x509Data : x509Datas) {
            certList.addAll(KeyInfoSupport.getCertificates(x509Data));
        }
        return certList;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static List<java.security.cert.X509Certificate> getCertificates(@Nullable X509Data x509Data) throws CertificateException {
        LinkedList<java.security.cert.X509Certificate> certList = new LinkedList<java.security.cert.X509Certificate>();
        if (x509Data == null) {
            return certList;
        }
        for (X509Certificate xmlCert : x509Data.getX509Certificates()) {
            java.security.cert.X509Certificate newCert = KeyInfoSupport.getCertificate(xmlCert);
            if (newCert == null) continue;
            certList.add(newCert);
        }
        return certList;
    }

    @Nullable
    public static java.security.cert.X509Certificate getCertificate(@Nullable X509Certificate xmlCert) throws CertificateException {
        String certVal;
        String string = certVal = xmlCert != null ? xmlCert.getValue() : null;
        if (certVal == null) {
            return null;
        }
        return X509Support.decodeCertificate((String)certVal);
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static List<java.security.cert.X509CRL> getCRLs(@Nullable KeyInfo keyInfo) throws CRLException {
        LinkedList<java.security.cert.X509CRL> crlList = new LinkedList<java.security.cert.X509CRL>();
        if (keyInfo == null) {
            return crlList;
        }
        List<X509Data> x509Datas = keyInfo.getX509Datas();
        for (X509Data x509Data : x509Datas) {
            crlList.addAll(KeyInfoSupport.getCRLs(x509Data));
        }
        return crlList;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static List<java.security.cert.X509CRL> getCRLs(@Nullable X509Data x509Data) throws CRLException {
        LinkedList<java.security.cert.X509CRL> crlList = new LinkedList<java.security.cert.X509CRL>();
        if (x509Data == null) {
            return crlList;
        }
        for (X509CRL xmlCRL : x509Data.getX509CRLs()) {
            java.security.cert.X509CRL newCRL = KeyInfoSupport.getCRL(xmlCRL);
            if (newCRL == null) continue;
            crlList.add(newCRL);
        }
        return crlList;
    }

    @Nullable
    public static java.security.cert.X509CRL getCRL(@Nullable X509CRL xmlCRL) throws CRLException {
        String crlVal;
        String string = crlVal = xmlCRL != null ? xmlCRL.getValue() : null;
        if (crlVal == null) {
            return null;
        }
        try {
            return X509Support.decodeCRL((String)crlVal);
        }
        catch (CertificateException e) {
            throw new CRLException("Certificate error attempting to decode CRL", e);
        }
    }

    public static void addCertificate(@Nonnull KeyInfo keyInfo, @Nonnull java.security.cert.X509Certificate cert) throws CertificateEncodingException {
        X509Data x509Data;
        Constraint.isNotNull((Object)keyInfo, (String)"KeyInfo cannot be null");
        if (keyInfo.getX509Datas().size() == 0) {
            XMLObjectBuilder x509DataBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(X509Data.DEFAULT_ELEMENT_NAME);
            x509Data = (X509Data)x509DataBuilder.buildObject(X509Data.DEFAULT_ELEMENT_NAME);
            keyInfo.getX509Datas().add(x509Data);
        } else {
            x509Data = keyInfo.getX509Datas().get(0);
        }
        x509Data.getX509Certificates().add(KeyInfoSupport.buildX509Certificate(cert));
    }

    public static void addCRL(@Nonnull KeyInfo keyInfo, @Nonnull java.security.cert.X509CRL crl) throws CRLException {
        X509Data x509Data;
        Constraint.isNotNull((Object)keyInfo, (String)"KeyInfo cannot be null");
        if (keyInfo.getX509Datas().size() == 0) {
            XMLObjectBuilder x509DataBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(X509Data.DEFAULT_ELEMENT_NAME);
            x509Data = (X509Data)x509DataBuilder.buildObject(X509Data.DEFAULT_ELEMENT_NAME);
            keyInfo.getX509Datas().add(x509Data);
        } else {
            x509Data = keyInfo.getX509Datas().get(0);
        }
        x509Data.getX509CRLs().add(KeyInfoSupport.buildX509CRL(crl));
    }

    @Nonnull
    public static X509Certificate buildX509Certificate(java.security.cert.X509Certificate cert) throws CertificateEncodingException {
        Constraint.isNotNull((Object)cert, (String)"X.509 certificate cannot be null");
        XMLObjectBuilder xmlCertBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(X509Certificate.DEFAULT_ELEMENT_NAME);
        X509Certificate xmlCert = (X509Certificate)xmlCertBuilder.buildObject(X509Certificate.DEFAULT_ELEMENT_NAME);
        try {
            xmlCert.setValue(Base64Support.encode((byte[])cert.getEncoded(), (boolean)true));
            return xmlCert;
        }
        catch (EncodingException e) {
            throw new CertificateEncodingException("X.509 certificate could not be base64 encoded");
        }
    }

    @Nonnull
    public static X509CRL buildX509CRL(java.security.cert.X509CRL crl) throws CRLException {
        Constraint.isNotNull((Object)crl, (String)"X.509 CRL cannot be null");
        XMLObjectBuilder xmlCRLBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(X509CRL.DEFAULT_ELEMENT_NAME);
        X509CRL xmlCRL = (X509CRL)xmlCRLBuilder.buildObject(X509CRL.DEFAULT_ELEMENT_NAME);
        try {
            xmlCRL.setValue(Base64Support.encode((byte[])crl.getEncoded(), (boolean)true));
            return xmlCRL;
        }
        catch (EncodingException e) {
            throw new CRLException("X.509CRL could not be base64 encoded");
        }
    }

    @Nonnull
    public static X509SubjectName buildX509SubjectName(@Nullable String subjectName) {
        XMLObjectBuilder xmlSubjectNameBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(X509SubjectName.DEFAULT_ELEMENT_NAME);
        X509SubjectName xmlSubjectName = (X509SubjectName)xmlSubjectNameBuilder.buildObject(X509SubjectName.DEFAULT_ELEMENT_NAME);
        xmlSubjectName.setValue(subjectName);
        return xmlSubjectName;
    }

    @Nonnull
    public static X509IssuerSerial buildX509IssuerSerial(@Nullable String issuerName, @Nullable BigInteger serialNumber) {
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        XMLObjectBuilder xmlIssuerNameBuilder = builderFactory.ensureBuilder(X509IssuerName.DEFAULT_ELEMENT_NAME);
        X509IssuerName xmlIssuerName = (X509IssuerName)xmlIssuerNameBuilder.buildObject(X509IssuerName.DEFAULT_ELEMENT_NAME);
        xmlIssuerName.setValue(issuerName);
        XMLObjectBuilder xmlSerialNumberBuilder = builderFactory.ensureBuilder(X509SerialNumber.DEFAULT_ELEMENT_NAME);
        X509SerialNumber xmlSerialNumber = (X509SerialNumber)xmlSerialNumberBuilder.buildObject(X509SerialNumber.DEFAULT_ELEMENT_NAME);
        xmlSerialNumber.setValue(serialNumber);
        XMLObjectBuilder xmlIssuerSerialBuilder = builderFactory.ensureBuilder(X509IssuerSerial.DEFAULT_ELEMENT_NAME);
        X509IssuerSerial xmlIssuerSerial = (X509IssuerSerial)xmlIssuerSerialBuilder.buildObject(X509IssuerSerial.DEFAULT_ELEMENT_NAME);
        xmlIssuerSerial.setX509IssuerName(xmlIssuerName);
        xmlIssuerSerial.setX509SerialNumber(xmlSerialNumber);
        return xmlIssuerSerial;
    }

    @Nullable
    public static X509SKI buildX509SKI(@Nonnull java.security.cert.X509Certificate javaCert) throws SecurityException {
        byte[] skiPlainValue = X509Support.getSubjectKeyIdentifier((java.security.cert.X509Certificate)javaCert);
        if (skiPlainValue == null || skiPlainValue.length == 0) {
            return null;
        }
        XMLObjectBuilder xmlSKIBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(X509SKI.DEFAULT_ELEMENT_NAME);
        X509SKI xmlSKI = (X509SKI)xmlSKIBuilder.buildObject(X509SKI.DEFAULT_ELEMENT_NAME);
        try {
            xmlSKI.setValue(Base64Support.encode((byte[])skiPlainValue, (boolean)true));
            return xmlSKI;
        }
        catch (EncodingException e) {
            LOG.warn("X.509 subject key identifier could not be base64 encoded", (Throwable)e);
            throw new SecurityException("X.509 subject key identifier could not be base64 encoded", (Exception)((Object)e));
        }
    }

    @Nonnull
    public static X509Digest buildX509Digest(@Nonnull java.security.cert.X509Certificate javaCert, @Nonnull String algorithmURI) throws NoSuchAlgorithmException, CertificateEncodingException {
        Constraint.isNotNull((Object)javaCert, (String)"Certificate cannot be null");
        String jceAlg = AlgorithmSupport.getAlgorithmID(algorithmURI);
        if (jceAlg == null) {
            throw new NoSuchAlgorithmException("No JCE algorithm found for " + algorithmURI);
        }
        MessageDigest md = MessageDigest.getInstance(jceAlg);
        byte[] hash = md.digest(javaCert.getEncoded());
        XMLObjectBuilder builder = XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(X509Digest.DEFAULT_ELEMENT_NAME);
        X509Digest xmlDigest = (X509Digest)builder.buildObject(X509Digest.DEFAULT_ELEMENT_NAME);
        xmlDigest.setAlgorithm(algorithmURI);
        try {
            xmlDigest.setValue(Base64Support.encode((byte[])hash, (boolean)true));
            return xmlDigest;
        }
        catch (EncodingException e) {
            throw new CertificateEncodingException("X509Digest could not be base64 encoded");
        }
    }

    public static void addPublicKey(@Nonnull KeyInfo keyInfo, @Nonnull PublicKey pk) throws EncodingException {
        Constraint.isNotNull((Object)keyInfo, (String)"KeyInfo cannot be null");
        XMLObjectBuilder keyValueBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(KeyValue.DEFAULT_ELEMENT_NAME);
        KeyValue keyValue = (KeyValue)keyValueBuilder.buildObject(KeyValue.DEFAULT_ELEMENT_NAME);
        if (pk instanceof RSAPublicKey) {
            keyValue.setRSAKeyValue(KeyInfoSupport.buildRSAKeyValue((RSAPublicKey)pk));
        } else if (pk instanceof ECPublicKey) {
            keyValue.setECKeyValue(KeyInfoSupport.buildECKeyValue((ECPublicKey)pk));
        } else if (pk instanceof DSAPublicKey) {
            keyValue.setDSAKeyValue(KeyInfoSupport.buildDSAKeyValue((DSAPublicKey)pk));
        } else if (pk instanceof DHPublicKey) {
            keyValue.setDHKeyValue(KeyInfoSupport.buildDHKeyValue((DHPublicKey)pk));
        } else {
            String type = pk.getClass().getName();
            throw new IllegalArgumentException("Saw unsupported public key type: " + type);
        }
        keyInfo.getKeyValues().add(keyValue);
    }

    @Nonnull
    public static DHKeyValue buildDHKeyValue(@Nonnull DHPublicKey dhPubKey) throws EncodingException {
        Constraint.isNotNull((Object)dhPubKey, (String)"DH public key cannot be null");
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        XMLObjectBuilder dhKeyValueBuilder = builderFactory.ensureBuilder(DHKeyValue.DEFAULT_ELEMENT_NAME);
        DHKeyValue dhKeyValue = (DHKeyValue)dhKeyValueBuilder.buildObject(DHKeyValue.DEFAULT_ELEMENT_NAME);
        XMLObjectBuilder generatorBuilder = builderFactory.ensureBuilder(Generator.DEFAULT_ELEMENT_NAME);
        XMLObjectBuilder publicBuilder = builderFactory.ensureBuilder(Public.DEFAULT_ELEMENT_NAME);
        XMLObjectBuilder pBuilder = builderFactory.ensureBuilder(P.DEFAULT_ELEMENT_NAME);
        XMLObjectBuilder qBuilder = builderFactory.ensureBuilder(Q.DEFAULT_ELEMENT_NAME);
        Public pub = (Public)publicBuilder.buildObject(Public.DEFAULT_ELEMENT_NAME);
        Generator gen = (Generator)generatorBuilder.buildObject(Generator.DEFAULT_ELEMENT_NAME);
        P p = (P)pBuilder.buildObject(P.DEFAULT_ELEMENT_NAME);
        pub.setValueBigInt(dhPubKey.getY());
        dhKeyValue.setPublic(pub);
        gen.setValueBigInt(dhPubKey.getParams().getG());
        dhKeyValue.setGenerator(gen);
        p.setValueBigInt(dhPubKey.getParams().getP());
        dhKeyValue.setP(p);
        BigInteger qValue = DHSupport.getPrimeQDomainParameter((DHPublicKey)dhPubKey);
        if (qValue != null) {
            Q q = (Q)qBuilder.buildObject(Q.DEFAULT_ELEMENT_NAME);
            q.setValueBigInt(qValue);
            dhKeyValue.setQ(q);
        }
        return dhKeyValue;
    }

    @Nonnull
    public static ECKeyValue buildECKeyValue(@Nonnull ECPublicKey ecPubKey) throws EncodingException {
        Constraint.isNotNull((Object)ecPubKey, (String)"EC public key cannot be null");
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        ECKeyValue ecKeyValue = (ECKeyValue)builderFactory.ensureBuilder(ECKeyValue.DEFAULT_ELEMENT_NAME).buildObject(ECKeyValue.DEFAULT_ELEMENT_NAME);
        NamedCurve namedCurve = (NamedCurve)builderFactory.ensureBuilder(NamedCurve.DEFAULT_ELEMENT_NAME).buildObject(NamedCurve.DEFAULT_ELEMENT_NAME);
        org.opensaml.xmlsec.signature.PublicKey publicKey = (org.opensaml.xmlsec.signature.PublicKey)builderFactory.ensureBuilder(org.opensaml.xmlsec.signature.PublicKey.DEFAULT_ELEMENT_NAME).buildObject(org.opensaml.xmlsec.signature.PublicKey.DEFAULT_ELEMENT_NAME);
        String uri = ECSupport.getNamedCurveURI((ECPublicKey)ecPubKey);
        if (uri == null) {
            throw new EncodingException("Unable to obtain NamedCurve URI from ECPublicKey");
        }
        namedCurve.setURI(uri);
        ecKeyValue.setNamedCurve(namedCurve);
        publicKey.setValue(Base64Support.encode((byte[])ECSupport.encodeECPointUncompressed((ECPoint)ecPubKey.getW(), (EllipticCurve)ecPubKey.getParams().getCurve()), (boolean)false));
        ecKeyValue.setPublicKey(publicKey);
        return ecKeyValue;
    }

    @Nonnull
    public static RSAKeyValue buildRSAKeyValue(@Nonnull RSAPublicKey rsaPubKey) throws EncodingException {
        Constraint.isNotNull((Object)rsaPubKey, (String)"RSA public key cannot be null");
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        XMLObjectBuilder rsaKeyValueBuilder = builderFactory.ensureBuilder(RSAKeyValue.DEFAULT_ELEMENT_NAME);
        RSAKeyValue rsaKeyValue = (RSAKeyValue)rsaKeyValueBuilder.buildObject(RSAKeyValue.DEFAULT_ELEMENT_NAME);
        XMLObjectBuilder modulusBuilder = builderFactory.ensureBuilder(Modulus.DEFAULT_ELEMENT_NAME);
        Modulus modulus = (Modulus)modulusBuilder.buildObject(Modulus.DEFAULT_ELEMENT_NAME);
        XMLObjectBuilder exponentBuilder = builderFactory.ensureBuilder(Exponent.DEFAULT_ELEMENT_NAME);
        Exponent exponent = (Exponent)exponentBuilder.buildObject(Exponent.DEFAULT_ELEMENT_NAME);
        modulus.setValueBigInt(rsaPubKey.getModulus());
        rsaKeyValue.setModulus(modulus);
        exponent.setValueBigInt(rsaPubKey.getPublicExponent());
        rsaKeyValue.setExponent(exponent);
        return rsaKeyValue;
    }

    @Nonnull
    public static DSAKeyValue buildDSAKeyValue(@Nonnull DSAPublicKey dsaPubKey) throws EncodingException {
        Constraint.isNotNull((Object)dsaPubKey, (String)"DSA public key cannot be null");
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        XMLObjectBuilder dsaKeyValueBuilder = builderFactory.ensureBuilder(DSAKeyValue.DEFAULT_ELEMENT_NAME);
        DSAKeyValue dsaKeyValue = (DSAKeyValue)dsaKeyValueBuilder.buildObject(DSAKeyValue.DEFAULT_ELEMENT_NAME);
        XMLObjectBuilder yBuilder = builderFactory.ensureBuilder(Y.DEFAULT_ELEMENT_NAME);
        XMLObjectBuilder gBuilder = builderFactory.ensureBuilder(G.DEFAULT_ELEMENT_NAME);
        XMLObjectBuilder pBuilder = builderFactory.ensureBuilder(org.opensaml.xmlsec.signature.P.DEFAULT_ELEMENT_NAME);
        XMLObjectBuilder qBuilder = builderFactory.ensureBuilder(org.opensaml.xmlsec.signature.Q.DEFAULT_ELEMENT_NAME);
        Y y = (Y)yBuilder.buildObject(Y.DEFAULT_ELEMENT_NAME);
        G g = (G)gBuilder.buildObject(G.DEFAULT_ELEMENT_NAME);
        org.opensaml.xmlsec.signature.P p = (org.opensaml.xmlsec.signature.P)pBuilder.buildObject(org.opensaml.xmlsec.signature.P.DEFAULT_ELEMENT_NAME);
        org.opensaml.xmlsec.signature.Q q = (org.opensaml.xmlsec.signature.Q)qBuilder.buildObject(org.opensaml.xmlsec.signature.Q.DEFAULT_ELEMENT_NAME);
        y.setValueBigInt(dsaPubKey.getY());
        dsaKeyValue.setY(y);
        g.setValueBigInt(dsaPubKey.getParams().getG());
        dsaKeyValue.setG(g);
        p.setValueBigInt(dsaPubKey.getParams().getP());
        dsaKeyValue.setP(p);
        q.setValueBigInt(dsaPubKey.getParams().getQ());
        dsaKeyValue.setQ(q);
        return dsaKeyValue;
    }

    public static void addDEREncodedPublicKey(@Nonnull KeyInfo keyInfo, @Nonnull PublicKey pk) throws NoSuchAlgorithmException, InvalidKeySpecException {
        Constraint.isNotNull((Object)keyInfo, (String)"KeyInfo cannot be null");
        Constraint.isNotNull((Object)pk, (String)"Public key cannot be null");
        XMLObjectBuilder builder = XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(DEREncodedKeyValue.DEFAULT_ELEMENT_NAME);
        DEREncodedKeyValue keyValue = (DEREncodedKeyValue)builder.buildObject(DEREncodedKeyValue.DEFAULT_ELEMENT_NAME);
        KeyFactory keyFactory = KeyFactory.getInstance(pk.getAlgorithm());
        X509EncodedKeySpec keySpec = keyFactory.getKeySpec(pk, X509EncodedKeySpec.class);
        try {
            keyValue.setValue(Base64Support.encode((byte[])keySpec.getEncoded(), (boolean)true));
        }
        catch (EncodingException e) {
            throw new InvalidKeySpecException("X509 Key spec could not be base64 encoded", e);
        }
        keyInfo.getDEREncodedKeyValues().add(keyValue);
    }

    @Nonnull
    public static List<PublicKey> getPublicKeys(@Nullable KeyInfo keyInfo) throws KeyException {
        PublicKey newKey;
        LinkedList<PublicKey> keys = new LinkedList<PublicKey>();
        if (keyInfo == null) {
            return keys;
        }
        for (KeyValue keyValue : keyInfo.getKeyValues()) {
            assert (keyValue != null);
            newKey = KeyInfoSupport.getKey(keyValue);
            if (newKey == null) continue;
            keys.add(newKey);
        }
        for (DEREncodedKeyValue dEREncodedKeyValue : keyInfo.getDEREncodedKeyValues()) {
            assert (dEREncodedKeyValue != null);
            newKey = KeyInfoSupport.getKey(dEREncodedKeyValue);
            if (newKey == null) continue;
            keys.add(newKey);
        }
        return keys;
    }

    @Nullable
    public static PublicKey getKey(@Nonnull KeyValue keyValue) throws KeyException {
        Constraint.isNotNull((Object)keyValue, (String)"KeyValue cannot be null");
        DSAKeyValue dsa = keyValue.getDSAKeyValue();
        if (dsa != null) {
            return KeyInfoSupport.getDSAKey(dsa);
        }
        RSAKeyValue rsa = keyValue.getRSAKeyValue();
        if (rsa != null) {
            return KeyInfoSupport.getRSAKey(rsa);
        }
        ECKeyValue ec = keyValue.getECKeyValue();
        if (ec != null) {
            return KeyInfoSupport.getECKey(ec);
        }
        DHKeyValue dh = keyValue.getDHKeyValue();
        if (dh != null) {
            return KeyInfoSupport.getDHKey(dh);
        }
        return null;
    }

    @Nonnull
    public static PublicKey getECKey(@Nonnull ECKeyValue keyDescriptor) throws KeyException {
        String pubval;
        NamedCurve namedCurve = keyDescriptor.getNamedCurve();
        if (namedCurve == null || namedCurve.getURI() == null) {
            throw new KeyException("Only ECKeyValue NamedCurve representation is supported");
        }
        String curveURI = namedCurve.getURI();
        if (curveURI == null) {
            throw new KeyException("Only ECKeyValue NamedCurve representation is supported");
        }
        ECParameterSpec ecParams = ECSupport.getParameterSpecForURI((String)curveURI);
        if (ecParams == null) {
            throw new KeyException("Could not resolve ECParametersSpec for NamedCurve URI: " + curveURI);
        }
        org.opensaml.xmlsec.signature.PublicKey pub = keyDescriptor.getPublicKey();
        String string = pubval = pub != null ? pub.getValue() : null;
        if (pubval == null) {
            throw new KeyException("Could not obtain public key value");
        }
        try {
            ECPoint ecPoint = ECSupport.decodeECPoint((byte[])Base64Support.decode((String)pubval), (EllipticCurve)ecParams.getCurve());
            ECPublicKeySpec keySpec = new ECPublicKeySpec(ecPoint, ecParams);
            return KeyInfoSupport.buildKey(keySpec, "EC");
        }
        catch (DecodingException e) {
            throw new KeyException("Error Base64 decoding ECKeyValue PublicKey ECPoint", e);
        }
    }

    @Nonnull
    public static PublicKey getDHKey(@Nonnull DHKeyValue keyDescriptor) throws KeyException {
        if (!KeyInfoSupport.hasCompleteDHParams(keyDescriptor)) {
            throw new KeyException("DHKeyValue element did not contain at least one of DH parameters P, Q or G");
        }
        Generator gen = keyDescriptor.getGenerator();
        P pComp = keyDescriptor.getP();
        Public pub = keyDescriptor.getPublic();
        assert (gen != null);
        assert (pComp != null);
        BigInteger gComponent = gen.getValueBigInt();
        BigInteger pComponent = pComp.getValueBigInt();
        BigInteger publicComponent = pub != null ? pub.getValueBigInt() : null;
        DHPublicKeySpec keySpec = new DHPublicKeySpec(publicComponent, pComponent, gComponent);
        return KeyInfoSupport.buildKey(keySpec, "DiffieHellman");
    }

    public static boolean hasCompleteDHParams(@Nullable DHKeyValue keyDescriptor) {
        if (keyDescriptor == null) {
            return false;
        }
        Generator gen = keyDescriptor.getGenerator();
        P pComp = keyDescriptor.getP();
        return gen != null && !Strings.isNullOrEmpty((String)gen.getValue()) && pComp != null && !Strings.isNullOrEmpty((String)pComp.getValue());
    }

    @Nonnull
    public static PublicKey getDSAKey(@Nonnull DSAKeyValue keyDescriptor) throws KeyException {
        if (!KeyInfoSupport.hasCompleteDSAParams(keyDescriptor)) {
            throw new KeyException("DSAKeyValue element did not contain at least one of DSA parameters P, Q or G");
        }
        G gComp = keyDescriptor.getG();
        org.opensaml.xmlsec.signature.P pComp = keyDescriptor.getP();
        org.opensaml.xmlsec.signature.Q qComp = keyDescriptor.getQ();
        assert (gComp != null);
        assert (pComp != null);
        assert (qComp != null);
        BigInteger gComponent = gComp.getValueBigInt();
        BigInteger pComponent = pComp.getValueBigInt();
        BigInteger qComponent = qComp.getValueBigInt();
        DSAParameterSpec dsaParams = new DSAParameterSpec(pComponent, qComponent, gComponent);
        return KeyInfoSupport.getDSAKey(keyDescriptor, dsaParams);
    }

    @Nonnull
    public static PublicKey getDSAKey(@Nonnull DSAKeyValue keyDescriptor, @Nonnull DSAParams dsaParams) throws KeyException {
        Constraint.isNotNull((Object)keyDescriptor, (String)"DSAKeyValue cannot be null");
        Constraint.isNotNull((Object)dsaParams, (String)"DSAParams cannot be null");
        Y yComponent = keyDescriptor.getY();
        DSAPublicKeySpec keySpec = new DSAPublicKeySpec(yComponent != null ? yComponent.getValueBigInt() : null, dsaParams.getP(), dsaParams.getQ(), dsaParams.getG());
        return KeyInfoSupport.buildKey(keySpec, "DSA");
    }

    public static boolean hasCompleteDSAParams(@Nullable DSAKeyValue keyDescriptor) {
        if (keyDescriptor == null) {
            return false;
        }
        G gComp = keyDescriptor.getG();
        org.opensaml.xmlsec.signature.P pComp = keyDescriptor.getP();
        org.opensaml.xmlsec.signature.Q qComp = keyDescriptor.getQ();
        return gComp != null && !Strings.isNullOrEmpty((String)gComp.getValue()) && pComp != null && !Strings.isNullOrEmpty((String)pComp.getValue()) && qComp != null && !Strings.isNullOrEmpty((String)qComp.getValue());
    }

    @Nonnull
    public static PublicKey getRSAKey(@Nonnull RSAKeyValue keyDescriptor) throws KeyException {
        Constraint.isNotNull((Object)keyDescriptor, (String)"RSAKeyValue cannot be null");
        Modulus mod = keyDescriptor.getModulus();
        Exponent exp = keyDescriptor.getExponent();
        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(mod != null ? mod.getValueBigInt() : null, exp != null ? exp.getValueBigInt() : null);
        return KeyInfoSupport.buildKey(keySpec, "RSA");
    }

    @Nonnull
    public static final BigInteger decodeBigIntegerFromCryptoBinary(@Nonnull String base64Value) throws DecodingException {
        return new BigInteger(1, Base64Support.decode((String)base64Value));
    }

    @Nonnull
    @NotEmpty
    public static final String encodeCryptoBinaryFromBigInteger(@Nonnull BigInteger bigInt) throws EncodingException {
        Constraint.isNotNull((Object)bigInt, (String)"BigInteger cannot be null");
        byte[] bigIntBytes = XMLUtils.getBytes((BigInteger)bigInt, (int)bigInt.bitLength());
        return Base64Support.encode((byte[])bigIntBytes, (boolean)false);
    }

    @Nonnull
    protected static PublicKey buildKey(@Nonnull KeySpec keySpec, @Nonnull String keyAlgorithm) throws KeyException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(keyAlgorithm);
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            String msg = keyAlgorithm + " algorithm is not supported by this JCE";
            LOG.error(msg + ": {}", (Object)e.getMessage());
            throw new KeyException(msg, e);
        }
        catch (InvalidKeySpecException e) {
            LOG.error("Invalid key information: {}", (Object)e.getMessage());
            throw new KeyException("Invalid key information", e);
        }
    }

    @Nonnull
    public static PublicKey getKey(@Nonnull DEREncodedKeyValue keyValue) throws KeyException {
        String[] keyTypes;
        String[] stringArray;
        String[] supportedKeyTypes = new String[]{"RSA", "EC", "DiffieHellman", "DSA"};
        Constraint.isNotNull((Object)keyValue, (String)"DEREncodedKeyValue cannot be null");
        String keyValueValue = keyValue.getValue();
        if (keyValueValue == null) {
            throw new KeyException("No data found in key value element");
        }
        byte[] encodedKey = null;
        try {
            encodedKey = Base64Support.decode((String)keyValueValue);
        }
        catch (DecodingException e) {
            throw new KeyException("DEREncodedKeyValue could not be base64 decoded", e);
        }
        String parsedKeyType = KeyInfoSupport.parseKeyType(encodedKey);
        if (parsedKeyType != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = parsedKeyType;
        } else {
            stringArray = supportedKeyTypes;
        }
        for (String keyType : keyTypes = stringArray) {
            LOG.trace("Attempting to decode DER key as type: {}", (Object)keyType);
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(keyType);
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encodedKey);
                PublicKey publicKey = keyFactory.generatePublic(keySpec);
                if (publicKey == null) continue;
                LOG.trace("DER key decoded successfully as type: {}", (Object)keyType);
                return publicKey;
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                LOG.trace("DER key failed decoding as: {}", (Object)keyType);
            }
        }
        throw new KeyException("DEREncodedKeyValue did not contain a supported key type");
    }

    private static String parseKeyType(@Nonnull byte[] encodedKey) {
        String string;
        ASN1InputStream input = new ASN1InputStream(encodedKey);
        try {
            SubjectPublicKeyInfo spki = SubjectPublicKeyInfo.getInstance((Object)input.readObject());
            String keyTypeOID = spki.getAlgorithm().getAlgorithm().getId();
            LOG.debug("Parsed key type OID: {}", (Object)keyTypeOID);
            String parsedKeyType = null;
            switch (keyTypeOID) {
                case "1.2.840.113549.1.1.1": {
                    parsedKeyType = "RSA";
                    break;
                }
                case "1.2.840.10045.2.1": {
                    parsedKeyType = "EC";
                    break;
                }
                case "1.2.840.10040.4.1": {
                    parsedKeyType = "DSA";
                    break;
                }
                case "1.2.840.10046.2.1": 
                case "1.2.840.113549.1.3.1": {
                    parsedKeyType = "DiffieHellman";
                    break;
                }
                default: {
                    parsedKeyType = null;
                }
            }
            LOG.debug("Parsed key type: {}", (Object)parsedKeyType);
            string = parsedKeyType;
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.warn("Error parsing encoded key, can not determine key type", (Throwable)e);
                return null;
            }
        }
        input.close();
        return string;
    }

    @Nonnull
    protected static CertificateFactory getX509CertFactory() throws CertificateException {
        if (x509CertFactory == null) {
            x509CertFactory = CertificateFactory.getInstance("X.509");
        }
        assert (x509CertFactory != null);
        return x509CertFactory;
    }

    @Nullable
    public static KeyInfoGenerator getKeyInfoGenerator(@Nonnull Credential credential, @Nonnull NamedKeyInfoGeneratorManager manager, @Nullable String keyInfoProfileName) {
        Constraint.isNotNull((Object)credential, (String)"Credential may not be null");
        Constraint.isNotNull((Object)manager, (String)"NamedKeyInfoGeneratorManager may not be null");
        KeyInfoGeneratorFactory factory = null;
        if (keyInfoProfileName != null) {
            LOG.trace("Resolving KeyInfoGeneratorFactory using profile name: {}", (Object)keyInfoProfileName);
            factory = manager.getFactory(keyInfoProfileName, credential);
        } else {
            LOG.trace("Resolving KeyInfoGeneratorFactory using default manager: {}", (Object)keyInfoProfileName);
            factory = manager.getDefaultManager().getFactory(credential);
        }
        if (factory != null) {
            LOG.trace("Found KeyInfoGeneratorFactory: {}", (Object)factory.getClass().getName());
            return factory.newInstance();
        }
        LOG.trace("Unable to resolve KeyInfoGeneratorFactory for credential");
        return null;
    }
}

