/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.policy;

import org.apache.activemq.ActiveMQMessageAudit;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.policy.AbstractDeadLetterStrategy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.Message;

public class SharedDeadLetterStrategy
extends AbstractDeadLetterStrategy {
    public static final String DEFAULT_DEAD_LETTER_QUEUE_NAME = "ActiveMQ.DLQ";
    private ActiveMQDestination deadLetterQueue = new ActiveMQQueue("ActiveMQ.DLQ");
    private final ActiveMQMessageAudit messageAudit = new ActiveMQMessageAudit();

    @Override
    public ActiveMQDestination getDeadLetterQueueFor(Message message, Subscription subscription) {
        return this.deadLetterQueue;
    }

    public ActiveMQDestination getDeadLetterQueue() {
        return this.deadLetterQueue;
    }

    public void setDeadLetterQueue(ActiveMQDestination deadLetterQueue) {
        this.deadLetterQueue = deadLetterQueue;
    }

    @Override
    public int getMaxProducersToAudit() {
        return this.messageAudit.getMaximumNumberOfProducersToTrack();
    }

    @Override
    public void setMaxProducersToAudit(int maxProducersToAudit) {
        this.messageAudit.setMaximumNumberOfProducersToTrack(maxProducersToAudit);
    }

    @Override
    public void setMaxAuditDepth(int maxAuditDepth) {
        this.messageAudit.setAuditDepth(maxAuditDepth);
    }

    @Override
    public int getMaxAuditDepth() {
        return this.messageAudit.getAuditDepth();
    }

    @Override
    protected ActiveMQMessageAudit lookupActiveMQMessageAudit(Message message, boolean rollback) {
        return this.messageAudit;
    }
}

