/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.context.creational;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class BeanInstanceBag<T>
implements Serializable {
    private static final long serialVersionUID = 1656996021599122499L;
    private final CreationalContext<T> beanCreationalContext;
    private T beanInstance;
    private final Lock lock = new ReentrantLock();

    public BeanInstanceBag(CreationalContext<T> beanCreationalContext) {
        this.beanCreationalContext = beanCreationalContext;
    }

    public CreationalContext<T> getBeanCreationalContext() {
        return this.beanCreationalContext;
    }

    public T getBeanInstance() {
        return this.beanInstance;
    }

    public T create(Contextual<T> contextual) {
        try {
            this.lock.lock();
            if (this.beanInstance == null) {
                this.beanInstance = contextual.create(this.beanCreationalContext);
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.beanInstance;
    }

    public String toString() {
        return "Bag:" + this.beanCreationalContext + ", Instance: " + this.beanInstance;
    }
}

