/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory.partition;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import thredds.filesystem.MFileOS7;
import thredds.inventory.CollectionAbstract;
import thredds.inventory.MFile;
import ucar.nc2.util.CloseableIterator;

public class DirectoryCollection
extends CollectionAbstract {
    final String topCollection;
    final Path topDir;
    final long lastModifiedTime;
    private static final boolean debug = false;

    public static String makeCollectionName(String topCollectionName, Path dir) {
        int last = dir.getNameCount() - 1;
        Path lastDir = dir.getName(last);
        String lastDirName = lastDir.toString();
        return topCollectionName + "-" + lastDirName;
    }

    public static Path makeCollectionIndexPath(String topCollectionName, Path dir) {
        String collectionName = DirectoryCollection.makeCollectionName(topCollectionName, dir);
        return Paths.get(dir.toString(), collectionName + ".ncx2");
    }

    public DirectoryCollection(String topCollectionName, String topDirS, String olderThan, Logger logger) {
        this(topCollectionName, Paths.get(topDirS, new String[0]), olderThan, logger);
    }

    public DirectoryCollection(String topCollectionName, Path topDir, String olderThan, Logger logger) {
        super(topCollectionName, logger);
        this.topCollection = DirectoryCollection.cleanName(topCollectionName);
        this.topDir = topDir;
        this.collectionName = DirectoryCollection.makeCollectionName(this.collectionName, topDir);
        this.lastModifiedTime = this.parseOlderThanString(olderThan);
    }

    public Path getIndexPath() {
        return DirectoryCollection.makeCollectionIndexPath(this.topCollection, this.topDir);
    }

    public boolean isLeafDirectory() throws IOException {
        int countDir = 0;
        int countFile = 0;
        int count = 0;
        try (CloseableIterator<MFile> iter = this.getFileIterator();){
            while (iter.hasNext() && count++ < 100) {
                MFile file = (MFile)iter.next();
                if (file.isDirectory()) {
                    ++countDir;
                    continue;
                }
                ++countFile;
            }
        }
        return countFile > countDir;
    }

    @Override
    public String getRoot() {
        return this.topDir.toString();
    }

    @Override
    public String getIndexFilename() {
        return this.getIndexPath().toString();
    }

    @Override
    public Iterable<MFile> getFilesSorted() throws IOException {
        return this.makeFileListSorted();
    }

    @Override
    public CloseableIterator<MFile> getFileIterator() throws IOException {
        return new MyFileIterator(this.topDir);
    }

    @Override
    public void close() {
    }

    public void iterateOverMFileCollection(Visitor visit) throws IOException {
        boolean count = false;
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(this.topDir, new CollectionAbstract.MyGribFilter(this));){
            for (Path p : ds) {
                BasicFileAttributes attr = Files.readAttributes(p, BasicFileAttributes.class, new LinkOption[0]);
                if (attr.isDirectory()) continue;
                visit.consume(new MFileOS7(p));
            }
        }
    }

    public static interface Visitor {
        public void consume(MFile var1);
    }

    private class MyFileIterator
    implements CloseableIterator<MFile> {
        DirectoryStream<Path> dirStream;
        Iterator<Path> dirStreamIterator;
        MFile nextMFile;
        int count = 0;

        MyFileIterator(Path dir) throws IOException {
            this.dirStream = Files.newDirectoryStream(dir, new CollectionAbstract.MyGribFilter(DirectoryCollection.this));
            this.dirStreamIterator = this.dirStream.iterator();
        }

        @Override
        public boolean hasNext() {
            while (true) {
                ++this.count;
                if (!this.dirStreamIterator.hasNext()) {
                    this.nextMFile = null;
                    return false;
                }
                long now = System.currentTimeMillis();
                try {
                    long since;
                    Path nextPath = this.dirStreamIterator.next();
                    BasicFileAttributes attr = Files.readAttributes(nextPath, BasicFileAttributes.class, new LinkOption[0]);
                    if (attr.isDirectory() || (since = now - attr.lastModifiedTime().toMillis()) < DirectoryCollection.this.lastModifiedTime) continue;
                    this.nextMFile = new MFileOS7(nextPath, attr);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (DirectoryCollection.this.filter == null || DirectoryCollection.this.filter.accept(this.nextMFile)) break;
            }
            return true;
        }

        @Override
        public MFile next() {
            if (this.nextMFile == null) {
                throw new NoSuchElementException();
            }
            return this.nextMFile;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            this.dirStream.close();
        }
    }
}

