/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.resource;

import java.io.Serializable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Tests$;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.SparkListenerResourceProfileAdded;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Evolving
@ScalaSignature(bytes="\u0006\u0001\u0005}c!\u0002\u0010 \u0001\u0005:\u0003\u0002\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\t\u0011i\u0002!\u0011!Q\u0001\nmBQ!\u0011\u0001\u0005\u0002\tCqa\u0012\u0001C\u0002\u0013%\u0001\n\u0003\u0004X\u0001\u0001\u0006I!\u0013\u0005\u000b1\u0002\u0001\n\u0011aA!\u0002\u0013I\u0006bB7\u0001\u0005\u0004%IA\u001c\u0005\u0007_\u0002\u0001\u000b\u0011\u0002/\t\u000fA\u0004!\u0019!C\u0005c\"1!\u000f\u0001Q\u0001\n)Dqa\u001d\u0001C\u0002\u0013%A\u000f\u0003\u0004v\u0001\u0001\u0006I\u0001\u0016\u0005\u0006m\u0002!\t\u0001\u001e\u0005\bo\u0002\u0011\r\u0011\"\u0003y\u0011\u0019a\b\u0001)A\u0005s\"9Q\u0010\u0001b\u0001\n\u0013q\bbBA\u000e\u0001\u0001\u0006Ia \u0005\t\u0003;\u0001!\u0019!C\u0005q\"9\u0011q\u0004\u0001!\u0002\u0013I\b\u0002CA\u0011\u0001\t\u0007I\u0011\u0002=\t\u000f\u0005\r\u0002\u0001)A\u0005s\"A\u0011Q\u0005\u0001C\u0002\u0013%\u0001\u0010C\u0004\u0002(\u0001\u0001\u000b\u0011B=\t\u0011\u0005%\u0002A1A\u0005\naDq!a\u000b\u0001A\u0003%\u0011\u0010\u0003\u0005\u0002.\u0001!\t!IA\u0018\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!!\u0011\u0001\t\u0003\t\u0019\u0005C\u0004\u0002J\u0001!\t!a\u0013\u0003-I+7o\\;sG\u0016\u0004&o\u001c4jY\u0016l\u0015M\\1hKJT!\u0001I\u0011\u0002\u0011I,7o\\;sG\u0016T!AI\u0012\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0011*\u0013AB1qC\u000eDWMC\u0001'\u0003\ry'oZ\n\u0004\u0001!r\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#AB!osJ+g\r\u0005\u00020e5\t\u0001G\u0003\u00022C\u0005A\u0011N\u001c;fe:\fG.\u0003\u00024a\t9Aj\\4hS:<\u0017!C:qCJ\\7i\u001c8g\u0007\u0001\u0001\"a\u000e\u001d\u000e\u0003\u0005J!!O\u0011\u0003\u0013M\u0003\u0018M]6D_:4\u0017a\u00037jgR,g.\u001a:CkN\u0004\"\u0001P \u000e\u0003uR!AP\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\u0018B\u0001!>\u0005=a\u0015N^3MSN$XM\\3s\u0005V\u001c\u0018A\u0002\u001fj]&$h\bF\u0002D\u000b\u001a\u0003\"\u0001\u0012\u0001\u000e\u0003}AQ\u0001N\u0002A\u0002YBQAO\u0002A\u0002m\n!E]3t_V\u00148-\u001a)s_\u001aLG.Z%e)>\u0014Vm]8ve\u000e,\u0007K]8gS2,W#A%\u0011\t){\u0015\u000bV\u0007\u0002\u0017*\u0011A*T\u0001\b[V$\u0018M\u00197f\u0015\tq%&\u0001\u0006d_2dWm\u0019;j_:L!\u0001U&\u0003\u000f!\u000b7\u000f['baB\u0011\u0011FU\u0005\u0003'*\u00121!\u00138u!\t!U+\u0003\u0002W?\ty!+Z:pkJ\u001cW\r\u0015:pM&dW-A\u0012sKN|WO]2f!J|g-\u001b7f\u0013\u0012$vNU3t_V\u00148-\u001a)s_\u001aLG.\u001a\u0011\u0002\u0007a$\u0013\u0007\u0005\u0003*5rS\u0017BA.+\u0005\u0019!V\u000f\u001d7feA\u0011Q\f[\u0007\u0002=*\u0011q\fY\u0001\u0017%\u0016,g\u000e\u001e:b]R\u0014V-\u00193Xe&$X\rT8dW*\u0011\u0011MY\u0001\u0006Y>\u001c7n\u001d\u0006\u0003G\u0012\f!bY8oGV\u0014(/\u001a8u\u0015\t)g-\u0001\u0003vi&d'\"A4\u0002\t)\fg/Y\u0005\u0003Sz\u0013\u0001BU3bI2{7m\u001b\t\u0003;.L!\u0001\u001c0\u0003\u0013]\u0013\u0018\u000e^3M_\u000e\\\u0017\u0001\u0003:fC\u0012dunY6\u0016\u0003q\u000b\u0011B]3bI2{7m\u001b\u0011\u0002\u0013]\u0014\u0018\u000e^3M_\u000e\\W#\u00016\u0002\u0015]\u0014\u0018\u000e^3M_\u000e\\\u0007%\u0001\beK\u001a\fW\u000f\u001c;Qe>4\u0017\u000e\\3\u0016\u0003Q\u000bq\u0002Z3gCVdG\u000f\u0015:pM&dW\rI\u0001\u0017I\u00164\u0017-\u001e7u%\u0016\u001cx.\u001e:dKB\u0013xNZ5mK\u0006qA-\u001f8b[&\u001cWI\\1cY\u0016$W#A=\u0011\u0005%R\u0018BA>+\u0005\u001d\u0011un\u001c7fC:\fq\u0002Z=oC6L7-\u00128bE2,G\rI\u0001\u0007[\u0006\u001cH/\u001a:\u0016\u0003}\u0004R!KA\u0001\u0003\u000bI1!a\u0001+\u0005\u0019y\u0005\u000f^5p]B!\u0011qAA\u000b\u001d\u0011\tI!!\u0005\u0011\u0007\u0005-!&\u0004\u0002\u0002\u000e)\u0019\u0011qB\u001b\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019BK\u0001\u0007!J,G-\u001a4\n\t\u0005]\u0011\u0011\u0004\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005M!&A\u0004nCN$XM\u001d\u0011\u0002\r%\u001c\u0018,\u0019:o\u0003\u001dI7/W1s]\u0002\nQ![:LqM\fa![:LqM\u0004\u0013a\u00058piJ+hN\\5oOVs\u0017\u000e\u001e+fgR\u001c\u0018\u0001\u00068piJ+hN\\5oOVs\u0017\u000e\u001e+fgR\u001c\b%A\nuKN$X\t_2faRLwN\u001c+ie><h.\u0001\u000buKN$X\t_2faRLwN\u001c+ie><h\u000eI\u0001\fSN\u001cV\u000f\u001d9peR,G\rF\u0002z\u0003cAa!a\r\u001b\u0001\u0004!\u0016A\u0001:q\u0003I\tG\r\u001a*fg>,(oY3Qe>4\u0017\u000e\\3\u0015\t\u0005e\u0012q\b\t\u0004S\u0005m\u0012bAA\u001fU\t!QK\\5u\u0011\u0019\t\u0019d\u0007a\u0001)\u0006)\"/Z:pkJ\u001cW\r\u0015:pM&dWM\u0012:p[&#Gc\u0001+\u0002F!1\u0011q\t\u000fA\u0002E\u000bAA\u001d9JI\u0006!r-\u001a;FcVLg/\u00197f]R\u0004&o\u001c4jY\u0016$B!!\u0014\u0002PA!\u0011&!\u0001U\u0011\u0019\t\u0019$\ba\u0001)\"\u001a\u0001!a\u0015\u0011\t\u0005U\u00131L\u0007\u0003\u0003/R1!!\u0017\"\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003;\n9F\u0001\u0005Fm>dg/\u001b8h\u0001")
public class ResourceProfileManager
implements Logging {
    private final SparkConf sparkConf;
    private final LiveListenerBus listenerBus;
    private final HashMap<Object, ResourceProfile> resourceProfileIdToResourceProfile;
    private final /* synthetic */ Tuple2 x$1;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final ResourceProfile defaultProfile;
    private final boolean dynamicEnabled;
    private final Option<String> master;
    private final boolean isYarn;
    private final boolean isK8s;
    private final boolean notRunningUnitTests;
    private final boolean testExceptionThrown;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private HashMap<Object, ResourceProfile> resourceProfileIdToResourceProfile() {
        return this.resourceProfileIdToResourceProfile;
    }

    private ReentrantReadWriteLock.ReadLock readLock() {
        return this.readLock;
    }

    private ReentrantReadWriteLock.WriteLock writeLock() {
        return this.writeLock;
    }

    private ResourceProfile defaultProfile() {
        return this.defaultProfile;
    }

    public ResourceProfile defaultResourceProfile() {
        return this.defaultProfile();
    }

    private boolean dynamicEnabled() {
        return this.dynamicEnabled;
    }

    private Option<String> master() {
        return this.master;
    }

    private boolean isYarn() {
        return this.isYarn;
    }

    private boolean isK8s() {
        return this.isK8s;
    }

    private boolean notRunningUnitTests() {
        return this.notRunningUnitTests;
    }

    private boolean testExceptionThrown() {
        return this.testExceptionThrown;
    }

    public boolean isSupported(ResourceProfile rp) {
        boolean YarnOrK8sNotDynAllocAndNotDefaultProfile;
        boolean isNotDefaultProfile = rp.id() != ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID();
        boolean notYarnOrK8sAndNotDefaultProfile = isNotDefaultProfile && !this.isYarn() && !this.isK8s();
        boolean bl = YarnOrK8sNotDynAllocAndNotDefaultProfile = isNotDefaultProfile && (this.isYarn() || this.isK8s()) && !this.dynamicEnabled();
        if ((this.notRunningUnitTests() || this.testExceptionThrown()) && (notYarnOrK8sAndNotDefaultProfile || YarnOrK8sNotDynAllocAndNotDefaultProfile)) {
            throw new SparkException("ResourceProfiles are only supported on YARN and Kubernetes with dynamic allocation enabled.");
        }
        return true;
    }

    public void addResourceProfile(ResourceProfile rp) {
        block5: {
            this.isSupported(rp);
            boolean putNewProfile = false;
            this.writeLock().lock();
            try {
                Option prev;
                if (!this.resourceProfileIdToResourceProfile().contains((Object)BoxesRunTime.boxToInteger((int)rp.id())) && (prev = this.resourceProfileIdToResourceProfile().put((Object)BoxesRunTime.boxToInteger((int)rp.id()), (Object)rp)).isEmpty()) {
                    putNewProfile = true;
                }
            }
            finally {
                this.writeLock().unlock();
            }
            if (!putNewProfile) break block5;
            rp.limitingResource(this.sparkConf);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Added ResourceProfile id: ").append(rp.id()).toString());
            this.listenerBus.post(new SparkListenerResourceProfileAdded(rp));
        }
    }

    public ResourceProfile resourceProfileFromId(int rpId) {
        ResourceProfile resourceProfile;
        this.readLock().lock();
        try {
            resourceProfile = (ResourceProfile)this.resourceProfileIdToResourceProfile().getOrElse((Object)BoxesRunTime.boxToInteger((int)rpId), (Function0 & Serializable & scala.Serializable)() -> {
                throw new SparkException(new StringBuilder(29).append("ResourceProfileId ").append(rpId).append(" not found!").toString());
            });
        }
        finally {
            this.readLock().unlock();
        }
        return resourceProfile;
    }

    public Option<ResourceProfile> getEquivalentProfile(ResourceProfile rp) {
        Option option;
        this.readLock().lock();
        try {
            option = this.resourceProfileIdToResourceProfile().find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ResourceProfileManager.$anonfun$getEquivalentProfile$1(rp, x0$1))).map((Function1 & Serializable & scala.Serializable)x$2 -> (ResourceProfile)x$2._2());
        }
        finally {
            this.readLock().unlock();
        }
        return option;
    }

    public static final /* synthetic */ boolean $anonfun$getEquivalentProfile$1(ResourceProfile rp$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ResourceProfile rpEntry = (ResourceProfile)tuple2._2();
        boolean bl = rpEntry.resourcesEqual(rp$2);
        return bl;
    }

    public ResourceProfileManager(SparkConf sparkConf, LiveListenerBus listenerBus) {
        this.sparkConf = sparkConf;
        this.listenerBus = listenerBus;
        Logging.$init$(this);
        this.resourceProfileIdToResourceProfile = new HashMap();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Tuple2 tuple2 = new Tuple2((Object)lock.readLock(), (Object)lock.writeLock());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ReentrantReadWriteLock.ReadLock readLock = (ReentrantReadWriteLock.ReadLock)tuple2._1();
        ReentrantReadWriteLock.WriteLock writeLock = (ReentrantReadWriteLock.WriteLock)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)readLock, (Object)writeLock);
        this.x$1 = tuple22;
        this.readLock = (ReentrantReadWriteLock.ReadLock)this.x$1._1();
        this.writeLock = (ReentrantReadWriteLock.WriteLock)this.x$1._2();
        this.defaultProfile = ResourceProfile$.MODULE$.getOrCreateDefaultProfile(sparkConf);
        this.addResourceProfile(this.defaultProfile());
        this.dynamicEnabled = Utils$.MODULE$.isDynamicAllocationEnabled(sparkConf);
        this.master = sparkConf.getOption("spark.master");
        this.isYarn = this.master().isDefined() && ((String)this.master().get()).equals("yarn");
        this.isK8s = this.master().isDefined() && ((String)this.master().get()).startsWith("k8s://");
        this.notRunningUnitTests = !Utils$.MODULE$.isTesting();
        this.testExceptionThrown = BoxesRunTime.unboxToBoolean((Object)sparkConf.get(Tests$.MODULE$.RESOURCE_PROFILE_MANAGER_TESTING()));
    }
}

