/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.redirect;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.client.Protocol;
import org.pac4j.cas.client.CasClient;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.config.CasProtocol;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.redirect.RedirectionActionBuilder;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasRedirectionActionBuilder
implements RedirectionActionBuilder {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasRedirectionActionBuilder.class);
    protected CasConfiguration configuration;
    protected CasClient client;

    public CasRedirectionActionBuilder(CasConfiguration configuration, CasClient client) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)configuration));
        CommonHelper.assertNotNull((String)"client", (Object)((Object)client));
        this.configuration = configuration;
        this.client = client;
    }

    public Optional<RedirectionAction> getRedirectionAction(CallContext ctx) {
        WebContext webContext = ctx.webContext();
        String computeLoginUrl = this.configuration.computeFinalLoginUrl(webContext);
        String computedCallbackUrl = this.client.computeFinalCallbackUrl(webContext);
        boolean renew = this.configuration.isRenew() || webContext.getRequestAttribute("ForceAuthn").isPresent();
        boolean gateway = this.configuration.isGateway() || webContext.getRequestAttribute("Passive").isPresent();
        String redirectionUrl = CasRedirectionActionBuilder.constructRedirectUrl(computeLoginUrl, this.getServiceParameter(), computedCallbackUrl, renew, gateway, this.configuration.getMethod());
        LOGGER.debug("redirectionUrl: {}", (Object)redirectionUrl);
        return Optional.of(HttpActionHelper.buildRedirectUrlAction((WebContext)webContext, (String)redirectionUrl));
    }

    protected String getServiceParameter() {
        if (this.configuration.getProtocol() == CasProtocol.SAML) {
            return Protocol.SAML11.getServiceParameterName();
        }
        return "service";
    }

    public static String constructRedirectUrl(String casServerLoginUrl, String serviceParameterName, String serviceUrl, boolean renew, boolean gateway, String method) {
        return casServerLoginUrl + (casServerLoginUrl.contains("?") ? "&" : "?") + serviceParameterName + "=" + CommonHelper.urlEncode((String)serviceUrl) + (renew ? "&renew=true" : "") + (gateway ? "&gateway=true" : "") + (String)(method != null ? "&method=" + method : "");
    }
}

