/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldap.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import net.tirasa.connid.bundles.ldap.LdapConnection;
import net.tirasa.connid.bundles.ldap.commons.LdapEntry;
import net.tirasa.connid.bundles.ldap.commons.LdapUtil;
import net.tirasa.connid.bundles.ldap.search.LdapFilter;
import net.tirasa.connid.bundles.ldap.search.LdapFilterTranslator;
import net.tirasa.connid.bundles.ldap.search.LdapInternalSearch;
import net.tirasa.connid.bundles.ldap.search.LdapSearch;
import net.tirasa.connid.bundles.ldap.search.LdapSearchResultsHandler;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.UnknownUidException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.FilterBuilder;

public final class LdapSearches {
    private static final Log LOG = Log.getLog(LdapSearches.class);

    private LdapSearches() {
    }

    public static String getEntryDN(LdapConnection conn, ObjectClass oclass, Uid uid) {
        return LdapSearches.findEntryDN(conn, oclass, uid, true, false);
    }

    public static String getEntryDN(LdapConnection conn, ObjectClass oclass, Uid uid, boolean ignoreCustomAnyObjectConfig) {
        return LdapSearches.findEntryDN(conn, oclass, uid, true, ignoreCustomAnyObjectConfig);
    }

    public static String findEntryDN(LdapConnection conn, ObjectClass oclass, Uid uid) {
        return LdapSearches.findEntryDN(conn, oclass, uid, false, false);
    }

    public static String findEntryDN(LdapConnection conn, ObjectClass oclass, Uid uid, boolean ignoreCustomAnyObjectConfig) {
        return LdapSearches.findEntryDN(conn, oclass, uid, false, ignoreCustomAnyObjectConfig);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static String findEntryDN(LdapConnection conn, ObjectClass oclass, Uid uid, boolean check, boolean ignoreCustomAnyObjectConfig) {
        LdapFilter ldapFilter;
        LOG.ok("Searching for object {0} of class {1}", new Object[]{uid.getUidValue(), oclass.getObjectClassValue()});
        String uidAttr = conn.getSchema().getLdapUidAttribute(oclass);
        if (LdapEntry.isDNAttribute(uidAttr)) {
            if (!check) return uid.getUidValue();
            ldapFilter = LdapFilter.forEntryDN(uid.getUidValue());
        } else {
            EqualsFilter filter = (EqualsFilter)FilterBuilder.equalTo((Attribute)uid);
            ldapFilter = new LdapFilterTranslator(conn.getSchema(), oclass).createEqualsExpression(filter, false);
        }
        assert (ldapFilter != null);
        OperationOptionsBuilder builder = new OperationOptionsBuilder();
        builder.setAttributesToGet(new String[]{conn.getConfiguration().getDnAttribute()});
        builder.setOption("IGNORE_CUSTOM_ANY_OBJECT_CONFIG", (Object)ignoreCustomAnyObjectConfig);
        LdapSearch search = new LdapSearch(conn, oclass, ldapFilter, null, builder.build());
        ConnectorObject object = search.getSingleResult();
        if (object == null) throw new UnknownUidException(uid, oclass);
        return AttributeUtil.getStringValue((Attribute)object.getAttributeByName(conn.getConfiguration().getDnAttribute()));
    }

    public static List<ConnectorObject> findObjects(LdapConnection conn, ObjectClass oclass, String baseDN, Attribute attr, String ... attrsToGet) {
        LOG.ok("Searching for object with attribute {0} of class {1} in {2}", new Object[]{attr, oclass.getObjectClassValue(), baseDN});
        final ArrayList<ConnectorObject> result = new ArrayList<ConnectorObject>();
        EqualsFilter filter = (EqualsFilter)FilterBuilder.equalTo((Attribute)attr);
        LdapFilter ldapFilter = new LdapFilterTranslator(conn.getSchema(), oclass).createEqualsExpression(filter, false);
        OperationOptionsBuilder builder = new OperationOptionsBuilder();
        builder.setAttributesToGet(attrsToGet);
        LdapSearch search = new LdapSearch(conn, oclass, ldapFilter, new ResultsHandler(){

            public boolean handle(ConnectorObject object) {
                result.add(object);
                return true;
            }
        }, builder.build(), baseDN);
        search.execute();
        return result;
    }

    public static ConnectorObject findObject(LdapConnection conn, ObjectClass oclass, LdapFilter filter, String ... attrsToGet) {
        LOG.ok("Searching for object of class {0} with filter {1}", new Object[]{oclass.getObjectClassValue(), filter});
        OperationOptionsBuilder builder = new OperationOptionsBuilder();
        builder.setAttributesToGet(attrsToGet);
        LdapSearch search = new LdapSearch(conn, oclass, filter, null, builder.build());
        return search.getSingleResult();
    }

    public static LdapEntry getEntry(LdapConnection conn, LdapName entryDN, String ... ldapAttrsToGet) {
        LOG.ok("Searching for entry {0}", new Object[]{entryDN});
        final ArrayList result = new ArrayList();
        if (!LdapUtil.isUnderContexts(entryDN, conn.getConfiguration().getBaseContextsAsLdapNames())) {
            return null;
        }
        SearchControls controls = LdapInternalSearch.createDefaultSearchControls();
        controls.setSearchScope(0);
        controls.setReturningAttributes(ldapAttrsToGet);
        LdapInternalSearch search = new LdapInternalSearch(conn, null, Collections.singletonList(entryDN.toString()), conn.getConfiguration().newDefaultSearchStrategy(true), controls);
        search.execute(new LdapSearchResultsHandler(){

            @Override
            public boolean handle(String baseDN, SearchResult searchResult) {
                result.add(LdapEntry.create(baseDN, searchResult));
                return false;
            }
        });
        if (!result.isEmpty()) {
            return (LdapEntry)result.get(0);
        }
        throw new ConnectorException(conn.format("entryNotFound", null, entryDN));
    }

    public static void findEntries(LdapSearchResultsHandler handler, LdapConnection conn, String filter, String ... ldapAttrsToGet) {
        LOG.ok("Searching for entries matching {0}", new Object[]{filter});
        List<String> baseDNs = Arrays.asList(conn.getConfiguration().getBaseContexts());
        SearchControls controls = LdapInternalSearch.createDefaultSearchControls();
        controls.setSearchScope(2);
        controls.setReturningAttributes(ldapAttrsToGet);
        LdapInternalSearch search = new LdapInternalSearch(conn, filter, baseDNs, conn.getConfiguration().newDefaultSearchStrategy(false), controls);
        search.execute(handler);
    }
}

