/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.mfa.trigger;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderAbsentException;
import org.apereo.cas.authentication.MultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceMultifactorPolicy;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.nativex.CasRuntimeHintsRegistrar;
import org.apereo.cas.util.scripting.ExecutableCompiledScript;
import org.apereo.cas.util.scripting.ExecutableCompiledScriptFactory;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public class ScriptedRegisteredServiceMultifactorAuthenticationTrigger
implements MultifactorAuthenticationTrigger {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptedRegisteredServiceMultifactorAuthenticationTrigger.class);
    private final CasConfigurationProperties casProperties;
    private final ApplicationContext applicationContext;
    private final TenantExtractor tenantExtractor;
    private int order = Integer.MAX_VALUE;

    public Optional<MultifactorAuthenticationProvider> isActivated(Authentication authentication, RegisteredService registeredService, HttpServletRequest httpServletRequest, HttpServletResponse response, Service service) throws Throwable {
        if (authentication == null || registeredService == null) {
            LOGGER.debug("No authentication or service is available to determine event for principal");
            return Optional.empty();
        }
        RegisteredServiceMultifactorPolicy policy = registeredService.getMultifactorAuthenticationPolicy();
        if (policy == null || StringUtils.isBlank((CharSequence)policy.getScript())) {
            LOGGER.trace("Multifactor authentication policy is absent or does not define a script to trigger multifactor authentication");
            return Optional.empty();
        }
        String mfaScript = policy.getScript();
        Map<String, MultifactorAuthenticationProvider> providerMap = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders(this.applicationContext);
        if (providerMap.isEmpty()) {
            LOGGER.error("No multifactor authentication providers are available in the application context");
            throw new AuthenticationException((Throwable)((Object)new MultifactorAuthenticationProviderAbsentException()));
        }
        LOGGER.trace("Locating multifactor authentication trigger script [{}]...", (Object)mfaScript);
        ExecutableCompiledScript executableScript = this.fetchScript(mfaScript);
        if (executableScript != null) {
            LOGGER.debug("Executing multifactor authentication trigger script [{}]", (Object)executableScript);
            String result = (String)executableScript.execute(new Object[]{authentication, registeredService, httpServletRequest, service, this.applicationContext, LOGGER}, String.class);
            LOGGER.debug("Multifactor authentication provider delivered by trigger script is [{}]", (Object)result);
            if (StringUtils.isBlank((CharSequence)result)) {
                LOGGER.debug("No multifactor authentication is returned from trigger script");
                return Optional.empty();
            }
            Optional<MultifactorAuthenticationProvider> providerResult = providerMap.values().stream().filter(provider -> provider.getId().equalsIgnoreCase(result)).findFirst();
            if (providerResult.isEmpty()) {
                LOGGER.error("Unable to locate multifactor authentication provider [{}] in the application context", (Object)result);
                throw new AuthenticationException((Throwable)((Object)new MultifactorAuthenticationProviderAbsentException()));
            }
            return providerResult;
        }
        return Optional.empty();
    }

    protected ExecutableCompiledScript fetchScript(String mfaScript) throws Exception {
        ExecutableCompiledScriptFactory scriptFactory = ExecutableCompiledScriptFactory.getExecutableCompiledScriptFactory();
        if (scriptFactory.isInlineScript(mfaScript) && CasRuntimeHintsRegistrar.notInNativeImage()) {
            return scriptFactory.fromScript((String)scriptFactory.getInlineScript(mfaScript).orElseThrow());
        }
        if (scriptFactory.isExternalScript(mfaScript)) {
            String scriptPath = SpringExpressionLanguageValueResolver.getInstance().resolve((String)scriptFactory.getExternalScript(mfaScript).orElseThrow());
            AbstractResource resource = ResourceUtils.getResourceFrom((String)scriptPath);
            return scriptFactory.fromResource((Resource)resource);
        }
        return null;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }

    @Generated
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Generated
    public TenantExtractor getTenantExtractor() {
        return this.tenantExtractor;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public ScriptedRegisteredServiceMultifactorAuthenticationTrigger(CasConfigurationProperties casProperties, ApplicationContext applicationContext, TenantExtractor tenantExtractor) {
        this.casProperties = casProperties;
        this.applicationContext = applicationContext;
        this.tenantExtractor = tenantExtractor;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }
}

