/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.consent;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.consent.CasConsentableAttribute;
import org.apereo.cas.consent.ConsentDecision;
import org.apereo.cas.consent.ConsentDecisionBuilder;
import org.apereo.cas.consent.ConsentEngine;
import org.apereo.cas.consent.ConsentQueryResult;
import org.apereo.cas.consent.ConsentReminderOptions;
import org.apereo.cas.consent.ConsentRepository;
import org.apereo.cas.consent.ConsentableAttributeBuilder;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class DefaultConsentEngine
implements ConsentEngine {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConsentEngine.class);
    private static final long serialVersionUID = -617809298856160625L;
    private final ConsentRepository consentRepository;
    private final ConsentDecisionBuilder consentDecisionBuilder;
    private final CasConfigurationProperties casProperties;
    private final List<ConsentableAttributeBuilder> consentableAttributeBuilders;
    private final ConfigurableApplicationContext applicationContext;

    @Audit(action="SAVE_CONSENT", actionResolverName="SAVE_CONSENT_ACTION_RESOLVER", resourceResolverName="SAVE_CONSENT_RESOURCE_RESOLVER")
    public ConsentDecision storeConsentDecision(Service service, RegisteredService registeredService, Authentication authentication, long reminder, ChronoUnit reminderTimeUnit, ConsentReminderOptions options) throws Throwable {
        Map<String, List<Object>> attributes = this.resolveConsentableAttributesFrom(authentication, service, registeredService);
        attributes.replaceAll((key, value) -> {
            CasConsentableAttribute attr = CasConsentableAttribute.builder().name(key).values(value).build();
            for (ConsentableAttributeBuilder builder : this.consentableAttributeBuilders) {
                LOGGER.trace("Preparing to build consentable attribute [{}] via [{}]", (Object)attr, (Object)builder.getName());
                attr = builder.build(attr);
                LOGGER.trace("Finalized consentable attribute [{}]", (Object)attr);
            }
            return attr.getValues();
        });
        String principalId = authentication.getPrincipal().getId();
        ConsentDecision decisionFound = this.findConsentDecision(service, registeredService, authentication);
        Supplier supplier = FunctionUtils.doIfNull((Object)decisionFound, () -> this.consentDecisionBuilder.build(service, registeredService, principalId, attributes), () -> this.consentDecisionBuilder.update(decisionFound, attributes));
        ConsentDecision decision = (ConsentDecision)supplier.get();
        decision.setOptions(options);
        decision.setReminder(Long.valueOf(reminder));
        decision.setReminderTimeUnit(reminderTimeUnit);
        return this.consentRepository.storeConsentDecision(decision);
    }

    public ConsentDecision findConsentDecision(Service service, RegisteredService registeredService, Authentication authentication) {
        return this.consentRepository.findConsentDecision(service, registeredService, authentication);
    }

    public Map<String, List<Object>> resolveConsentableAttributesFrom(Authentication authentication, Service service, RegisteredService registeredService) throws Throwable {
        LOGGER.debug("Retrieving consentable attributes for [{}]", (Object)registeredService);
        RegisteredServiceAttributeReleasePolicy policy = registeredService.getAttributeReleasePolicy();
        if (policy != null) {
            RegisteredServiceAttributeReleasePolicyContext context = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService(registeredService).service(service).principal(authentication.getPrincipal()).applicationContext((ApplicationContext)this.applicationContext).build();
            Map consentableAttributes = policy.getConsentableAttributes(context);
            consentableAttributes.entrySet().removeIf(entry -> {
                List excludedAttributes = this.casProperties.getConsent().getCore().getExcludedAttributes();
                return excludedAttributes.contains(entry.getKey());
            });
            return consentableAttributes;
        }
        return new LinkedHashMap<String, List<Object>>();
    }

    public Map<String, List<Object>> resolveConsentableAttributesFrom(ConsentDecision decision) {
        LOGGER.debug("Retrieving consentable attributes from existing decision made by [{}] for [{}]", (Object)decision.getPrincipal(), (Object)decision.getService());
        return this.consentDecisionBuilder.getConsentableAttributesFrom(decision);
    }

    @Audit(action="VERIFY_CONSENT", actionResolverName="VERIFY_CONSENT_ACTION_RESOLVER", resourceResolverName="VERIFY_CONSENT_RESOURCE_RESOLVER")
    public ConsentQueryResult isConsentRequiredFor(Service service, RegisteredService registeredService, Authentication authentication) throws Throwable {
        Map<String, List<Object>> attributes = this.resolveConsentableAttributesFrom(authentication, service, registeredService);
        if (attributes == null || attributes.isEmpty()) {
            LOGGER.debug("Consent is conditionally ignored for service [{}] given no consentable attributes are found", (Object)registeredService.getName());
            return ConsentQueryResult.ignored().withService(service).withAuthentication(authentication);
        }
        LOGGER.debug("Locating consent decision for service [{}]", (Object)service);
        ConsentDecision decision = this.findConsentDecision(service, registeredService, authentication);
        if (decision == null) {
            LOGGER.debug("No consent decision found; thus attribute consent is required");
            return ConsentQueryResult.required().withService(service).withAuthentication(authentication);
        }
        LOGGER.debug("Located consentable attributes for release [{}]", attributes.keySet());
        if (this.consentDecisionBuilder.doesAttributeReleaseRequireConsent(decision, attributes)) {
            LOGGER.debug("Consent is required based on past decision [{}] and attribute release policy for [{}]", (Object)decision, (Object)registeredService.getName());
            return ConsentQueryResult.required().withService(service).withConsentDecision(decision).withAuthentication(authentication);
        }
        LOGGER.debug("Consent is not required yet for [{}]; checking for reminder options", (Object)service);
        ChronoUnit unit = decision.getReminderTimeUnit();
        LocalDateTime dt = decision.getCreatedDate().plus(decision.getReminder(), unit);
        LocalDateTime now = LocalDateTime.now(ZoneId.systemDefault());
        LOGGER.debug("Reminder threshold date/time is calculated as [{}]", (Object)dt);
        if (now.isAfter(dt)) {
            LOGGER.debug("Consent is required based on reminder options given now at [{}] is after [{}]", (Object)now, (Object)dt);
            return ConsentQueryResult.required().withService(service).withConsentDecision(decision).withAuthentication(authentication);
        }
        LOGGER.debug("Consent is not required for service [{}]", (Object)service);
        return ConsentQueryResult.ignored().withService(service).withAuthentication(authentication);
    }

    @Generated
    public DefaultConsentEngine(ConsentRepository consentRepository, ConsentDecisionBuilder consentDecisionBuilder, CasConfigurationProperties casProperties, List<ConsentableAttributeBuilder> consentableAttributeBuilders, ConfigurableApplicationContext applicationContext) {
        this.consentRepository = consentRepository;
        this.consentDecisionBuilder = consentDecisionBuilder;
        this.casProperties = casProperties;
        this.consentableAttributeBuilders = consentableAttributeBuilders;
        this.applicationContext = applicationContext;
    }

    @Generated
    public ConsentRepository getConsentRepository() {
        return this.consentRepository;
    }

    @Generated
    public ConsentDecisionBuilder getConsentDecisionBuilder() {
        return this.consentDecisionBuilder;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }

    @Generated
    public List<ConsentableAttributeBuilder> getConsentableAttributeBuilders() {
        return this.consentableAttributeBuilders;
    }

    @Generated
    public ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

