/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.ext.search.client.CompleteCondition;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.rest.GroupRestClient;
import org.apache.syncope.client.console.rest.SyncopeRestClient;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.wizards.any.AbstractGroups;
import org.apache.syncope.client.ui.commons.wizards.any.AbstractGroupsModel;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.common.lib.search.GroupFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.DynRealmTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.wicket.Component;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.ActionPermissions;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class Groups
extends AbstractGroups {
    private static final long serialVersionUID = 552437609667518888L;
    @SpringBean
    protected GroupRestClient groupRestClient;
    @SpringBean
    protected SyncopeRestClient syncopeRestClient;
    protected final List<DynRealmTO> allDynRealms = new ArrayList<DynRealmTO>();
    protected final boolean templateMode;
    protected final ConsoleGroupsModel groupsModel;
    protected AjaxPalettePanel.Builder<MembershipTO> groups;

    public <T extends AnyTO> Groups(AnyWrapper<T> modelObject, boolean templateMode) {
        super(modelObject);
        this.templateMode = templateMode;
        this.groupsModel = new ConsoleGroupsModel();
        ActionPermissions permissions = new ActionPermissions();
        this.setMetaData(MetaDataRoleAuthorizationStrategy.ACTION_PERMISSIONS, (Serializable)permissions);
        permissions.authorizeAll(RENDER);
        this.addDynamicGroupsContainer();
        this.addGroupsPanel();
        this.addDynamicRealmsContainer();
    }

    protected List<GroupTO> searchAssignable(String term) {
        return this.syncopeRestClient.searchAssignableGroups("/", term, 1, 30);
    }

    protected void addDynamicRealmsContainer() {
        this.dynrealmsContainer = new WebMarkupContainer("dynrealmsContainer");
        this.dynrealmsContainer.setOutputMarkupId(true);
        this.dynrealmsContainer.setOutputMarkupPlaceholderTag(true);
        this.dynrealmsContainer.add(new Component[]{new AjaxPalettePanel.Builder().build("dynrealms", (IModel)new PropertyModel((Object)this.anyTO, "dynRealms"), (IModel)new ListModel(this.allDynRealms.stream().map(DynRealmTO::getKey).collect(Collectors.toList()))).hideLabel().setEnabled(false).setOutputMarkupId(true)});
        this.add(new Component[]{this.dynrealmsContainer});
    }

    protected void addGroupsPanel() {
        if (this.anyTO instanceof GroupTO) {
            this.groupsContainer.add(new Component[]{new Label("groups").setVisible(false)});
            this.groupsContainer.setVisible(false);
            this.dyngroupsContainer.add(new Component[]{new Label("dyngroups").setVisible(false)});
            this.dyngroupsContainer.setVisible(false);
        } else {
            this.groups = new AjaxPalettePanel.Builder().setRenderer((IChoiceRenderer)new IChoiceRenderer<MembershipTO>(){
                private static final long serialVersionUID = -3086661086073628855L;

                public Object getDisplayValue(MembershipTO object) {
                    return object.getGroupName();
                }

                public String getIdValue(MembershipTO object, int index) {
                    return object.getGroupName();
                }

                public MembershipTO getObject(String id, IModel<? extends List<? extends MembershipTO>> choices) {
                    return ((List)choices.getObject()).stream().filter(object -> id.equalsIgnoreCase(object.getGroupName())).findAny().orElse(null);
                }
            });
            this.groupsContainer.add(new Component[]{this.groups.setAllowOrder(true).withFilter("*").build("groups", (IModel)new ListModel<MembershipTO>(){
                private static final long serialVersionUID = -2583290457773357445L;

                public List<MembershipTO> getObject() {
                    return Groups.this.groupsModel.getMemberships();
                }
            }, (AjaxPalettePanel.Builder.Query)new AjaxPalettePanel.Builder.Query<MembershipTO>(){
                private static final long serialVersionUID = -7223078772249308813L;

                public List<MembershipTO> execute(String filter) {
                    return StringUtils.isEmpty((CharSequence)filter) ? List.of() : ("*".equals(filter) ? Groups.this.groupsModel.getObject() : Groups.this.searchAssignable(filter)).stream().map(group -> new MembershipTO.Builder(group.getKey()).groupName(group.getName()).build()).collect(Collectors.toList());
                }
            }).hideLabel().setOutputMarkupId(true)});
            this.dyngroupsContainer.add(new Component[]{new AjaxPalettePanel.Builder().setAllowOrder(true).build("dyngroups", (IModel)new ListModel<String>(){
                private static final long serialVersionUID = -2583290457773357445L;

                public List<String> getObject() {
                    return Groups.this.groupsModel.getDynMemberships();
                }
            }, (IModel)new ListModel(this.groupsModel.getObject().stream().map(GroupTO::getName).collect(Collectors.toList()))).hideLabel().setEnabled(false).setOutputMarkupId(true)});
        }
    }

    protected void addDynamicGroupsContainer() {
        this.dyngroupsContainer = new WebMarkupContainer("dyngroupsContainer");
        this.dyngroupsContainer.setOutputMarkupId(true);
        this.dyngroupsContainer.setOutputMarkupPlaceholderTag(true);
        this.add(new Component[]{this.dyngroupsContainer});
    }

    public boolean evaluate() {
        return (this.anyTO instanceof GroupTO ? !this.allDynRealms.isEmpty() : !this.allDynRealms.isEmpty() || !this.groupsModel.getObject().isEmpty()) && SyncopeWebApplication.get().getSecuritySettings().getAuthorizationStrategy().isActionAuthorized((Component)this, RENDER);
    }

    public class ConsoleGroupsModel
    extends AbstractGroupsModel {
        private static final long serialVersionUID = -4541954630939063927L;
        protected List<String> dynMemberships;

        protected void reloadObject() {
            this.groups = Groups.this.searchAssignable(null);
        }

        protected void reloadMemberships() {
            HashMap<String, String> assignedGroups = new HashMap<String, String>();
            int total = ((GroupableRelatableTO)GroupableRelatableTO.class.cast(Groups.this.anyTO)).getMemberships().size();
            int pages = total / 30 + 1;
            SortParam sort = new SortParam((Object)"name", true);
            for (int page = 1; page <= pages; ++page) {
                GroupFiqlSearchConditionBuilder builder = SyncopeClient.getGroupSearchConditionBuilder();
                List conditions = ((GroupableRelatableTO)GroupableRelatableTO.class.cast(Groups.this.anyTO)).getMemberships().stream().skip(((long)page - 1L) * 30L).limit(30L).map(m -> builder.is("key").equalTo(m.getGroupKey(), new String[0]).wrap()).collect(Collectors.toList());
                if (conditions.isEmpty()) continue;
                assignedGroups.putAll(Groups.this.groupRestClient.search("/", builder.or(conditions).query(), 1, 30, (SortParam<String>)sort).stream().collect(Collectors.toMap(AnyTO::getKey, GroupTO::getName)));
            }
            ((GroupableRelatableTO)GroupableRelatableTO.class.cast(Groups.this.anyTO)).getMemberships().stream().filter(m -> m.getGroupName() == null && assignedGroups.containsKey(m.getGroupKey())).forEach(m -> m.setGroupName((String)assignedGroups.get(m.getGroupKey())));
            ((GroupableRelatableTO)GroupableRelatableTO.class.cast(Groups.this.anyTO)).getMemberships().removeIf(m -> m.getGroupName() == null);
            this.memberships = ((GroupableRelatableTO)GroupableRelatableTO.class.cast(Groups.this.anyTO)).getMemberships();
            this.memberships.sort(Comparator.comparing(MembershipTO::getGroupName));
        }

        protected void reloadDynMemberships() {
            GroupFiqlSearchConditionBuilder builder = SyncopeClient.getGroupSearchConditionBuilder();
            List<CompleteCondition> conditions = ((GroupableRelatableTO)GroupableRelatableTO.class.cast(Groups.this.anyTO)).getDynMemberships().stream().map(membership -> builder.is("key").equalTo(membership.getGroupKey(), new String[0]).wrap()).toList();
            this.dynMemberships = SyncopeConsoleSession.get().owns("GROUP_SEARCH", new String[0]) && !conditions.isEmpty() ? Groups.this.groupRestClient.search("/", builder.or(conditions).query(), 1, 30, (SortParam<String>)new SortParam((Object)"name", true)).stream().map(GroupTO::getName).toList() : ((GroupableRelatableTO)GroupableRelatableTO.class.cast(Groups.this.anyTO)).getDynMemberships().stream().map(MembershipTO::getGroupName).toList();
        }

        public List<String> getDynMemberships() {
            if (this.dynMemberships == null) {
                this.reloadDynMemberships();
            }
            return this.dynMemberships;
        }
    }
}

