/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.config.builder;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.config.builder.AbstractBuilder;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.direct.AnonymousClient;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.http.client.direct.DirectBasicAuthClient;

public class DirectClientBuilder
extends AbstractBuilder {
    public DirectClientBuilder(Map<String, String> properties, Map<String, Authenticator> authenticators) {
        super(properties, authenticators);
    }

    public void tryCreateAnonymousClient(Collection<Client> clients) {
        String anonymous = this.getProperty("anonymous");
        if (StringUtils.isNotBlank((CharSequence)anonymous)) {
            clients.add((Client)new AnonymousClient());
        }
    }

    public void tryCreateDirectBasciAuthClient(Collection<Client> clients) {
        for (int i = 0; i <= 100; ++i) {
            String authenticator = this.getProperty("directBasicAuth.authenticator", i);
            if (!StringUtils.isNotBlank((CharSequence)authenticator)) continue;
            DirectBasicAuthClient directBasicAuthClient = new DirectBasicAuthClient();
            directBasicAuthClient.setAuthenticator(this.getAuthenticator(authenticator));
            directBasicAuthClient.setName(this.concat(directBasicAuthClient.getName(), i));
            clients.add((Client)directBasicAuthClient);
        }
    }
}

