/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.raft.KafkaRaftManager;
import kafka.server.DynamicBrokerConfig;
import kafka.server.FaultHandlerFactory;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.Server$;
import kafka.server.metadata.BrokerServerMetrics;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.metrics.ControllerMetadataMetrics;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.loader.MetadataLoader;
import org.apache.kafka.image.loader.metrics.MetadataLoaderMetrics;
import org.apache.kafka.image.publisher.SnapshotEmitter;
import org.apache.kafka.image.publisher.SnapshotGenerator;
import org.apache.kafka.image.publisher.metrics.SnapshotEmitterMetrics;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.server.ProcessRole;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.metrics.ClientMetricsReceiverPlugin;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t%h\u0001\u0002&L\u0001AC\u0001\"\u0018\u0001\u0003\u0006\u0004%IA\u0018\u0005\tG\u0002\u0011\t\u0011)A\u0005?\"AA\r\u0001BC\u0002\u0013\u0005Q\r\u0003\u0005t\u0001\t\u0005\t\u0015!\u0003g\u0011!!\bA!b\u0001\n\u0003)\b\u0002C?\u0001\u0005\u0003\u0005\u000b\u0011\u0002<\t\u0011y\u0004!Q1A\u0005\n}D!\"!\u0004\u0001\u0005\u0003\u0005\u000b\u0011BA\u0001\u0011)\ty\u0001\u0001BC\u0002\u0013\u0005\u0011\u0011\u0003\u0005\u000b\u0003\u000f\u0002!\u0011!Q\u0001\n\u0005M\u0001BCA%\u0001\t\u0015\r\u0011\"\u0001\u0002L!Q\u00111\u000b\u0001\u0003\u0002\u0003\u0006I!!\u0014\t\u0015\u0005U\u0003A!b\u0001\n\u0003\t9\u0006\u0003\u0006\u0002`\u0001\u0011\t\u0011)A\u0005\u00033Bq!!\u0019\u0001\t\u0003\t\u0019\u0007C\u0005\u0002v\u0001\u0011\r\u0011\"\u0003\u0002x!A\u0011q\u0010\u0001!\u0002\u0013\tI\bC\u0005\u0002\u0002\u0002\u0001\r\u0011\"\u0003\u0002\u0004\"I\u00111\u0012\u0001A\u0002\u0013%\u0011Q\u0012\u0005\t\u00033\u0003\u0001\u0015)\u0003\u0002\u0006\"I\u00111\u0014\u0001A\u0002\u0013%\u00111\u0011\u0005\n\u0003;\u0003\u0001\u0019!C\u0005\u0003?C\u0001\"a)\u0001A\u0003&\u0011Q\u0011\u0005\n\u0003K\u0003\u0001\u0019!C\u0005\u0003\u0007C\u0011\"a*\u0001\u0001\u0004%I!!+\t\u0011\u00055\u0006\u0001)Q\u0005\u0003\u000bC\u0001\"a,\u0001\u0005\u0004%\tA\u0018\u0005\b\u0003c\u0003\u0001\u0015!\u0003`\u0011!\t\u0019\f\u0001b\u0001\n\u0003q\u0006bBA[\u0001\u0001\u0006Ia\u0018\u0005\t\u0003\u000f\u0001\u0001\u0019!C\u0001\u007f\"I\u0011q\u0017\u0001A\u0002\u0013\u0005\u0011\u0011\u0018\u0005\t\u0003{\u0003\u0001\u0015)\u0003\u0002\u0002!Y\u0011q\u0019\u0001A\u0002\u0003\u0007I\u0011AAe\u0011-\t\u0019\u000f\u0001a\u0001\u0002\u0004%\t!!:\t\u0017\u0005%\b\u00011A\u0001B\u0003&\u00111\u001a\u0005\f\u0003[\u0004\u0001\u0019!a\u0001\n\u0003\ty\u000fC\u0006\u0002|\u0002\u0001\r\u00111A\u0005\u0002\u0005u\bb\u0003B\u0001\u0001\u0001\u0007\t\u0011)Q\u0005\u0003cD1B!\u0002\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003\b!Y!q\u0003\u0001A\u0002\u0003\u0007I\u0011\u0001B\r\u0011-\u0011i\u0002\u0001a\u0001\u0002\u0003\u0006KA!\u0003\t\u0017\t\u0005\u0002\u00011AA\u0002\u0013\u0005!1\u0005\u0005\f\u0005g\u0001\u0001\u0019!a\u0001\n\u0003\u0011)\u0004C\u0006\u0003:\u0001\u0001\r\u0011!Q!\n\t\u0015\u0002\"\u0003B\u001f\u0001\t\u0007I\u0011\u0002B \u0011!\u0011\u0019\u0007\u0001Q\u0001\n\t\u0005\u0003b\u0003B3\u0001\u0001\u0007\t\u0019!C\u0001\u0005OB1B!\u001e\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003x!Y!1\u0010\u0001A\u0002\u0003\u0005\u000b\u0015\u0002B5\u0011-\u0011y\b\u0001a\u0001\u0002\u0004%IA!!\t\u0017\t%\u0005\u00011AA\u0002\u0013%!1\u0012\u0005\f\u0005\u001f\u0003\u0001\u0019!A!B\u0013\u0011\u0019\tC\u0006\u0003\u0014\u0002\u0001\r\u00111A\u0005\n\tU\u0005b\u0003BQ\u0001\u0001\u0007\t\u0019!C\u0005\u0005GC1Ba*\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003\u0018\"9!1\u0016\u0001\u0005\u0002\t5\u0006b\u0002BX\u0001\u0011\u0005!\u0011\u0017\u0005\b\u0005s\u0003A\u0011\u0002B^\u0011\u001d\u0011i\f\u0001C\u0001\u0005\u007fCqA!1\u0001\t\u0003\u0011y\fC\u0004\u0003D\u0002!\tAa0\t\u000f\t\u0015\u0007\u0001\"\u0001\u0003@\"9!q\u0019\u0001\u0005\n\t%\u0007b\u0002Bl\u0001\u0011%!\u0011\u001a\u0005\b\u00053\u0004A\u0011\u0001Be\u0011\u001d\u0011Y\u000e\u0001C\u0001\u0005\u0013DqA!8\u0001\t\u0003\u0011I\rC\u0004\u0003`\u0002!\tA!3\t\u000f\t\u0005\b\u0001\"\u0001\u0003J\"9!1\u001d\u0001\u0005\n\t}\u0006b\u0002Bs\u0001\u0011\u0005!q\u0018\u0005\b\u0005O\u0004A\u0011\u0002B`\u00051\u0019\u0006.\u0019:fIN+'O^3s\u0015\taU*\u0001\u0004tKJ4XM\u001d\u0006\u0002\u001d\u0006)1.\u00194lC\u000e\u00011c\u0001\u0001R/B\u0011!+V\u0007\u0002'*\tA+A\u0003tG\u0006d\u0017-\u0003\u0002W'\n1\u0011I\\=SK\u001a\u0004\"\u0001W.\u000e\u0003eS!AW'\u0002\u000bU$\u0018\u000e\\:\n\u0005qK&a\u0002'pO\u001eLgnZ\u0001\u0013g\"\f'/\u001a3TKJ4XM]\"p]\u001aLw-F\u0001`!\t\u0001\u0017-D\u0001L\u0013\t\u00117JA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aE:iCJ,GmU3sm\u0016\u00148i\u001c8gS\u001e\u0004\u0013!E7fi\u0006\u0004&o\u001c9t\u000b:\u001cX-\u001c2mKV\ta\r\u0005\u0002hc6\t\u0001N\u0003\u0002jU\u0006Q\u0001O]8qKJ$\u0018.Z:\u000b\u0005-d\u0017\u0001C7fi\u0006$\u0017\r^1\u000b\u00059k'B\u00018p\u0003\u0019\t\u0007/Y2iK*\t\u0001/A\u0002pe\u001eL!A\u001d5\u0003-5+G/\u0019)s_B,'\u000f^5fg\u0016s7/Z7cY\u0016\f!#\\3uCB\u0013x\u000e]:F]N,WN\u00197fA\u0005!A/[7f+\u00051\bCA<|\u001b\u0005A(B\u0001.z\u0015\tQH.\u0001\u0004d_6lwN\\\u0005\u0003yb\u0014A\u0001V5nK\u0006)A/[7fA\u0005Aq,\\3ue&\u001c7/\u0006\u0002\u0002\u0002A!\u00111AA\u0005\u001b\t\t)AC\u0002\u0002\be\fq!\\3ue&\u001c7/\u0003\u0003\u0002\f\u0005\u0015!aB'fiJL7m]\u0001\n?6,GO]5dg\u0002\nAdY8oiJ|G\u000e\\3s#V|'/^7W_R,'o\u001d$viV\u0014X-\u0006\u0002\u0002\u0014A1\u0011QCA\u0012\u0003Oi!!a\u0006\u000b\t\u0005e\u00111D\u0001\u000bG>t7-\u001e:sK:$(\u0002BA\u000f\u0003?\tA!\u001e;jY*\u0011\u0011\u0011E\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002&\u0005]!!E\"p[BdW\r^1cY\u00164U\u000f^;sKBA\u0011\u0011FA\u0016\u0003_\tY$\u0004\u0002\u0002\u001c%!\u0011QFA\u000e\u0005\ri\u0015\r\u001d\t\u0005\u0003c\t9$\u0004\u0002\u00024)!\u0011QGA\u0010\u0003\u0011a\u0017M\\4\n\t\u0005e\u00121\u0007\u0002\b\u0013:$XmZ3s!\u0011\ti$a\u0011\u000e\u0005\u0005}\"\u0002BA!\u0003?\t1A\\3u\u0013\u0011\t)%a\u0010\u0003#%sW\r^*pG.,G/\u00113ee\u0016\u001c8/A\u000fd_:$(o\u001c7mKJ\fVo\u001c:v[Z{G/\u001a:t\rV$XO]3!\u0003A\u0011wn\u001c;tiJ\f\u0007oU3sm\u0016\u00148/\u0006\u0002\u0002NA1\u0011\u0011FA(\u0003wIA!!\u0015\u0002\u001c\tQ1i\u001c7mK\u000e$\u0018n\u001c8\u0002#\t|w\u000e^:ue\u0006\u00048+\u001a:wKJ\u001c\b%A\ngCVdG\u000fS1oI2,'OR1di>\u0014\u00180\u0006\u0002\u0002ZA\u0019\u0001-a\u0017\n\u0007\u0005u3JA\nGCVdG\u000fS1oI2,'OR1di>\u0014\u00180\u0001\u000bgCVdG\u000fS1oI2,'OR1di>\u0014\u0018\u0010I\u0001\u0007y%t\u0017\u000e\u001e \u0015!\u0005\u0015\u0014qMA5\u0003W\ni'a\u001c\u0002r\u0005M\u0004C\u00011\u0001\u0011\u0015iv\u00021\u0001`\u0011\u0015!w\u00021\u0001g\u0011\u0015!x\u00021\u0001w\u0011\u0019qx\u00021\u0001\u0002\u0002!9\u0011qB\bA\u0002\u0005M\u0001bBA%\u001f\u0001\u0007\u0011Q\n\u0005\b\u0003+z\u0001\u0019AA-\u0003)awnZ\"p]R,\u0007\u0010^\u000b\u0003\u0003s\u00022a^A>\u0013\r\ti\b\u001f\u0002\u000b\u0019><7i\u001c8uKb$\u0018a\u00037pO\u000e{g\u000e^3yi\u0002\nqa\u001d;beR,G-\u0006\u0002\u0002\u0006B\u0019!+a\"\n\u0007\u0005%5KA\u0004C_>dW-\u00198\u0002\u0017M$\u0018M\u001d;fI~#S-\u001d\u000b\u0005\u0003\u001f\u000b)\nE\u0002S\u0003#K1!a%T\u0005\u0011)f.\u001b;\t\u0013\u0005]5#!AA\u0002\u0005\u0015\u0015a\u0001=%c\u0005A1\u000f^1si\u0016$\u0007%\u0001\u0007vg\u0016$')\u001f\"s_.,'/\u0001\tvg\u0016$')\u001f\"s_.,'o\u0018\u0013fcR!\u0011qRAQ\u0011%\t9JFA\u0001\u0002\u0004\t))A\u0007vg\u0016$')\u001f\"s_.,'\u000fI\u0001\u0011kN,GMQ=D_:$(o\u001c7mKJ\fA#^:fI\nK8i\u001c8ue>dG.\u001a:`I\u0015\fH\u0003BAH\u0003WC\u0011\"a&\u001a\u0003\u0003\u0005\r!!\"\u0002#U\u001cX\r\u001a\"z\u0007>tGO]8mY\u0016\u0014\b%\u0001\u0007ce>\\WM]\"p]\u001aLw-A\u0007ce>\\WM]\"p]\u001aLw\rI\u0001\u0011G>tGO]8mY\u0016\u00148i\u001c8gS\u001e\f\u0011cY8oiJ|G\u000e\\3s\u0007>tg-[4!\u0003-iW\r\u001e:jGN|F%Z9\u0015\t\u0005=\u00151\u0018\u0005\n\u0003/\u0003\u0013\u0011!a\u0001\u0003\u0003\t\u0001\"\\3ue&\u001c7\u000f\t\u0015\u0004C\u0005\u0005\u0007c\u0001*\u0002D&\u0019\u0011QY*\u0003\u0011Y|G.\u0019;jY\u0016\f1B]1gi6\u000bg.Y4feV\u0011\u00111\u001a\t\u0007\u0003\u001b\f\u0019.a6\u000e\u0005\u0005='bAAi\u001b\u0006!!/\u00194u\u0013\u0011\t).a4\u0003!-\u000bgm[1SC\u001a$X*\u00198bO\u0016\u0014\b\u0003BAm\u0003?l!!a7\u000b\u0007i\fiN\u0003\u0002MY&!\u0011\u0011]An\u0005Q\t\u0005/['fgN\fw-Z!oIZ+'o]5p]\u0006y!/\u00194u\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0010\u0006\u001d\b\"CALG\u0005\u0005\t\u0019AAf\u00031\u0011\u0018M\u001a;NC:\fw-\u001a:!Q\r!\u0013\u0011Y\u0001\u000eEJ|7.\u001a:NKR\u0014\u0018nY:\u0016\u0005\u0005E\b\u0003BAz\u0003ol!!!>\u000b\u0005-\\\u0015\u0002BA}\u0003k\u00141C\u0011:pW\u0016\u00148+\u001a:wKJlU\r\u001e:jGN\f\u0011C\u0019:pW\u0016\u0014X*\u001a;sS\u000e\u001cx\fJ3r)\u0011\ty)a@\t\u0013\u0005]e%!AA\u0002\u0005E\u0018A\u00042s_.,'/T3ue&\u001c7\u000f\t\u0015\u0004O\u0005\u0005\u0017aF2p]R\u0014x\u000e\u001c7feN+'O^3s\u001b\u0016$(/[2t+\t\u0011I\u0001\u0005\u0003\u0003\f\tMQB\u0001B\u0007\u0015\u0011\t9Aa\u0004\u000b\u0007\tEA.\u0001\u0006d_:$(o\u001c7mKJLAA!\u0006\u0003\u000e\tI2i\u001c8ue>dG.\u001a:NKR\fG-\u0019;b\u001b\u0016$(/[2t\u0003m\u0019wN\u001c;s_2dWM]*feZ,'/T3ue&\u001c7o\u0018\u0013fcR!\u0011q\u0012B\u000e\u0011%\t9*KA\u0001\u0002\u0004\u0011I!\u0001\rd_:$(o\u001c7mKJ\u001cVM\u001d<fe6+GO]5dg\u0002B3AKAa\u0003\u0019aw.\u00193feV\u0011!Q\u0005\t\u0005\u0005O\u0011y#\u0004\u0002\u0003*)!!\u0011\u0005B\u0016\u0015\r\u0011i\u0003\\\u0001\u0006S6\fw-Z\u0005\u0005\u0005c\u0011IC\u0001\bNKR\fG-\u0019;b\u0019>\fG-\u001a:\u0002\u00151|\u0017\rZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0010\n]\u0002\"CALY\u0005\u0005\t\u0019\u0001B\u0013\u0003\u001daw.\u00193fe\u0002B3!LAa\u0003]\u0019h.\u00199tQ>$8\u000fR5tC\ndW\r\u001a*fCN|g.\u0006\u0002\u0003BA1!1\tB%\u0005\u001bj!A!\u0012\u000b\t\t\u001d\u0013qC\u0001\u0007CR|W.[2\n\t\t-#Q\t\u0002\u0010\u0003R|W.[2SK\u001a,'/\u001a8dKB!!q\nB/\u001d\u0011\u0011\tF!\u0017\u0011\u0007\tM3+\u0004\u0002\u0003V)\u0019!qK(\u0002\rq\u0012xn\u001c;?\u0013\r\u0011YfU\u0001\u0007!J,G-\u001a4\n\t\t}#\u0011\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\tm3+\u0001\rt]\u0006\u00048\u000f[8ug\u0012K7/\u00192mK\u0012\u0014V-Y:p]\u0002\nqb\u001d8baNDw\u000e^#nSR$XM]\u000b\u0003\u0005S\u0002BAa\u001b\u0003r5\u0011!Q\u000e\u0006\u0005\u0005_\u0012Y#A\u0005qk\nd\u0017n\u001d5fe&!!1\u000fB7\u0005=\u0019f.\u00199tQ>$X)\\5ui\u0016\u0014\u0018aE:oCB\u001c\bn\u001c;F[&$H/\u001a:`I\u0015\fH\u0003BAH\u0005sB\u0011\"a&2\u0003\u0003\u0005\rA!\u001b\u0002!Mt\u0017\r]:i_R,U.\u001b;uKJ\u0004\u0003f\u0001\u001a\u0002B\u0006\t2O\\1qg\"|GoR3oKJ\fGo\u001c:\u0016\u0005\t\r\u0005\u0003\u0002B6\u0005\u000bKAAa\"\u0003n\t\t2K\\1qg\"|GoR3oKJ\fGo\u001c:\u0002+Mt\u0017\r]:i_R<UM\\3sCR|'o\u0018\u0013fcR!\u0011q\u0012BG\u0011%\t9\nNA\u0001\u0002\u0004\u0011\u0019)\u0001\nt]\u0006\u00048\u000f[8u\u000f\u0016tWM]1u_J\u0004\u0003fA\u001b\u0002B\u0006)R.\u001a;bI\u0006$\u0018\rT8bI\u0016\u0014X*\u001a;sS\u000e\u001cXC\u0001BL!\u0011\u0011IJ!(\u000e\u0005\tm%\u0002BA\u0004\u0005SIAAa(\u0003\u001c\n)R*\u001a;bI\u0006$\u0018\rT8bI\u0016\u0014X*\u001a;sS\u000e\u001c\u0018!G7fi\u0006$\u0017\r^1M_\u0006$WM]'fiJL7m]0%KF$B!a$\u0003&\"I\u0011qS\u001c\u0002\u0002\u0003\u0007!qS\u0001\u0017[\u0016$\u0018\rZ1uC2{\u0017\rZ3s\u001b\u0016$(/[2tA!\u001a\u0001(!1\u0002\u0013\rdWo\u001d;fe&#WC\u0001B'\u0003\u0019qw\u000eZ3JIV\u0011!1\u0017\t\u0004%\nU\u0016b\u0001B\\'\n\u0019\u0011J\u001c;\u0002\r%\u001cXk]3e)\t\t))\u0001\bti\u0006\u0014HOR8s\u0005J|7.\u001a:\u0015\u0005\u0005=\u0015AE:uCJ$hi\u001c:D_:$(o\u001c7mKJ\fQb\u001d;pa\u001a{'O\u0011:pW\u0016\u0014\u0018!E:u_B4uN]\"p]R\u0014x\u000e\u001c7fe\u00069\"/\u00194u\u001b\u0006t\u0017mZ3s\r\u0006,H\u000e\u001e%b]\u0012dWM]\u000b\u0003\u0005\u0017\u0004BA!4\u0003T6\u0011!q\u001a\u0006\u0005\u0005#\fi.A\u0003gCVdG/\u0003\u0003\u0003V\n='\u0001\u0004$bk2$\b*\u00198eY\u0016\u0014\u0018AG7fi\u0006$\u0017\r^1M_\u0006$WM\u001d$bk2$\b*\u00198eY\u0016\u0014\u0018!H2p]R\u0014x\u000e\u001c7feN#\u0018M\u001d;va\u001a\u000bW\u000f\u001c;IC:$G.\u001a:\u0002K%t\u0017\u000e^5bY\n\u0013xn[3s\u001b\u0016$\u0018\rZ1uC2{\u0017\r\u001a$bk2$\b*\u00198eY\u0016\u0014\u0018!\t4bi\u0006d\u0017+^8sk6\u001cuN\u001c;s_2dWM\u001d$bk2$\b*\u00198eY\u0016\u0014\u0018\u0001\n8p]\u001a\u000bG/\u00197Rk>\u0014X/\\\"p]R\u0014x\u000e\u001c7fe\u001a\u000bW\u000f\u001c;IC:$G.\u001a:\u0002=5,G/\u00193bi\u0006\u0004VO\u00197jg\"Lgn\u001a$bk2$\b*\u00198eY\u0016\u0014\u0018!B:uCJ$\u0018aE3ogV\u0014XMT8u%\u00064G\u000fT3bI\u0016\u0014\u0018\u0001B:u_B\u0004")
public class SharedServer
implements Logging {
    private final KafkaConfig sharedServerConfig;
    private final MetaPropertiesEnsemble metaPropsEnsemble;
    private final Time time;
    private final Metrics _metrics;
    private final CompletableFuture<Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture;
    private final Collection<InetSocketAddress> bootstrapServers;
    private final FaultHandlerFactory faultHandlerFactory;
    private final LogContext logContext;
    private boolean started;
    private boolean usedByBroker;
    private boolean usedByController;
    private final KafkaConfig brokerConfig;
    private final KafkaConfig controllerConfig;
    private volatile Metrics metrics;
    private volatile KafkaRaftManager<ApiMessageAndVersion> raftManager;
    private volatile BrokerServerMetrics brokerMetrics;
    private volatile ControllerMetadataMetrics controllerServerMetrics;
    private volatile MetadataLoader loader;
    private final AtomicReference<String> snapshotsDisabledReason;
    private volatile SnapshotEmitter snapshotEmitter;
    private volatile SnapshotGenerator snapshotGenerator;
    private volatile MetadataLoaderMetrics metadataLoaderMetrics;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig sharedServerConfig() {
        return this.sharedServerConfig;
    }

    public MetaPropertiesEnsemble metaPropsEnsemble() {
        return this.metaPropsEnsemble;
    }

    public Time time() {
        return this.time;
    }

    private Metrics _metrics() {
        return this._metrics;
    }

    public CompletableFuture<Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public Collection<InetSocketAddress> bootstrapServers() {
        return this.bootstrapServers;
    }

    public FaultHandlerFactory faultHandlerFactory() {
        return this.faultHandlerFactory;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private boolean started() {
        return this.started;
    }

    private void started_$eq(boolean x$1) {
        this.started = x$1;
    }

    private boolean usedByBroker() {
        return this.usedByBroker;
    }

    private void usedByBroker_$eq(boolean x$1) {
        this.usedByBroker = x$1;
    }

    private boolean usedByController() {
        return this.usedByController;
    }

    private void usedByController_$eq(boolean x$1) {
        this.usedByController = x$1;
    }

    public KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    public KafkaConfig controllerConfig() {
        return this.controllerConfig;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public KafkaRaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    public void raftManager_$eq(KafkaRaftManager<ApiMessageAndVersion> x$1) {
        this.raftManager = x$1;
    }

    public BrokerServerMetrics brokerMetrics() {
        return this.brokerMetrics;
    }

    public void brokerMetrics_$eq(BrokerServerMetrics x$1) {
        this.brokerMetrics = x$1;
    }

    public ControllerMetadataMetrics controllerServerMetrics() {
        return this.controllerServerMetrics;
    }

    public void controllerServerMetrics_$eq(ControllerMetadataMetrics x$1) {
        this.controllerServerMetrics = x$1;
    }

    public MetadataLoader loader() {
        return this.loader;
    }

    public void loader_$eq(MetadataLoader x$1) {
        this.loader = x$1;
    }

    private AtomicReference<String> snapshotsDisabledReason() {
        return this.snapshotsDisabledReason;
    }

    public SnapshotEmitter snapshotEmitter() {
        return this.snapshotEmitter;
    }

    public void snapshotEmitter_$eq(SnapshotEmitter x$1) {
        this.snapshotEmitter = x$1;
    }

    private SnapshotGenerator snapshotGenerator() {
        return this.snapshotGenerator;
    }

    private void snapshotGenerator_$eq(SnapshotGenerator x$1) {
        this.snapshotGenerator = x$1;
    }

    private MetadataLoaderMetrics metadataLoaderMetrics() {
        return this.metadataLoaderMetrics;
    }

    private void metadataLoaderMetrics_$eq(MetadataLoaderMetrics x$1) {
        this.metadataLoaderMetrics = x$1;
    }

    public String clusterId() {
        return (String)this.metaPropsEnsemble().clusterId().get();
    }

    public int nodeId() {
        return this.metaPropsEnsemble().nodeId().getAsInt();
    }

    private synchronized boolean isUsed() {
        return this.usedByController() || this.usedByBroker();
    }

    public synchronized void startForBroker() {
        if (!this.isUsed()) {
            this.start();
        }
        this.usedByBroker_$eq(true);
    }

    public synchronized void startForController() {
        if (!this.isUsed()) {
            this.start();
        }
        this.usedByController_$eq(true);
    }

    public synchronized void stopForBroker() {
        if (this.usedByBroker()) {
            this.usedByBroker_$eq(false);
            if (!this.isUsed()) {
                this.stop();
                return;
            }
            return;
        }
    }

    public synchronized void stopForController() {
        if (this.usedByController()) {
            this.usedByController_$eq(false);
            if (!this.isUsed()) {
                this.stop();
                return;
            }
            return;
        }
    }

    private FaultHandler raftManagerFaultHandler() {
        return this.faultHandlerFactory().build("raft manager", true, () -> {});
    }

    private FaultHandler metadataLoaderFaultHandler() {
        return this.faultHandlerFactory().build("metadata loading", this.sharedServerConfig().processRoles().contains((Object)ProcessRole.ControllerRole), () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$metadataLoaderFaultHandler$2(x$8)));
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$9 -> {
                    x$9.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "metadata loading fault");
                return;
            }
        });
    }

    public FaultHandler controllerStartupFaultHandler() {
        return this.faultHandlerFactory().build("controller startup", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$10 -> {
                    x$10.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "controller startup fault");
                return;
            }
        });
    }

    public FaultHandler initialBrokerMetadataLoadFaultHandler() {
        return this.faultHandlerFactory().build("initial broker metadata loading", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable)x$11 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$initialBrokerMetadataLoadFaultHandler$2(x$11)));
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$12 -> {
                    x$12.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "initial broker metadata loading fault");
                return;
            }
        });
    }

    public FaultHandler fatalQuorumControllerFaultHandler() {
        return this.faultHandlerFactory().build("quorum controller", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$13 -> {
                    x$13.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "quorum controller fatal fault");
                return;
            }
        });
    }

    public FaultHandler nonFatalQuorumControllerFaultHandler() {
        return this.faultHandlerFactory().build("quorum controller", false, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$14 -> {
                    x$14.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        });
    }

    public FaultHandler metadataPublishingFaultHandler() {
        return this.faultHandlerFactory().build("metadata publishing", false, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable)x$15 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$metadataPublishingFaultHandler$2(x$15)));
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$16 -> {
                    x$16.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        });
    }

    private synchronized void start() {
        if (this.started()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "SharedServer has already been started.");
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Starting SharedServer");
        try {
            if (this.metrics() == null) {
                this.metrics_$eq(new Metrics());
            }
            this.sharedServerConfig().dynamicConfig().initialize((Option<KafkaZkClient>)None$.MODULE$, (Option<ClientMetricsReceiverPlugin>)None$.MODULE$);
            if (this.sharedServerConfig().processRoles().contains((Object)ProcessRole.BrokerRole)) {
                Metrics apply_metrics = this.metrics();
                Object var5_1 = null;
                this.brokerMetrics_$eq(new BrokerServerMetrics(apply_metrics));
            }
            if (this.sharedServerConfig().processRoles().contains((Object)ProcessRole.ControllerRole)) {
                this.controllerServerMetrics_$eq(new ControllerMetadataMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry())));
            }
            KafkaRaftManager<ApiMessageAndVersion> _raftManager = new KafkaRaftManager<ApiMessageAndVersion>(this.clusterId(), this.sharedServerConfig(), (Uuid)((MetaProperties)this.metaPropsEnsemble().logDirProps().get(this.metaPropsEnsemble().metadataLogDir().get())).directoryId().get(), (RecordSerde<ApiMessageAndVersion>)new MetadataRecordSerde(), KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), this.time(), this.metrics(), (Option<String>)new Some((Object)new StringBuilder(11).append("kafka-").append(this.sharedServerConfig().nodeId()).append("-raft").toString()), this.controllerQuorumVotersFuture(), this.bootstrapServers(), this.raftManagerFaultHandler());
            this.raftManager_$eq(_raftManager);
            _raftManager.startup();
            this.metadataLoaderMetrics_$eq(this.brokerMetrics() != null ? new MetadataLoaderMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry()), elapsedNs -> this.brokerMetrics().updateBatchProcessingTime(Predef$.MODULE$.Long2long(elapsedNs)), batchSize -> this.brokerMetrics().updateBatchSize(Predef$.MODULE$.Integer2int(batchSize)), this.brokerMetrics().lastAppliedImageProvenance()) : new MetadataLoaderMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry()), x$17 -> {}, x$18 -> {}, new AtomicReference<MetadataProvenance>(MetadataProvenance.EMPTY)));
            MetadataLoader.Builder loaderBuilder = new MetadataLoader.Builder().setNodeId(this.nodeId()).setTime(this.time()).setThreadNamePrefix(new StringBuilder(7).append("kafka-").append(this.sharedServerConfig().nodeId()).append("-").toString()).setFaultHandler(this.metadataLoaderFaultHandler()).setHighWaterMarkAccessor(() -> _raftManager.client().highWatermark()).setMetrics(this.metadataLoaderMetrics());
            this.loader_$eq(loaderBuilder.build());
            this.snapshotEmitter_$eq(new SnapshotEmitter.Builder().setNodeId(this.nodeId()).setRaftClient(_raftManager.client()).setMetrics(new SnapshotEmitterMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry()), this.time())).build());
            this.snapshotGenerator_$eq(new SnapshotGenerator.Builder((SnapshotGenerator.Emitter)this.snapshotEmitter()).setNodeId(this.nodeId()).setTime(this.time()).setFaultHandler(this.metadataPublishingFaultHandler()).setMaxBytesSinceLastSnapshot(Predef$.MODULE$.Long2long(this.sharedServerConfig().metadataSnapshotMaxNewRecordBytes())).setMaxTimeSinceLastSnapshotNs(TimeUnit.MILLISECONDS.toNanos(Predef$.MODULE$.Long2long(this.sharedServerConfig().metadataSnapshotMaxIntervalMs()))).setDisabledReason(this.snapshotsDisabledReason()).setThreadNamePrefix(new StringBuilder(7).append("kafka-").append(this.sharedServerConfig().nodeId()).append("-").toString()).build());
            try {
                this.loader().installPublishers(Arrays.asList(this.snapshotGenerator())).get();
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "Unable to install metadata publishers", (Function0<Throwable>)(Function0 & Serializable)() -> t);
                throw new RuntimeException("Unable to install metadata publishers.", t);
            }
            _raftManager.register((RaftClient.Listener<ApiMessageAndVersion>)this.loader());
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Completed SharedServer startup.");
            this.started_$eq(true);
            return;
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Got exception while starting SharedServer", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.stop();
            throw e;
        }
    }

    public synchronized void ensureNotRaftLeader() {
        Option$.MODULE$.apply(this.raftManager()).foreach((Function1 & Serializable)_raftManager -> {
            SharedServer.$anonfun$ensureNotRaftLeader$1(this, _raftManager);
            return BoxedUnit.UNIT;
        });
    }

    private synchronized void stop() {
        if (!this.started()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "SharedServer is not running.");
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Stopping SharedServer");
        if (this.loader() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.loader().beginShutdown(), this, Level.WARN);
        }
        if (this.snapshotGenerator() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.snapshotGenerator().beginShutdown(), this, Level.WARN);
        }
        if (this.loader() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.loader().close(), this, Level.WARN);
            this.loader_$eq(null);
        }
        if (this.metadataLoaderMetrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.metadataLoaderMetrics().close(), this, Level.WARN);
            this.metadataLoaderMetrics_$eq(null);
        }
        if (this.snapshotGenerator() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.snapshotGenerator().close(), this, Level.WARN);
            this.snapshotGenerator_$eq(null);
        }
        if (this.raftManager() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.raftManager().shutdown(), this, Level.WARN);
            this.raftManager_$eq(null);
        }
        if (this.controllerServerMetrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.controllerServerMetrics().close(), this, Level.WARN);
            this.controllerServerMetrics_$eq(null);
        }
        if (this.brokerMetrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.brokerMetrics().close(), this, Level.WARN);
            this.brokerMetrics_$eq(null);
        }
        if (this.metrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.metrics().close(), this, Level.WARN);
            this.metrics_$eq(null);
        }
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> AppInfoParser.unregisterAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString(this.sharedServerConfig().nodeId()), (Metrics)this.metrics()), this, Level.WARN);
        this.started_$eq(false);
    }

    public static final /* synthetic */ long $anonfun$metadataLoaderFaultHandler$2(BrokerServerMetrics x$8) {
        return x$8.metadataLoadErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ long $anonfun$initialBrokerMetadataLoadFaultHandler$2(BrokerServerMetrics x$11) {
        return x$11.metadataApplyErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ long $anonfun$metadataPublishingFaultHandler$2(BrokerServerMetrics x$15) {
        return x$15.metadataApplyErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ void $anonfun$ensureNotRaftLeader$1(SharedServer $this, KafkaRaftManager _raftManager) {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> _raftManager.shutdown(), $this, Level.WARN);
        $this.raftManager_$eq(null);
    }

    public SharedServer(KafkaConfig sharedServerConfig, MetaPropertiesEnsemble metaPropsEnsemble, Time time, Metrics _metrics, CompletableFuture<Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture, Collection<InetSocketAddress> bootstrapServers, FaultHandlerFactory faultHandlerFactory) {
        this.sharedServerConfig = sharedServerConfig;
        this.metaPropsEnsemble = metaPropsEnsemble;
        this.time = time;
        this._metrics = _metrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.bootstrapServers = bootstrapServers;
        this.faultHandlerFactory = faultHandlerFactory;
        this.logContext = new LogContext(new StringBuilder(19).append("[SharedServer id=").append(sharedServerConfig.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.started = false;
        this.usedByBroker = false;
        this.usedByController = false;
        this.brokerConfig = new KafkaConfig(sharedServerConfig.props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$);
        this.controllerConfig = new KafkaConfig(sharedServerConfig.props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$);
        this.metrics = _metrics;
        this.snapshotsDisabledReason = new AtomicReference<Object>(null);
    }
}

