/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.util.Optional;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.ValueJoinerWithKey;
import org.apache.kafka.streams.kstream.internals.KStreamKTableJoinProcessor;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;

class KStreamKTableJoin<K, V1, V2, VOut>
implements ProcessorSupplier<K, V1, K, VOut> {
    private final KeyValueMapper<K, V1, K> keyValueMapper = (key, value) -> key;
    private final KTableValueGetterSupplier<K, V2> valueGetterSupplier;
    private final ValueJoinerWithKey<? super K, ? super V1, ? super V2, VOut> joiner;
    private final boolean leftJoin;
    private final Optional<Duration> gracePeriod;
    private final Optional<String> storeName;

    KStreamKTableJoin(KTableValueGetterSupplier<K, V2> valueGetterSupplier, ValueJoinerWithKey<? super K, ? super V1, ? super V2, VOut> joiner, boolean leftJoin, Optional<Duration> gracePeriod, Optional<String> storeName) {
        this.valueGetterSupplier = valueGetterSupplier;
        this.joiner = joiner;
        this.leftJoin = leftJoin;
        this.gracePeriod = gracePeriod;
        this.storeName = storeName;
    }

    @Override
    public Processor<K, V1, K, VOut> get() {
        return new KStreamKTableJoinProcessor<K, K, V1, V2, VOut>(this.valueGetterSupplier.get(), this.keyValueMapper, this.joiner, this.leftJoin, this.gracePeriod, this.storeName);
    }
}

