/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.List;
import org.apache.syncope.common.lib.to.AnyTypeClassTO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.provisioning.api.data.AnyTypeClassDataBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnyTypeClassDataBinderImpl
implements AnyTypeClassDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(AnyTypeClassDataBinder.class);
    protected final PlainSchemaDAO plainSchemaDAO;
    protected final DerSchemaDAO derSchemaDAO;
    protected final AnyTypeDAO anyTypeDAO;
    protected final EntityFactory entityFactory;

    public AnyTypeClassDataBinderImpl(PlainSchemaDAO plainSchemaDAO, DerSchemaDAO derSchemaDAO, AnyTypeDAO anyTypeDAO, EntityFactory entityFactory) {
        this.plainSchemaDAO = plainSchemaDAO;
        this.derSchemaDAO = derSchemaDAO;
        this.anyTypeDAO = anyTypeDAO;
        this.entityFactory = entityFactory;
    }

    public AnyTypeClass create(AnyTypeClassTO anyTypeClassTO) {
        AnyTypeClass anyTypeClass = (AnyTypeClass)this.entityFactory.newEntity(AnyTypeClass.class);
        this.update(anyTypeClass, anyTypeClassTO);
        return anyTypeClass;
    }

    public void update(AnyTypeClass anyTypeClass, AnyTypeClassTO anyTypeClassTO) {
        if (anyTypeClass.getKey() == null) {
            anyTypeClass.setKey(anyTypeClassTO.getKey());
        }
        this.plainSchemaDAO.findByAnyTypeClasses(List.of(anyTypeClass)).forEach(schema -> {
            schema.setAnyTypeClass(null);
            this.plainSchemaDAO.save((Entity)schema);
        });
        anyTypeClass.getPlainSchemas().clear();
        anyTypeClassTO.getPlainSchemas().forEach(key -> {
            PlainSchema schema = this.plainSchemaDAO.findById(key).orElse(null);
            if (schema == null || schema.getAnyTypeClass() != null) {
                LOG.debug("Invalid or already in use: {} {}, ignoring...", (Object)PlainSchema.class.getSimpleName(), key);
            } else {
                anyTypeClass.add(schema);
                schema.setAnyTypeClass(anyTypeClass);
                this.plainSchemaDAO.save((Entity)schema);
            }
        });
        this.derSchemaDAO.findByAnyTypeClasses(List.of(anyTypeClass)).forEach(schema -> {
            schema.setAnyTypeClass(null);
            this.derSchemaDAO.save((Entity)schema);
        });
        anyTypeClass.getDerSchemas().clear();
        anyTypeClassTO.getDerSchemas().forEach(key -> {
            DerSchema schema = this.derSchemaDAO.findById(key).orElse(null);
            if (schema == null || schema.getAnyTypeClass() != null) {
                LOG.debug("Invalid or already in use: {} {}, ignoring...", (Object)DerSchema.class.getSimpleName(), key);
            } else {
                anyTypeClass.add(schema);
                schema.setAnyTypeClass(anyTypeClass);
                this.derSchemaDAO.save((Entity)schema);
            }
        });
    }

    public AnyTypeClassTO getAnyTypeClassTO(AnyTypeClass anyTypeClass) {
        AnyTypeClassTO anyTypeClassTO = new AnyTypeClassTO();
        anyTypeClassTO.setKey(anyTypeClass.getKey());
        anyTypeClassTO.getInUseByTypes().addAll(this.anyTypeDAO.findByClassesContaining(anyTypeClass).stream().map(Entity::getKey).toList());
        anyTypeClassTO.getPlainSchemas().addAll(anyTypeClass.getPlainSchemas().stream().map(Entity::getKey).toList());
        anyTypeClassTO.getDerSchemas().addAll(anyTypeClass.getDerSchemas().stream().map(Entity::getKey).toList());
        return anyTypeClassTO;
    }
}

