/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.common.validation;

import jakarta.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.common.validation.AbstractValidator;
import org.apache.syncope.core.persistence.common.validation.SchedTaskCheck;
import org.springframework.scheduling.support.CronExpression;

public class SchedTaskValidator
extends AbstractValidator<SchedTaskCheck, SchedTask> {
    public boolean isValid(SchedTask task, ConstraintValidatorContext context) {
        boolean isValid = true;
        if (task.getCronExpression() != null) {
            try {
                CronExpression.parse((String)task.getCronExpression());
            }
            catch (IllegalArgumentException e) {
                LOG.error("Invalid cron expression '{}'", (Object)task.getCronExpression(), (Object)e);
                isValid = false;
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(SchedTaskValidator.getTemplate(EntityViolationType.InvalidSchedTask, "Invalid cron expression")).addPropertyNode("cronExpression").addConstraintViolation();
            }
        }
        return isValid;
    }
}

