/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.common.validation;

import jakarta.validation.ConstraintValidatorContext;
import java.util.Optional;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.ApplicationContextProvider;
import org.apache.syncope.core.persistence.api.dao.AllowedSchemas;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Groupable;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.common.validation.AbstractValidator;
import org.apache.syncope.core.persistence.common.validation.AnyCheck;

public class AnyValidator
extends AbstractValidator<AnyCheck, Any> {
    private static boolean raiseNotAllowedViolation(ConstraintValidatorContext context, String schema, Group group) {
        if (group == null) {
            context.buildConstraintViolationWithTemplate(AnyValidator.getTemplate(EntityViolationType.InvalidPlainAttr, schema + " not allowed for this instance")).addPropertyNode("plainAttrs").addConstraintViolation();
        } else {
            context.buildConstraintViolationWithTemplate(AnyValidator.getTemplate(EntityViolationType.InvalidPlainAttr, schema + " not allowed for membership of group " + group.getName())).addPropertyNode("plainAttrs").addConstraintViolation();
        }
        return false;
    }

    public boolean isValid(Any any, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        AllowedSchemas allowedPlainSchemas = ((AnyUtilsFactory)ApplicationContextProvider.getApplicationContext().getBean(AnyUtilsFactory.class)).getInstance(any.getType().getKind()).dao().findAllowedSchemas(any, PlainSchema.class);
        for (PlainAttr attr : any.getPlainAttrs()) {
            String plainSchema = Optional.ofNullable(attr).map(PlainAttr::getSchema).orElse(null);
            if (plainSchema == null || allowedPlainSchemas.forSelfContains(plainSchema)) continue;
            return AnyValidator.raiseNotAllowedViolation(context, plainSchema, null);
        }
        if (any instanceof Groupable) {
            Groupable groupableRelatable = (Groupable)any;
            for (Membership membership : groupableRelatable.getMemberships()) {
                for (PlainAttr attr : groupableRelatable.getPlainAttrs(membership)) {
                    String plainSchema = Optional.ofNullable(attr).map(PlainAttr::getSchema).orElse(null);
                    if (plainSchema == null || allowedPlainSchemas.forMembershipsContains((Group)membership.getRightEnd(), plainSchema)) continue;
                    return AnyValidator.raiseNotAllowedViolation(context, plainSchema, (Group)membership.getRightEnd());
                }
            }
        }
        return true;
    }
}

