/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.http.client;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.http.client.HttpClientProperties;
import org.springframework.boot.autoconfigure.http.client.NotReactiveWebApplicationCondition;
import org.springframework.boot.autoconfigure.ssl.SslAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.util.StringUtils;

@AutoConfiguration(after={SslAutoConfiguration.class})
@ConditionalOnClass(value={ClientHttpRequestFactory.class})
@Conditional(value={NotReactiveWebApplicationCondition.class})
@EnableConfigurationProperties(value={HttpClientProperties.class})
public class HttpClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    ClientHttpRequestFactoryBuilder<?> clientHttpRequestFactoryBuilder(HttpClientProperties httpClientProperties) {
        HttpClientProperties.Factory factory = httpClientProperties.getFactory();
        return factory != null ? factory.builder() : ClientHttpRequestFactoryBuilder.detect();
    }

    @Bean
    @ConditionalOnMissingBean
    ClientHttpRequestFactorySettings clientHttpRequestFactorySettings(HttpClientProperties httpClientProperties, ObjectProvider<SslBundles> sslBundles) {
        SslBundle sslBundle = this.getSslBundle(httpClientProperties.getSsl(), sslBundles);
        return new ClientHttpRequestFactorySettings(httpClientProperties.getRedirects(), httpClientProperties.getConnectTimeout(), httpClientProperties.getReadTimeout(), sslBundle);
    }

    private SslBundle getSslBundle(HttpClientProperties.Ssl properties, ObjectProvider<SslBundles> sslBundles) {
        String name = properties.getBundle();
        return StringUtils.hasLength((String)name) ? ((SslBundles)sslBundles.getObject()).getBundle(name) : null;
    }
}

