/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.base;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.base.TransportView;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransportMBeanSupport {
    private static final Log log = LogFactory.getLog(TransportMBeanSupport.class);
    private boolean enabled = true;
    private boolean registered;
    private MBeanServer mbs;
    private ObjectName mbeanName;
    private TransportView mbeanInstance;

    private TransportMBeanSupport(String connectorName, TransportView mbeanInstance) {
        try {
            this.mbs = ManagementFactory.getPlatformMBeanServer();
        }
        catch (SecurityException ex) {
            log.warn((Object)"Unable to get the platform MBean server; JMX support disabled", (Throwable)ex);
            this.enabled = false;
            return;
        }
        String jmxAgentName = System.getProperty("jmx.agent.name");
        if (jmxAgentName == null || "".equals(jmxAgentName)) {
            jmxAgentName = "org.apache.axis2";
        }
        String mbeanNameString = jmxAgentName + ":Type=Transport,ConnectorName=" + connectorName;
        try {
            this.mbeanName = ObjectName.getInstance(mbeanNameString);
        }
        catch (MalformedObjectNameException ex) {
            log.warn((Object)("Unable to create object name '" + mbeanNameString + "'; JMX support disabled"), (Throwable)ex);
            this.enabled = false;
        }
        this.mbeanInstance = mbeanInstance;
    }

    public TransportMBeanSupport(TransportListener listener, String name) {
        this(name + "-listener-" + listener.hashCode(), new TransportView(listener, null));
    }

    public TransportMBeanSupport(TransportSender sender, String name) {
        this(name + "-sender-" + sender.hashCode(), new TransportView(null, sender));
    }

    public ObjectName getMBeanName() {
        return this.mbeanName;
    }

    public void register() {
        if (this.enabled && !this.registered) {
            try {
                this.mbs.registerMBean(this.mbeanInstance, this.mbeanName);
                this.registered = true;
            }
            catch (Exception e) {
                log.warn((Object)("Error registering a MBean with objectname ' " + this.mbeanName + " ' for JMX management"), (Throwable)e);
                this.enabled = false;
            }
        }
    }

    public void unregister() {
        if (this.enabled && this.registered) {
            try {
                this.mbs.unregisterMBean(this.mbeanName);
                this.registered = false;
            }
            catch (Exception e) {
                log.warn((Object)("Error un-registering a MBean with objectname ' " + this.mbeanName + " ' for JMX management"), (Throwable)e);
            }
        }
    }
}

