/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.uri.template.parser;

import org.wso2.uri.template.URITemplateException;
import org.wso2.uri.template.parser.FragmentExpression;
import org.wso2.uri.template.parser.LabelExpression;
import org.wso2.uri.template.parser.Literal;
import org.wso2.uri.template.parser.Node;
import org.wso2.uri.template.parser.PathSegmentExpression;
import org.wso2.uri.template.parser.ReservedStringExpression;
import org.wso2.uri.template.parser.SimpleStringExpression;

public class URITemplateParser {
    private static final char[] operators = new char[]{'+', '.', '/', ';', '?', '&', '#'};
    private Node syntaxTree;
    private Node currentNode;

    public Node parse(String template) throws URITemplateException {
        if (!"/".equals(template) && template.endsWith("/")) {
            template = template.substring(0, template.length() - 1);
        }
        boolean expression = false;
        int startIndex = 0;
        int maxIndex = template.length() - 1;
        block4: for (int pointerIndex = 0; pointerIndex < template.length(); ++pointerIndex) {
            char ch = template.charAt(pointerIndex);
            switch (ch) {
                case '{': {
                    if (!expression) {
                        if (pointerIndex + 1 >= maxIndex) {
                            throw new URITemplateException("Illegal open brace character");
                        }
                        expression = true;
                        if (pointerIndex > startIndex) {
                            this.addNode(new Literal(template.substring(startIndex, pointerIndex)));
                            startIndex = pointerIndex + 1;
                            continue block4;
                        }
                        if (template.charAt(pointerIndex - 1) != '}') {
                            throw new URITemplateException("Illegal empty literal");
                        }
                        ++startIndex;
                        continue block4;
                    }
                    throw new URITemplateException("Already in expression");
                }
                case '}': {
                    if (expression) {
                        expression = false;
                        if (pointerIndex > startIndex) {
                            this.createExpressionNode(template.substring(startIndex, pointerIndex));
                            startIndex = pointerIndex + 1;
                            continue block4;
                        }
                        throw new URITemplateException("Illegal empty expression");
                    }
                    throw new URITemplateException("Illegal closing brace detected");
                }
                default: {
                    if (pointerIndex != maxIndex) continue block4;
                    String token = template.substring(startIndex);
                    if (expression) {
                        this.createExpressionNode(token);
                        continue block4;
                    }
                    this.addNode(new Literal(token));
                }
            }
        }
        return this.syntaxTree;
    }

    private void addNode(Node node) {
        if (this.syntaxTree == null) {
            this.currentNode = this.syntaxTree = node;
        } else {
            this.currentNode.setNext(node);
            this.currentNode = node;
        }
    }

    private void createExpressionNode(String expression) throws URITemplateException {
        SimpleStringExpression node = null;
        if (this.isSimpleString(expression)) {
            node = new SimpleStringExpression(expression);
        }
        if (expression.length() <= 1) {
            throw new URITemplateException("Invalid template expression: {" + expression + "}");
        }
        if (expression.startsWith("#")) {
            node = new FragmentExpression(expression.substring(1));
        } else if (expression.startsWith("+")) {
            node = new ReservedStringExpression(expression.substring(1));
        } else if (expression.startsWith(".")) {
            node = new LabelExpression(expression.substring(1));
        } else if (expression.startsWith("/")) {
            node = new PathSegmentExpression(expression.substring(1));
        }
        if (node == null) {
            throw new URITemplateException("Unsupported template expression: {" + expression + "}");
        }
        this.addNode(node);
    }

    private boolean isSimpleString(String expression) {
        for (char op : operators) {
            if (expression.indexOf(op) != 0) continue;
            return false;
        }
        return true;
    }
}

