/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints.algorithms;

import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.axis2.clustering.Member;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.algorithms.AlgorithmContext;
import org.apache.synapse.endpoints.algorithms.LoadbalanceAlgorithm;

public class RoundRobin
implements LoadbalanceAlgorithm {
    private static final Log log = LogFactory.getLog(RoundRobin.class);
    private List endpoints = null;
    private List<Member> members;
    private final Lock lock = new ReentrantLock();

    public RoundRobin() {
    }

    public RoundRobin(List endpoints) {
        this.endpoints = endpoints;
    }

    @Override
    public void setApplicationMembers(List<Member> members) {
        this.members = members;
    }

    @Override
    public void setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    @Override
    public void setLoadBalanceEndpoint(Endpoint endpoint) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Endpoint getNextEndpoint(MessageContext synCtx, AlgorithmContext algorithmContext) {
        Endpoint nextEndpoint;
        int attempts = 0;
        AlgorithmContext algorithmContext2 = algorithmContext;
        synchronized (algorithmContext2) {
            int currentEPR = algorithmContext.getCurrentEndpointIndex();
            do {
                nextEndpoint = (Endpoint)this.endpoints.get(currentEPR);
                currentEPR = currentEPR == this.endpoints.size() - 1 ? 0 : ++currentEPR;
                algorithmContext.setCurrentEndpointIndex(currentEPR);
                if (++attempts <= this.endpoints.size()) continue;
                return null;
            } while (!nextEndpoint.readyToSend());
        }
        return nextEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Member getNextApplicationMember(AlgorithmContext algorithmContext) {
        if (this.members.size() == 0) {
            return null;
        }
        Member current = null;
        this.lock.lock();
        try {
            int currentMemberIndex = algorithmContext.getCurrentEndpointIndex();
            if (currentMemberIndex >= this.members.size()) {
                currentMemberIndex = 0;
            }
            int index = this.members.size();
            do {
                current = this.members.get(currentMemberIndex);
                if (currentMemberIndex == this.members.size() - 1) {
                    currentMemberIndex = 0;
                    continue;
                }
                ++currentMemberIndex;
            } while (current.isSuspended() && --index > 0);
            algorithmContext.setCurrentEndpointIndex(currentMemberIndex);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Members       : " + this.members.size()));
                log.debug((Object)("Current member: " + current));
            }
        }
        finally {
            this.lock.unlock();
        }
        return current;
    }

    @Override
    public LoadbalanceAlgorithm clone() {
        return new RoundRobin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(AlgorithmContext algorithmContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Resetting the Round Robin loadbalancing algorithm ...");
        }
        AlgorithmContext algorithmContext2 = algorithmContext;
        synchronized (algorithmContext2) {
            algorithmContext.setCurrentEndpointIndex(0);
        }
    }

    @Override
    public String getName() {
        return "RoundRobin";
    }
}

