/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.deployers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.util.XMLPrettyPrinter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerConfigurationInformation;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.ServerState;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.deployers.SynapseArtifactDeploymentException;
import org.apache.synapse.deployers.SynapseArtifactDeploymentStore;

public abstract class AbstractSynapseArtifactDeployer
extends AbstractDeployer {
    private static final Log log = LogFactory.getLog(AbstractSynapseArtifactDeployer.class);
    protected Log deployerLog = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected ConfigurationContext cfgCtx;

    protected AbstractSynapseArtifactDeployer() {
    }

    public void init(ConfigurationContext configCtx) {
        this.cfgCtx = configCtx;
    }

    private boolean isHotDeploymentEnabled() {
        try {
            return this.getSynapseConfiguration().isAllowHotUpdate();
        }
        catch (DeploymentException e) {
            log.warn((Object)"Error while retrieving the SynapseConfiguration", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        String filename = SynapseArtifactDeploymentStore.getNormalizedAbsolutePath(deploymentFileData.getAbsolutePath());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deployment of the synapse artifact from file : " + filename + " : STARTED"));
        }
        if (this.getServerContextInformation().getServerState() != ServerState.STARTED) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Skipped the artifact deployment (since the Synapse server doesn't seem to be started yet), from file : " + deploymentFileData.getAbsolutePath()));
            }
            return;
        }
        if (!this.isHotDeploymentEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Hot deployment has been suspended - Ignoring");
            }
            return;
        }
        SynapseArtifactDeploymentStore deploymentStore = this.getSynapseConfiguration().getArtifactDeploymentStore();
        if (deploymentStore.isRestoredFile(filename)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Restored artifact detected with filename : " + filename));
            }
            deploymentStore.removeRestoredFile(filename);
            return;
        }
        try {
            FileInputStream in = FileUtils.openInputStream((File)new File(filename));
            try {
                OMElement element = OMXMLBuilderFactory.createOMBuilder((InputStream)in).getDocumentElement();
                Properties properties = new Properties();
                properties.put("resolve.root", this.getSynapseEnvironment().getServerContextInformation().getServerConfigurationInformation().getResolveRoot());
                String artifactName = null;
                if (deploymentStore.isUpdatingArtifact(filename)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Updating artifact detected with filename : " + filename));
                    }
                    String existingArtifactName = deploymentStore.getUpdatingArtifactWithFileName(filename);
                    deploymentStore.removeUpdatingArtifact(filename);
                    try {
                        artifactName = this.updateSynapseArtifact(element, filename, existingArtifactName, properties);
                    }
                    catch (SynapseArtifactDeploymentException sade) {
                        log.error((Object)("Update of the Synapse Artifact from file : " + filename + " : Failed!"), (Throwable)sade);
                        log.info((Object)("The updated file has been backed up into : " + this.backupFile(deploymentFileData.getFile())));
                        log.info((Object)("Restoring the existing artifact into the file : " + filename));
                        this.restoreSynapseArtifact(existingArtifactName);
                        artifactName = existingArtifactName;
                    }
                } else {
                    try {
                        artifactName = this.deploySynapseArtifact(element, filename, properties);
                    }
                    catch (SynapseArtifactDeploymentException sade) {
                        log.error((Object)("Deployment of the Synapse Artifact from file : " + filename + " : Failed!"), (Throwable)sade);
                        log.info((Object)("The file has been backed up into : " + this.backupFile(deploymentFileData.getFile())));
                    }
                }
                if (artifactName != null) {
                    deploymentStore.addArtifact(filename, artifactName);
                }
            }
            finally {
                ((InputStream)in).close();
            }
        }
        catch (IOException ex) {
            this.handleDeploymentError("Deployment of synapse artifact failed. Error reading " + filename + " : " + ex.getMessage(), ex, filename);
        }
        catch (OMException ex) {
            this.handleDeploymentError("Deployment of synapse artifact failed. Error parsing " + filename + " : " + ex.getMessage(), (Exception)((Object)ex), filename);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deployment of the synapse artifact from file : " + filename + " : COMPLETED"));
        }
    }

    public void undeploy(String fileName) throws DeploymentException {
        SynapseArtifactDeploymentStore deploymentStore;
        if (!this.isHotDeploymentEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Hot deployment has been suspended - Ignoring");
            }
            return;
        }
        fileName = SynapseArtifactDeploymentStore.getNormalizedAbsolutePath(fileName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Undeployment of the synapse artifact from file : " + fileName + " : STARTED"));
        }
        if ((deploymentStore = this.getSynapseConfiguration().getArtifactDeploymentStore()).isBackedUpArtifact(fileName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("BackedUp artifact detected with filename : " + fileName));
            }
            deploymentStore.removeBackedUpArtifact(fileName);
            return;
        }
        if (deploymentStore.containsFileName(fileName)) {
            File undeployingFile = new File(fileName);
            if (undeployingFile.exists()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Marking artifact as updating from file : " + fileName));
                }
                if (!deploymentStore.isRestoredFile(fileName)) {
                    deploymentStore.addUpdatingArtifact(fileName, deploymentStore.getArtifactNameForFile(fileName));
                    deploymentStore.removeArtifactWithFileName(fileName);
                }
            } else {
                String artifactName = deploymentStore.getArtifactNameForFile(fileName);
                try {
                    this.undeploySynapseArtifact(artifactName);
                    deploymentStore.removeArtifactWithFileName(fileName);
                }
                catch (SynapseArtifactDeploymentException sade) {
                    log.error((Object)("Unable to undeploy the artifact from file : " + fileName), (Throwable)sade);
                    log.info((Object)("Restoring the artifact into the file : " + fileName));
                    this.restoreSynapseArtifact(artifactName);
                }
            }
        } else {
            String msg = "Artifact representing the filename " + fileName + " is not deployed on Synapse";
            log.error((Object)msg);
            throw new DeploymentException(msg);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("UnDeployment of the synapse artifact from file : " + fileName + " : COMPLETED"));
        }
    }

    public void setDirectory(String directory) {
    }

    public void setExtension(String extension) {
    }

    public abstract String deploySynapseArtifact(OMElement var1, String var2, Properties var3);

    public abstract String updateSynapseArtifact(OMElement var1, String var2, String var3, Properties var4);

    public abstract void undeploySynapseArtifact(String var1);

    public abstract void restoreSynapseArtifact(String var1);

    protected SynapseConfiguration getSynapseConfiguration() throws DeploymentException {
        Parameter synCfgParam = this.cfgCtx.getAxisConfiguration().getParameter("synapse.config");
        if (synCfgParam == null) {
            throw new DeploymentException("SynapseConfiguration not found. Unable to continue the deployment operation.");
        }
        return (SynapseConfiguration)synCfgParam.getValue();
    }

    protected SynapseEnvironment getSynapseEnvironment() throws DeploymentException {
        Parameter synCfgParam = this.cfgCtx.getAxisConfiguration().getParameter("synapse.env");
        if (synCfgParam == null) {
            throw new DeploymentException("SynapseEnvironment not found. Unable to continue the deployment operation.");
        }
        return (SynapseEnvironment)synCfgParam.getValue();
    }

    protected ServerConfigurationInformation getServerConfigurationInformation() throws DeploymentException {
        Parameter serverCfgParam = this.cfgCtx.getAxisConfiguration().getParameter("synapse.server.config.info");
        if (serverCfgParam == null) {
            throw new DeploymentException("SynapseConfigurationInformation not found. Unable to continue the deployment operation.");
        }
        return (ServerConfigurationInformation)serverCfgParam.getValue();
    }

    protected ServerContextInformation getServerContextInformation() throws DeploymentException {
        Parameter serverCtxParam = this.cfgCtx.getAxisConfiguration().getParameter("synapse.server.context.info");
        if (serverCtxParam == null) {
            throw new DeploymentException("ServerContextInformation not found. Unable to continue the deployment operation.");
        }
        return (ServerContextInformation)serverCtxParam.getValue();
    }

    protected void writeToFile(OMElement content, String fileName) throws Exception {
        SynapseArtifactDeploymentStore deploymentStore = this.getSynapseConfiguration().getArtifactDeploymentStore();
        deploymentStore.addRestoredArtifact(fileName);
        FileOutputStream out = FileUtils.openOutputStream((File)new File(fileName));
        XMLPrettyPrinter.prettify((OMElement)content, (OutputStream)out);
        out.flush();
        ((OutputStream)out).close();
    }

    protected void waitForCompletion() {
        long timeout = 2000L;
        Parameter param = this.cfgCtx.getAxisConfiguration().getParameter("hotupdate.timeout");
        if (param != null && param.getValue() != null) {
            timeout = Long.parseLong(param.getValue().toString());
        }
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void handleSynapseArtifactDeploymentError(String msg) {
        this.deployerLog.error((Object)msg);
        throw new SynapseArtifactDeploymentException(msg);
    }

    protected void handleSynapseArtifactDeploymentError(String msg, Exception e) {
        this.deployerLog.error((Object)msg, (Throwable)e);
        throw new SynapseArtifactDeploymentException(msg, e);
    }

    private void handleDeploymentError(String msg, Exception e, String fileName) throws DeploymentException {
        fileName = SynapseArtifactDeploymentStore.getNormalizedAbsolutePath(fileName);
        log.error((Object)msg, (Throwable)e);
        SynapseArtifactDeploymentStore deploymentStore = this.getSynapseConfiguration().getArtifactDeploymentStore();
        if (deploymentStore.isUpdatingArtifact(fileName)) {
            this.backupFile(new File(fileName));
            log.info((Object)("Restoring the existing artifact into the file : " + fileName));
            this.restoreSynapseArtifact(deploymentStore.getUpdatingArtifactWithFileName(fileName));
            deploymentStore.addArtifact(fileName, deploymentStore.getUpdatingArtifactWithFileName(fileName));
            deploymentStore.removeUpdatingArtifact(fileName);
        }
    }

    private String backupFile(File file) throws DeploymentException {
        String filePath = SynapseArtifactDeploymentStore.getNormalizedAbsolutePath(file.getAbsolutePath());
        SynapseArtifactDeploymentStore deploymentStore = this.getSynapseConfiguration().getArtifactDeploymentStore();
        deploymentStore.addBackedUpArtifact(filePath);
        String backupFilePath = filePath + ".back";
        int backupIndex = 0;
        while (backupIndex >= 0) {
            if (new File(backupFilePath).exists()) {
                backupFilePath = filePath + "." + ++backupIndex + ".back";
                continue;
            }
            backupIndex = -1;
            try {
                FileUtils.moveFile((File)file, (File)new File(backupFilePath));
            }
            catch (IOException e) {
                this.handleSynapseArtifactDeploymentError("Error while backing up the artifact: " + file.getName(), e);
            }
        }
        return backupFilePath;
    }
}

