/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerConfigurationInformation;
import org.apache.synapse.ServerConfigurationInformationFactory;
import org.apache.synapse.ServerManager;

public class SynapseStartUpServlet
extends HttpServlet {
    private static Log log = LogFactory.getLog(SynapseStartUpServlet.class);
    private static final String ALREADY_INITED = "synapseAlreadyInited";
    public static final String SYNAPSE_SERVER_MANAGER = "synapse.server.manager";

    public void init() throws ServletException {
        ServletConfig servletConfig = this.getServletConfig();
        ServletContext servletContext = servletConfig.getServletContext();
        if (Boolean.TRUE.equals(servletContext.getAttribute(ALREADY_INITED))) {
            return;
        }
        ServerManager serverManager = new ServerManager();
        ServerConfigurationInformation information = ServerConfigurationInformationFactory.createServerConfigurationInformation(servletConfig);
        serverManager.init(information, null);
        serverManager.start();
        servletContext.setAttribute(ALREADY_INITED, (Object)Boolean.TRUE);
        servletContext.setAttribute(SYNAPSE_SERVER_MANAGER, (Object)serverManager);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    public void destroy() {
        try {
            Object o = this.getServletConfig().getServletContext().getAttribute(SYNAPSE_SERVER_MANAGER);
            if (o != null && o instanceof ServerManager) {
                ServerManager serverManager = (ServerManager)o;
                serverManager.stop();
                serverManager.shutdown();
                this.getServletContext().removeAttribute(ALREADY_INITED);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error stopping the Synapse listener manager", (Throwable)e);
        }
    }
}

