/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.oval.interceptor;

import com.opensymphony.xwork2.FileManager;
import com.opensymphony.xwork2.FileManagerFactory;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.oval.configuration.Configurer;
import net.sf.oval.configuration.annotation.AnnotationsConfigurer;
import net.sf.oval.configuration.annotation.JPAAnnotationsConfigurer;
import net.sf.oval.configuration.xml.XMLConfigurer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.oval.interceptor.OValValidationManager;

public class DefaultOValValidationManager
implements OValValidationManager {
    private static final Logger LOG = LogManager.getLogger(DefaultOValValidationManager.class);
    protected static final String VALIDATION_CONFIG_SUFFIX = "-validation.xml";
    protected final Map<String, List<Configurer>> validatorCache = new HashMap<String, List<Configurer>>();
    protected final Map<String, Configurer> validatorFileCache = new HashMap<String, Configurer>();
    protected boolean validateJPAAnnotations;
    private boolean reloadConfigs;
    private FileManager fileManager;

    @Inject(value="struts.configuration.xml.reload", required=false)
    public void setReloadingConfigs(String reloadingConfigs) {
        this.reloadConfigs = Boolean.parseBoolean(reloadingConfigs);
    }

    @Inject
    public void setFileManagerFactory(FileManagerFactory fileManagerFactory) {
        this.fileManager = fileManagerFactory.getFileManager();
    }

    @Override
    public synchronized List<Configurer> getConfigurers(Class<?> clazz, String context, boolean validateJPAAnnotations) {
        this.validateJPAAnnotations = validateJPAAnnotations;
        String validatorKey = DefaultOValValidationManager.buildValidatorKey(clazz, context);
        if (this.validatorCache.containsKey(validatorKey)) {
            if (this.reloadConfigs) {
                List<Configurer> configurers = this.buildXMLConfigurers(clazz, context, true, null);
                this.addAdditionalConfigurers(configurers);
                this.validatorCache.put(validatorKey, configurers);
            }
        } else {
            List<Configurer> configurers = this.buildXMLConfigurers(clazz, context, false, null);
            this.addAdditionalConfigurers(configurers);
            this.validatorCache.put(validatorKey, configurers);
        }
        return this.validatorCache.get(validatorKey);
    }

    private void addAdditionalConfigurers(List<Configurer> configurers) {
        AnnotationsConfigurer annotationsConfigurer = new AnnotationsConfigurer();
        configurers.add((Configurer)annotationsConfigurer);
        if (this.validateJPAAnnotations) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding support for JPA annotations validations in OVal");
            }
            configurers.add((Configurer)new JPAAnnotationsConfigurer());
        }
    }

    protected static String buildValidatorKey(Class<?> clazz, String context) {
        return clazz.getName() + "/" + context;
    }

    private List<Configurer> buildXMLConfigurers(Class<?> clazz, String context, boolean checkFile, Set<String> checked) {
        ArrayList<Configurer> configurers = new ArrayList<Configurer>();
        if (checked == null) {
            checked = new TreeSet<String>();
        } else if (checked.contains(clazz.getName())) {
            return configurers;
        }
        if (clazz.isInterface()) {
            for (Class<?> anInterface : clazz.getInterfaces()) {
                configurers.addAll(this.buildXMLConfigurers(anInterface, context, checkFile, checked));
            }
        } else if (!clazz.equals(Object.class)) {
            configurers.addAll(this.buildXMLConfigurers(clazz.getSuperclass(), context, checkFile, checked));
        }
        for (Class<?> anInterface1 : clazz.getInterfaces()) {
            if (checked.contains(anInterface1.getName())) continue;
            this.addIfNotNull(configurers, (Configurer)this.buildClassValidatorConfigs(anInterface1, checkFile));
            if (context != null) {
                this.addIfNotNull(configurers, (Configurer)this.buildAliasValidatorConfigs(anInterface1, context, checkFile));
            }
            checked.add(anInterface1.getName());
        }
        this.addIfNotNull(configurers, (Configurer)this.buildClassValidatorConfigs(clazz, checkFile));
        if (context != null) {
            this.addIfNotNull(configurers, (Configurer)this.buildAliasValidatorConfigs(clazz, context, checkFile));
        }
        checked.add(clazz.getName());
        return configurers;
    }

    protected void addIfNotNull(List<Configurer> configurers, Configurer configurer) {
        if (configurer != null) {
            configurers.add(configurer);
        }
    }

    protected XMLConfigurer buildAliasValidatorConfigs(Class<?> aClass, String context, boolean checkFile) {
        String fileName = aClass.getName().replace('.', '/') + "-" + context + VALIDATION_CONFIG_SUFFIX;
        return this.loadFile(fileName, aClass, checkFile);
    }

    protected XMLConfigurer buildClassValidatorConfigs(Class<?> aClass, boolean checkFile) {
        String fileName = aClass.getName().replace('.', '/') + VALIDATION_CONFIG_SUFFIX;
        return this.loadFile(fileName, aClass, checkFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected XMLConfigurer loadFile(String fileName, Class<?> clazz, boolean checkFile) {
        URL fileUrl = ClassLoaderUtil.getResource((String)fileName, clazz);
        if (!checkFile || !this.fileManager.fileNeedsReloading(fileUrl)) {
            if (this.validatorFileCache.containsKey(fileName)) return (XMLConfigurer)this.validatorFileCache.get(fileName);
        }
        try (InputStream is = this.fileManager.loadFile(fileUrl);){
            if (is == null) return null;
            LOG.debug("Loading validation xml file [{}]", (Object)fileName);
            XMLConfigurer configurer = new XMLConfigurer();
            configurer.fromXML(is);
            this.validatorFileCache.put(fileName, (Configurer)configurer);
            XMLConfigurer xMLConfigurer = configurer;
            return xMLConfigurer;
        }
        catch (IOException e) {
            LOG.error("Unable to close input stream for [{}] ", (Object)fileName, (Object)e);
            return null;
        }
    }
}

