/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl.style;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.sling.xss.impl.xml.AntiSamyPolicy;
import org.apache.sling.xss.impl.xml.Property;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.NegativeCondition;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SiblingSelector;

public class ValidatingDocumentHandler
implements DocumentHandler {
    private final AntiSamyPolicy.CssPolicy cssPolicy;
    private final StringBuilder cleanCss = new StringBuilder();
    private final boolean isInLine;
    private boolean isInSelector;

    public ValidatingDocumentHandler(AntiSamyPolicy.CssPolicy cssPolicy, boolean isInLine) {
        this.cssPolicy = cssPolicy;
        this.isInLine = isInLine;
    }

    @Override
    public void startSelector(SelectorList selectors) throws CSSException {
        List<String> validSelectors = this.validateSelectors(selectors);
        if (validSelectors.isEmpty()) {
            return;
        }
        StringJoiner joiner = new StringJoiner(", ", "", " {\n");
        validSelectors.forEach(joiner::add);
        this.cleanCss.append(joiner.toString());
        this.isInSelector = true;
    }

    @Override
    public void endSelector(SelectorList selectors) throws CSSException {
        if (!this.isInSelector) {
            return;
        }
        this.cleanCss.append("}\n");
        this.isInSelector = false;
    }

    @Override
    public void property(String name, LexicalUnit value, boolean important) throws CSSException {
        if (!this.isInSelector && !this.isInLine) {
            return;
        }
        List<String> validPropertyValues = this.validatePropertyValues(name, value);
        if (validPropertyValues.isEmpty()) {
            return;
        }
        this.cleanCss.append(validPropertyValues.stream().map(s -> important ? s + " !important" : s).collect(Collectors.joining(" ", "\t" + name + ": ", ";\n")));
    }

    private List<String> validateSelectors(SelectorList selectors) {
        ArrayList<String> selectorNames = new ArrayList<String>();
        for (int i = 0; i < selectors.getLength(); ++i) {
            Selector selector = selectors.item(i);
            if (!this.isValidSelector(selector)) continue;
            selectorNames.add(selector.toString());
        }
        return selectorNames;
    }

    private boolean isValidSelector(Selector selector) {
        switch (selector.getSelectorType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: {
                return this.cssPolicy.isValidElementName(selector.toString().toLowerCase(Locale.ENGLISH));
            }
            case 12: {
                SiblingSelector sibling = (SiblingSelector)selector;
                return this.isValidSelector(sibling.getSiblingSelector()) && this.isValidSelector(sibling.getSelector());
            }
            case 0: {
                ConditionalSelector conditional = (ConditionalSelector)selector;
                return this.isValidSelector(conditional.getSimpleSelector()) && this.isValidCondition(conditional.getCondition());
            }
            case 10: 
            case 11: {
                DescendantSelector descendant = (DescendantSelector)selector;
                return this.isValidSelector(descendant.getAncestorSelector()) && this.isValidSelector(descendant.getSimpleSelector());
            }
        }
        return false;
    }

    private boolean isValidCondition(Condition condition) {
        switch (condition.getConditionType()) {
            case 9: {
                return this.cssPolicy.isValidClassName(condition.toString().toLowerCase(Locale.ENGLISH));
            }
            case 5: {
                return this.cssPolicy.isValidId(condition.toString().toLowerCase(Locale.ENGLISH));
            }
            case 0: 
            case 1: {
                CombinatorCondition comb = (CombinatorCondition)condition;
                return this.isValidCondition(comb.getFirstCondition()) && this.isValidCondition(comb.getSecondCondition());
            }
            case 2: {
                return this.isValidCondition(((NegativeCondition)condition).getCondition());
            }
            case 10: {
                return this.cssPolicy.isValidPseudoElementName(condition.toString().toLowerCase(Locale.ENGLISH));
            }
            case 4: 
            case 7: 
            case 8: {
                return false;
            }
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private List<String> validatePropertyValues(String name, LexicalUnit value) {
        ArrayList<String> validPropertyValues = new ArrayList<String>();
        while (value != null) {
            String stringValue = this.lexicalValueToString(value);
            value = value.getNextLexicalUnit();
            boolean isValid = this.validateProperty(name, stringValue);
            if (!isValid) continue;
            validPropertyValues.add(stringValue);
        }
        return validPropertyValues;
    }

    public String getValidCss() {
        return this.cleanCss.toString();
    }

    private boolean validateProperty(String name, String lexicalValueToString) {
        if (lexicalValueToString == null) {
            return false;
        }
        Property property = this.cssPolicy.getCssRules().get(name);
        if (property == null) {
            return false;
        }
        if (property.getLiterals().contains(lexicalValueToString)) {
            return true;
        }
        if (property.getRegexps().stream().anyMatch(p -> p.matcher(lexicalValueToString).matches())) {
            return true;
        }
        return property.getShorthands().stream().anyMatch(s -> this.validateProperty((String)s, lexicalValueToString));
    }

    private String lexicalValueToString(LexicalUnit lu) {
        switch (lu.getLexicalUnitType()) {
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 42: {
                return lu.getFloatValue() + lu.getDimensionUnitText();
            }
            case 13: {
                return String.valueOf(lu.getIntegerValue());
            }
            case 14: {
                return String.valueOf(lu.getFloatValue());
            }
            case 35: 
            case 36: {
                Object stringValue = lu.getStringValue();
                if (((String)stringValue).indexOf(" ") != -1) {
                    stringValue = "\"" + (String)stringValue + "\"";
                }
                return stringValue;
            }
            case 24: {
                return "url(" + lu.getStringValue() + ")";
            }
            case 27: {
                return this.toRgbString(lu);
            }
            case 12: {
                return "inherit";
            }
            case 0: {
                return ",";
            }
        }
        return null;
    }

    private String toRgbString(LexicalUnit lu) {
        StringBuilder sb = new StringBuilder();
        LexicalUnit param = lu.getParameters();
        sb.append("rgb(");
        sb.append(param.getIntegerValue());
        sb.append(',');
        param = param.getNextLexicalUnit();
        param = param.getNextLexicalUnit();
        sb.append(param.getIntegerValue());
        sb.append(',');
        param = param.getNextLexicalUnit();
        param = param.getNextLexicalUnit();
        sb.append(param.getIntegerValue());
        sb.append(')');
        return sb.toString();
    }

    @Override
    public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
    }

    @Override
    public void startDocument(InputSource source) throws CSSException {
    }

    @Override
    public void endDocument(InputSource source) throws CSSException {
    }

    @Override
    public void comment(String text) throws CSSException {
    }

    @Override
    public void ignorableAtRule(String atRule) throws CSSException {
    }

    @Override
    public void namespaceDeclaration(String prefix, String uri) throws CSSException {
    }

    @Override
    public void startMedia(SACMediaList media) throws CSSException {
    }

    @Override
    public void endMedia(SACMediaList media) throws CSSException {
    }

    @Override
    public void startPage(String name, String pseudo_page) throws CSSException {
    }

    @Override
    public void endPage(String name, String pseudo_page) throws CSSException {
    }

    @Override
    public void startFontFace() throws CSSException {
    }

    @Override
    public void endFontFace() throws CSSException {
    }
}

