/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.mount;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.jackrabbit.oak.spi.mount.Mount;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.mount.Mounts;
import org.jetbrains.annotations.NotNull;

final class SimpleMountInfoProvider
implements MountInfoProvider {
    private final Map<String, Mount> nameToMount;
    private final Mount defMount;
    private final boolean hasMounts;
    private final List<Mount> mounts;

    SimpleMountInfoProvider(List<Mount> mountInfos) {
        this.mounts = List.copyOf(mountInfos);
        this.nameToMount = mountInfos.stream().collect(Collectors.toMap(Mount::getName, mi -> mi));
        this.hasMounts = !this.mounts.isEmpty();
        this.defMount = new Mounts.DefaultMount(this.mounts);
    }

    @Override
    @NotNull
    public Mount getMountByPath(String path) {
        for (Mount m : this.mounts) {
            if (!m.isMounted(path)) continue;
            return m;
        }
        return this.defMount;
    }

    @Override
    @NotNull
    public Collection<Mount> getNonDefaultMounts() {
        return this.mounts;
    }

    @Override
    public Mount getMountByName(String name) {
        return this.nameToMount.get(name);
    }

    @Override
    public boolean hasNonDefaultMounts() {
        return this.hasMounts;
    }

    @Override
    @NotNull
    public Collection<Mount> getMountsPlacedUnder(String path) {
        ArrayList<Mount> mounts = new ArrayList<Mount>(1);
        for (Mount mount : this.mounts) {
            if (!mount.isUnder(path)) continue;
            mounts.add(mount);
        }
        return mounts;
    }

    @Override
    @NotNull
    public Collection<Mount> getMountsPlacedDirectlyUnder(String path) {
        ArrayList<Mount> mounts = new ArrayList<Mount>(1);
        for (Mount mount : this.mounts) {
            if (!mount.isDirectlyUnder(path)) continue;
            mounts.add(mount);
        }
        return mounts;
    }

    @Override
    @NotNull
    public Mount getDefaultMount() {
        return this.defMount;
    }
}

