/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.oak.restrictions.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceTypePattern
implements RestrictionPattern {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceTypePattern.class);
    static final String DEFAULT_PATH = ".";
    static final String PATH_MARKER = "@";
    static final String SLING_RESOURCE_TYPE = "sling:resourceType";
    private final String limitedToPath;
    private final boolean matchChildren;
    private final Map<String, Set<String>> resourceTypesByPath;

    ResourceTypePattern(@NotNull Iterable<String> resourceTypesRaw, String limitedToPath, boolean matchChildren) {
        this.limitedToPath = limitedToPath;
        this.matchChildren = matchChildren;
        LinkedHashMap<String, HashSet<String>> resourceTypesByPath = new LinkedHashMap<String, HashSet<String>>();
        for (String resourceTypeRaw : resourceTypesRaw) {
            String resourceType;
            String path;
            if (resourceTypeRaw.contains(PATH_MARKER)) {
                String[] bits = resourceTypeRaw.trim().split(PATH_MARKER, 2);
                path = bits[1];
                resourceType = bits[0];
            } else {
                path = DEFAULT_PATH;
                resourceType = resourceTypeRaw;
            }
            HashSet<String> resourceTypesForPath = (HashSet<String>)resourceTypesByPath.get(path);
            if (resourceTypesForPath == null) {
                resourceTypesForPath = new HashSet<String>();
                resourceTypesByPath.put(path, resourceTypesForPath);
            }
            resourceTypesForPath.add(resourceType);
        }
        this.resourceTypesByPath = Collections.unmodifiableMap(resourceTypesByPath);
        LOG.trace("pattern setup with resourceTypesByPath={}", this.resourceTypesByPath);
    }

    String getLimitedToPath() {
        return this.limitedToPath;
    }

    boolean isMatchChildren() {
        return this.matchChildren;
    }

    public boolean matches(@NotNull Tree tree, @Nullable PropertyState property) {
        boolean isMatch = this.matchesAtTree(tree);
        if (!isMatch && this.matchChildren) {
            Tree treeCursor = tree;
            while (!isMatch && !treeCursor.isRoot()) {
                if (!(treeCursor = treeCursor.getParent()).getPath().startsWith(this.limitedToPath)) {
                    if (!LOG.isTraceEnabled()) break;
                    LOG.trace("Breaking parent traversal loop: tree={}, limitedToPath={}", (Object)treeCursor.getPath(), (Object)this.limitedToPath);
                    break;
                }
                isMatch = this.matchesAtTree(treeCursor);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Match for " + tree.getPath() + ": " + (isMatch ? "YES" : "NO") + " (" + this + ")");
        }
        return isMatch;
    }

    private boolean matchesAtTree(Tree tree) {
        boolean isResourceTypeMatch = false;
        for (String path : this.resourceTypesByPath.keySet()) {
            Tree treeToCheck = tree;
            if (!DEFAULT_PATH.equals(path)) {
                try {
                    String[] segments;
                    for (String string : segments = path.split("/")) {
                        treeToCheck = treeToCheck.getChild(string);
                    }
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
            }
            Set<String> resourceTypesForPath = this.resourceTypesByPath.get(path);
            String actualResourceType = this.getResourceTypeFromTree(treeToCheck);
            isResourceTypeMatch = resourceTypesForPath.contains(actualResourceType);
            if (LOG.isTraceEnabled()) {
                LOG.trace("isResourceTypeMatch={} (checked at path {} at sub path {})", new Object[]{isResourceTypeMatch, tree.getPath(), path});
            }
            if (!isResourceTypeMatch) continue;
            break;
        }
        return isResourceTypeMatch;
    }

    public String getResourceTypeFromTree(Tree treeToCheck) {
        PropertyState property = treeToCheck.getProperty(SLING_RESOURCE_TYPE);
        return property != null && !property.isArray() ? (String)property.getValue(Type.STRING) : null;
    }

    public boolean matches(@NotNull String path) {
        return false;
    }

    public boolean matches() {
        return false;
    }

    public String toString() {
        return "ResourceTypePattern [limitedToPath=" + this.limitedToPath + ", matchChildren=" + this.matchChildren + ", resourceTypesByPath=" + this.resourceTypesByPath + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.limitedToPath == null ? 0 : this.limitedToPath.hashCode());
        result = 31 * result + (this.matchChildren ? 1231 : 1237);
        result = 31 * result + (this.resourceTypesByPath == null ? 0 : this.resourceTypesByPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceTypePattern other = (ResourceTypePattern)obj;
        if (this.limitedToPath == null ? other.limitedToPath != null : !this.limitedToPath.equals(other.limitedToPath)) {
            return false;
        }
        if (this.matchChildren != other.matchChildren) {
            return false;
        }
        return !(this.resourceTypesByPath == null ? other.resourceTypesByPath != null : !this.resourceTypesByPath.equals(other.resourceTypesByPath));
    }
}

