/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.subscriber;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.apache.sling.distribution.journal.HandlerAdapter;
import org.apache.sling.distribution.journal.MessageInfo;
import org.apache.sling.distribution.journal.MessagingProvider;
import org.apache.sling.distribution.journal.Reset;
import org.apache.sling.distribution.journal.messages.ClearCommand;
import org.apache.sling.distribution.journal.shared.Topics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandPoller
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(CommandPoller.class);
    private final String subSlingId;
    private final String subAgentName;
    private final Closeable poller;
    private final AtomicLong clearOffset = new AtomicLong(-1L);
    private final Runnable callback;

    public CommandPoller(MessagingProvider messagingProvider, Topics topics, String subSlingId, String subAgentName, Runnable callback) {
        this.subSlingId = subSlingId;
        this.subAgentName = subAgentName;
        this.callback = callback;
        this.poller = messagingProvider.createPoller(topics.getCommandTopic(), Reset.earliest, new HandlerAdapter[]{HandlerAdapter.create(ClearCommand.class, this::handleCommandMessage)});
    }

    public boolean isCleared(long offset) {
        return offset <= this.clearOffset.longValue();
    }

    private void handleCommandMessage(MessageInfo info, ClearCommand command) {
        if (!this.subSlingId.equals(command.getSubSlingId()) || !this.subAgentName.equals(command.getSubAgentName())) {
            LOG.debug("Skip command for subSlingId {}", (Object)command.getSubSlingId());
            return;
        }
        this.handleClearCommand(command);
        this.callback.run();
    }

    private void handleClearCommand(ClearCommand command) {
        long oldOffset = this.clearOffset.get();
        long newOffset = this.updateClearOffsetIfLarger(command.getOffset());
        LOG.info("Handled clear command {}. Old clear offset was {}, new clear offset is {}.", new Object[]{command, oldOffset, newOffset});
    }

    private long updateClearOffsetIfLarger(long offset) {
        return this.clearOffset.accumulateAndGet(offset, Math::max);
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.poller);
    }
}

