/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.publisher;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.sling.distribution.DistributionRequestState;
import org.apache.sling.distribution.DistributionResponse;
import org.apache.sling.distribution.DistributionResponseInfo;

@ParametersAreNonnullByDefault
public final class SimpleDistributionResponse
implements DistributionResponse {
    private final DistributionRequestState state;
    private final String message;
    private final DistributionResponseInfo info;

    public SimpleDistributionResponse(DistributionRequestState state, String message, DistributionResponseInfo info) {
        Objects.requireNonNull(info);
        this.state = state;
        this.message = message;
        this.info = info;
    }

    public SimpleDistributionResponse(DistributionRequestState state, String message) {
        this(state, message, DistributionResponseInfo.NONE);
    }

    public boolean isSuccessful() {
        return this.state.equals((Object)DistributionRequestState.ACCEPTED) || this.state.equals((Object)DistributionRequestState.DISTRIBUTED);
    }

    @Nonnull
    public DistributionRequestState getState() {
        return this.state;
    }

    public String getMessage() {
        return this.message;
    }

    @Nonnull
    public DistributionResponseInfo getDistributionInfo() {
        return this.info;
    }
}

